/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetIconProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.FetchImageExecutor;
import com.android.tools.idea.ui.resourcemanager.rendering.ImageCache;
import com.android.tools.idea.ui.resourcemanager.rendering.ResourceRenderingUtilsKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewManager;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewManagerKt;
import com.android.tools.idea.ui.resourcemanager.rendering.SlowResourcePreviewProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J>\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0010H\u0002J<\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019H\u0016J\u0018\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001dH\u0002J\u0018\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewManager;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetIconProvider;", "imageCache", "Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;", "resourcePreviewProvider", "Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;", "(Lcom/android/tools/idea/ui/resourcemanager/rendering/ImageCache;Lcom/android/tools/idea/ui/resourcemanager/rendering/SlowResourcePreviewProvider;)V", "PLACEHOLDER_IMAGE", "Ljava/awt/image/BufferedImage;", "contentRatio", "", "fetchImageExecutor", "Lcom/android/tools/idea/ui/resourcemanager/rendering/FetchImageExecutor;", "imageIcon", "Ljavax/swing/ImageIcon;", "supportsTransparency", "", "getSupportsTransparency", "()Z", "setSupportsTransparency", "(Z)V", "fetchImage", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/Asset;", "refreshCallBack", "Lkotlin/Function0;", "", "isStillVisible", "targetSize", "Ljava/awt/Dimension;", "forceImageRender", "getIcon", "assetToRender", "width", "", "height", "refreshCallback", "shouldBeRendered", "getScale", "target", "source", "scaleToFitIfNeeded", "image", "shouldScale", "scale", "intellij.android.core"})
public final class SlowResourcePreviewManager
implements AssetIconProvider {
    private final FetchImageExecutor fetchImageExecutor;
    private final BufferedImage PLACEHOLDER_IMAGE;
    private final ImageIcon imageIcon;
    private final double contentRatio;
    private boolean supportsTransparency;
    private final ImageCache imageCache;
    private final SlowResourcePreviewProvider resourcePreviewProvider;

    @Override
    public boolean getSupportsTransparency() {
        return this.supportsTransparency;
    }

    public void setSupportsTransparency(boolean bl) {
        this.supportsTransparency = bl;
    }

    @Override
    @NotNull
    public ImageIcon getIcon(@NotNull Asset assetToRender, int width, int height, @NotNull Function0<Unit> refreshCallback, @NotNull Function0<Boolean> shouldBeRendered) {
        Intrinsics.checkNotNullParameter((Object)assetToRender, (String)"assetToRender");
        Intrinsics.checkNotNullParameter(refreshCallback, (String)"refreshCallback");
        Intrinsics.checkNotNullParameter(shouldBeRendered, (String)"shouldBeRendered");
        if (height > 0 && width > 0) {
            BufferedImage bufferedImage;
            Dimension targetSize = new Dimension(width, height);
            BufferedImage image = SlowResourcePreviewManager.fetchImage$default(this, assetToRender, refreshCallback, shouldBeRendered, targetSize, false, 16, null);
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            double scale = this.getScale(targetSize, new Dimension(imageWidth, imageHeight));
            if (Intrinsics.areEqual((Object)image, (Object)this.PLACEHOLDER_IMAGE) ^ true && Intrinsics.areEqual((Object)image, (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()) ^ true && this.shouldScale(scale)) {
                BufferedImage bufferedImage2 = ImageUtil.toBufferedImage((Image)image);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"ImageUtil.toBufferedImage(image)");
                BufferedImage bufferedImage3 = bufferedImage2;
                if (scale < 1.0) {
                    BufferedImage bufferedImage4 = ImageUtils.scale((BufferedImage)bufferedImage3, (double)scale, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage4, (String)"ImageUtils.scale(bufferedImage, scale, scale)");
                    image = bufferedImage4;
                } else {
                    BufferedImage bufferedImage5 = ImageUtils.lowQualityFastScale((BufferedImage)bufferedImage3, (double)scale, (double)scale);
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage5, (String)"ImageUtils.lowQualityFas\u2026feredImage, scale, scale)");
                    image = bufferedImage5;
                    this.fetchImage(assetToRender, refreshCallback, shouldBeRendered, targetSize, true);
                }
            }
            this.imageIcon.setImage(Intrinsics.areEqual((Object)(bufferedImage = image), (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()) ? (Image)ResourceRenderingUtilsKt.createFailedIcon(targetSize) : (Intrinsics.areEqual((Object)bufferedImage, (Object)this.PLACEHOLDER_IMAGE) ? (Image)(this.shouldScale(scale) ? ImageUtils.lowQualityFastScale((BufferedImage)this.PLACEHOLDER_IMAGE, (double)scale, (double)scale) : this.PLACEHOLDER_IMAGE) : (Image)image));
            this.setSupportsTransparency(Intrinsics.areEqual((Object)image, (Object)ResourceRenderingUtilsKt.getERROR_IMAGE()) ^ true);
        } else {
            this.imageIcon.setImage(this.PLACEHOLDER_IMAGE);
        }
        return this.imageIcon;
    }

    private final boolean shouldScale(double scale) {
        double d = 1.0 - this.contentRatio;
        double d2 = 1.0 + this.contentRatio;
        double d3 = scale;
        return !(d3 >= d) || !(d3 <= d2);
    }

    private final double getScale(Dimension target, Dimension source) {
        double xScale = (double)target.width / source.getWidth();
        double yScale = (double)target.height / source.getHeight();
        boolean bl = false;
        return Math.min(xScale, yScale);
    }

    private final BufferedImage fetchImage(Asset asset, Function0<Unit> refreshCallBack, Function0<Boolean> isStillVisible, Dimension targetSize, boolean forceImageRender) {
        return ImageCache.computeAndGet$default(this.imageCache, asset, this.PLACEHOLDER_IMAGE, forceImageRender, refreshCallBack, null, (Function0)new Function0<CompletableFuture<? extends BufferedImage>>(this, isStillVisible, targetSize, asset){
            final /* synthetic */ SlowResourcePreviewManager this$0;
            final /* synthetic */ Function0 $isStillVisible;
            final /* synthetic */ Dimension $targetSize;
            final /* synthetic */ Asset $asset;

            @NotNull
            public final CompletableFuture<? extends BufferedImage> invoke() {
                CompletableFuture<Object> completableFuture;
                if (((Boolean)this.$isStillVisible.invoke()).booleanValue()) {
                    CompletableFuture<U> completableFuture2 = CompletableFuture.supplyAsync(new Supplier(this){
                        final /* synthetic */ fetchImage.1 this$0;

                        @Nullable
                        public final BufferedImage get() {
                            if (((Boolean)this.this$0.$isStillVisible.invoke()).booleanValue()) {
                                try {
                                    BufferedImage bufferedImage = SlowResourcePreviewManager.access$getResourcePreviewProvider$p(this.this$0.this$0).getSlowPreview(this.this$0.$targetSize.width, this.this$0.$targetSize.height, this.this$0.$asset);
                                    if (bufferedImage == null) {
                                        throw (Throwable)new Exception("Failed to resolve resource");
                                    }
                                    BufferedImage previewImage = bufferedImage;
                                    return SlowResourcePreviewManager.access$scaleToFitIfNeeded(this.this$0.this$0, previewImage, this.this$0.$targetSize);
                                }
                                catch (Exception throwable) {
                                    SlowResourcePreviewManagerKt.access$getLOG$p().warn("Error while rendering " + this.this$0.$asset, (Throwable)throwable);
                                    return ResourceRenderingUtilsKt.getERROR_IMAGE();
                                }
                            }
                            return null;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, SlowResourcePreviewManager.access$getFetchImageExecutor$p(this.this$0));
                    completableFuture = completableFuture2;
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"CompletableFuture.supply\u2026   }, fetchImageExecutor)");
                } else {
                    CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(null);
                    completableFuture = completableFuture3;
                    Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"CompletableFuture.completedFuture(null)");
                }
                return completableFuture;
            }
            {
                this.this$0 = slowResourcePreviewManager;
                this.$isStillVisible = function0;
                this.$targetSize = dimension2;
                this.$asset = asset;
                super(0);
            }
        }, 16, null);
    }

    static /* synthetic */ BufferedImage fetchImage$default(SlowResourcePreviewManager slowResourcePreviewManager, Asset asset, Function0 function0, Function0 function02, Dimension dimension2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return slowResourcePreviewManager.fetchImage(asset, (Function0<Unit>)function0, (Function0<Boolean>)function02, dimension2, bl);
    }

    private final BufferedImage scaleToFitIfNeeded(BufferedImage image, Dimension targetSize) {
        Dimension imageSize = new Dimension(image.getWidth(null), image.getHeight(null));
        double scale = this.getScale(targetSize, imageSize);
        if (this.shouldScale(scale)) {
            int newWidth = (int)((double)imageSize.width * scale);
            int newHeight = (int)((double)imageSize.height * scale);
            if (newWidth > 0 && newHeight > 0) {
                Image scaledImage = ImageUtil.scaleImage((Image)image, (double)scale);
                if (!(scaledImage instanceof BufferedImage)) {
                    Logger.getInstance(SlowResourcePreviewManager.class).error("Not BufferedImage");
                }
                BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)scaledImage);
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.toBufferedImage(scaledImage)");
                return bufferedImage;
            }
        }
        return image;
    }

    public SlowResourcePreviewManager(@NotNull ImageCache imageCache, @NotNull SlowResourcePreviewProvider resourcePreviewProvider) {
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        Intrinsics.checkNotNullParameter((Object)resourcePreviewProvider, (String)"resourcePreviewProvider");
        this.imageCache = imageCache;
        this.resourcePreviewProvider = resourcePreviewProvider;
        boolean $i$f$service = false;
        Class<FetchImageExecutor> serviceClass$iv = FetchImageExecutor.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
        }
        this.fetchImageExecutor = (FetchImageExecutor)object;
        this.PLACEHOLDER_IMAGE = this.resourcePreviewProvider.getPreviewPlaceholder();
        this.imageIcon = new ImageIcon(this.PLACEHOLDER_IMAGE);
        this.contentRatio = 0.1;
        this.supportsTransparency = true;
    }

    public static final /* synthetic */ SlowResourcePreviewProvider access$getResourcePreviewProvider$p(SlowResourcePreviewManager $this) {
        return $this.resourcePreviewProvider;
    }

    public static final /* synthetic */ BufferedImage access$scaleToFitIfNeeded(SlowResourcePreviewManager $this, BufferedImage image, Dimension targetSize) {
        return $this.scaleToFitIfNeeded(image, targetSize);
    }

    public static final /* synthetic */ FetchImageExecutor access$getFetchImageExecutor$p(SlowResourcePreviewManager $this) {
        return $this.fetchImageExecutor;
    }
}

