/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\u00020\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0000\u001a,\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u0019H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u001a\"\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0000\u001a \u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001a0\u0010!\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0010H\u0002\u001a \u0010$\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001a*\u0010%\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001c\u0010&\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u001a\u0014\u0010'\u001a\u00020\u0001*\u00020(2\u0006\u0010)\u001a\u00020\u0010H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"EMPTY_IMAGE", "Ljava/awt/image/BufferedImage;", "getEMPTY_IMAGE", "()Ljava/awt/image/BufferedImage;", "ERROR_IMAGE", "getERROR_IMAGE", "LAYOUT_PH_BACKGROUND", "Ljava/awt/Color;", "LAYOUT_PH_BAR_BACKGROUND", "LAYOUT_PH_BAR_BACKGROUND_ALT", "LAYOUT_PH_BORDER_COLOR", "LAYOUT_PH_FOREGROUND", "SIZE_TO_HEIGHT_CONSTANT", "", "createDrawablePlaceholderImage", "width", "", "height", "createFailedIcon", "dimension", "Ljava/awt/Dimension;", "createIcon", "color", "createImageAndPaint", "doPaint", "Lkotlin/Function1;", "Ljava/awt/Graphics2D;", "", "createLayoutPlaceholderImage", "createNavigationPlaceHolder", "layoutImage", "paintDrawablePlaceholderImage", "g", "paintFakeLayout", "x", "y", "paintLayoutPlaceHolderImage", "paintNavigationPlaceHolder", "scaleTo", "toScaledImage", "Ljavax/swing/Icon;", "size", "intellij.android.core"})
public final class ResourceRenderingUtilsKt {
    @NotNull
    private static final BufferedImage EMPTY_IMAGE = ResourceRenderingUtilsKt.createIcon(ResourceExplorerKt.getRESOURCE_DEBUG() ? (Color)JBColor.GREEN : new Color(0, 0, 0, 0));
    @NotNull
    private static final BufferedImage ERROR_IMAGE = ResourceRenderingUtilsKt.createIcon(ResourceExplorerKt.getRESOURCE_DEBUG() ? (Color)JBColor.RED : new Color(10, 10, 10, 10));
    private static final Color LAYOUT_PH_BAR_BACKGROUND = new Color((int)3212869760L, true);
    private static final Color LAYOUT_PH_BAR_BACKGROUND_ALT = new Color((int)0xBFB4B4B4L, true);
    private static final Color LAYOUT_PH_BACKGROUND = new Color((int)0xBFFFFFFFL, true);
    private static final Color LAYOUT_PH_BORDER_COLOR = new Color((int)3209711696L, true);
    private static final Color LAYOUT_PH_FOREGROUND = new Color((int)0xBFFFFFFFL, true);
    private static final float SIZE_TO_HEIGHT_CONSTANT = 0.866f;

    @NotNull
    public static final BufferedImage getEMPTY_IMAGE() {
        return EMPTY_IMAGE;
    }

    @NotNull
    public static final BufferedImage getERROR_IMAGE() {
        return ERROR_IMAGE;
    }

    @NotNull
    public static final BufferedImage createIcon(@Nullable Color color) {
        BufferedImage bufferedImage = ImageUtil.createImage((int)80, (int)80, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createImage(\n \u2026eredImage.TYPE_INT_ARGB\n)");
        BufferedImage bufferedImage2 = bufferedImage;
        boolean bl = false;
        boolean bl2 = false;
        BufferedImage $this$apply = bufferedImage2;
        boolean bl3 = false;
        Graphics2D graphics2D = $this$apply.createGraphics();
        boolean bl4 = false;
        boolean bl5 = false;
        Graphics2D $this$with = graphics2D;
        boolean bl6 = false;
        Graphics2D graphics2D2 = $this$with;
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D2, (String)"this");
        graphics2D2.setColor(color);
        $this$with.fillRect(0, 0, 80, 80);
        $this$with.dispose();
        return bufferedImage2;
    }

    @NotNull
    public static final BufferedImage createFailedIcon(@NotNull Dimension dimension2) {
        Intrinsics.checkNotNullParameter((Object)dimension2, (String)"dimension");
        BufferedImage image = new BufferedImage(dimension2.width, dimension2.height, 2);
        Object object = new JBLabel("Failed preview", StudioIcons.Common.WARNING, 0);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = object;
        boolean bl3 = false;
        $this$apply.setVerticalTextPosition(3);
        $this$apply.setHorizontalTextPosition(0);
        $this$apply.setForeground(AdtUiUtils.DEFAULT_FONT_COLOR);
        $this$apply.setBounds(new Rectangle(0, 0, dimension2.width, dimension2.height));
        $this$apply.validate();
        JBLabel label = object;
        object = image.createGraphics();
        bl = false;
        bl2 = false;
        Object g = object;
        boolean bl4 = false;
        JBFont jBFont = JBUI.Fonts.label((float)10.0f);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"JBUI.Fonts.label(10f)");
        JBFont labelFont = jBFont;
        String string = label.getText();
        Object object2 = g;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"g");
        Rectangle2D rectangle2D = labelFont.getStringBounds(string, ((Graphics2D)object2).getFontRenderContext());
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"labelFont.getStringBound\u2026ext, g.fontRenderContext)");
        double stringWidth = rectangle2D.getWidth();
        int targetWidth = dimension2.width - JBUI.scale((int)4);
        float f = (float)targetWidth / (float)stringWidth;
        float f2 = 1.0f;
        boolean bl5 = false;
        float scale = Math.min(f, f2);
        label.setFont((Font)labelFont.deriveFont(scale * (float)labelFont.getSize()));
        label.paint((Graphics)g);
        ((Graphics)g).dispose();
        return image;
    }

    @NotNull
    public static final BufferedImage createDrawablePlaceholderImage(int width, int height) {
        return ResourceRenderingUtilsKt.createImageAndPaint(width, height, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(width, height){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResourceRenderingUtilsKt.access$paintDrawablePlaceholderImage(it, this.$width, this.$height);
            }
            {
                this.$width = n;
                this.$height = n2;
                super(1);
            }
        }));
    }

    private static final void paintDrawablePlaceholderImage(Graphics2D g, int width, int height) {
        JBLabel jBLabel = new JBLabel(StudioIcons.Shell.ToolWindows.VISUAL_ASSETS, 0);
        boolean bl = false;
        boolean bl2 = false;
        JBLabel $this$apply = jBLabel;
        boolean bl3 = false;
        $this$apply.setBounds(new Rectangle(0, 0, width, height));
        $this$apply.validate();
        JBLabel label = jBLabel;
        label.paint((Graphics)g);
    }

    @NotNull
    public static final BufferedImage createLayoutPlaceholderImage(int width, int height) {
        return ResourceRenderingUtilsKt.createImageAndPaint(width, height, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(width, height){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResourceRenderingUtilsKt.access$paintLayoutPlaceHolderImage(it, this.$width, this.$height);
            }
            {
                this.$width = n;
                this.$height = n2;
                super(1);
            }
        }));
    }

    private static final void paintLayoutPlaceHolderImage(Graphics2D g, int width, int height) {
        float ratio = 0.75f;
        if (height < 10 || width < (int)((float)height * ratio)) {
            return;
        }
        int screenHeight = RangesKt.coerceAtLeast((int)10, (int)((int)((float)height * 0.9f)));
        int screenWidth = (int)((float)screenHeight * ratio);
        int screenX = (int)((float)width * 0.5f + 0.5f) - (int)((float)screenWidth * 0.5f + 0.5f);
        int screenY = (int)((float)height * 0.5f + 0.5f) - (int)((float)screenHeight * 0.5f + 0.5f);
        ResourceRenderingUtilsKt.paintFakeLayout(g, screenWidth, screenHeight, screenX, screenY);
    }

    private static final void paintFakeLayout(Graphics2D g, int width, int height, int x, int y) {
        int barHeight = (int)((float)width * 0.18f + 0.5f);
        int bottomBarY = height - barHeight + y;
        int bottomBarSegmentSize = (int)((float)width * 0.33f + 0.5f);
        int iconSize = (int)((float)barHeight * 0.6f + 0.5f);
        int iconXOffset = (int)((float)width * 0.04f + 0.5f);
        int iconY = (int)((float)barHeight * 0.2f + 0.5f) + y;
        Icon icon2 = StudioIcons.Common.BACK_ARROW;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"StudioIcons.Common.BACK_ARROW");
        BufferedImage arrow = ResourceRenderingUtilsKt.toScaledImage(icon2, iconSize);
        int arrowX = x + iconXOffset;
        Icon icon3 = StudioIcons.Common.OVERFLOW;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"StudioIcons.Common.OVERFLOW");
        BufferedImage overflow = ResourceRenderingUtilsKt.toScaledImage(icon3, iconSize);
        int overflowX = x + width - iconXOffset - iconSize;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(LAYOUT_PH_BACKGROUND);
        g.fillRect(x, y, width, height);
        g.setColor(LAYOUT_PH_BAR_BACKGROUND);
        g.fillRect(x, y, width, barHeight);
        g.setColor(LAYOUT_PH_FOREGROUND);
        g.drawImage(arrow, null, arrowX, iconY);
        g.drawImage(overflow, null, overflowX, iconY);
        g.setColor(LAYOUT_PH_BAR_BACKGROUND_ALT);
        g.fillRect(x, bottomBarY, width, barHeight);
        g.setColor(LAYOUT_PH_BAR_BACKGROUND);
        g.fillRect(x, bottomBarY, bottomBarSegmentSize, barHeight);
        g.fillRect(x + width - bottomBarSegmentSize, bottomBarY, bottomBarSegmentSize, barHeight);
        g.setColor(LAYOUT_PH_BORDER_COLOR);
        g.setStroke(new BasicStroke(JBUIScale.scale((float)2.0f)));
        g.drawRect(x, y, width, height);
    }

    @NotNull
    public static final BufferedImage createNavigationPlaceHolder(int width, int height, @Nullable BufferedImage layoutImage) {
        return ResourceRenderingUtilsKt.createImageAndPaint(width, height, (Function1<? super Graphics2D, Unit>)((Function1)new Function1<Graphics2D, Unit>(width, height, layoutImage){
            final /* synthetic */ int $width;
            final /* synthetic */ int $height;
            final /* synthetic */ BufferedImage $layoutImage;

            public final void invoke(@NotNull Graphics2D it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ResourceRenderingUtilsKt.access$paintNavigationPlaceHolder(it, this.$width, this.$height, this.$layoutImage);
            }
            {
                this.$width = n;
                this.$height = n2;
                this.$layoutImage = bufferedImage;
                super(1);
            }
        }));
    }

    private static final void paintNavigationPlaceHolder(Graphics2D g, int width, int height, BufferedImage layoutImage) {
        Object object;
        int p1;
        Object object2;
        Integer[] $this$mapTo$iv$iv;
        float ratio = 0.75f;
        if (height < 10 || width < (int)((float)height * ratio)) {
            return;
        }
        Color arrowColor = new Color((int)3209711696L, true);
        int layoutHeight = RangesKt.coerceAtLeast((int)((int)((float)height * 0.8f)), (int)10);
        int layoutWidth = (int)((float)layoutHeight * ratio);
        int layoutX = (int)((float)width * 0.05f + 0.5f);
        int layoutY = (int)((float)height * 0.5f + 0.5f) - (int)((float)layoutHeight * 0.5f + 0.5f);
        BufferedImage bufferedImage = layoutImage;
        BufferedImage image = bufferedImage != null ? ResourceRenderingUtilsKt.scaleTo(bufferedImage, layoutWidth, layoutHeight) : null;
        int arrowMargin = (int)((float)width * 0.1f + 0.5f);
        int arrowSeparation = (int)((float)height * 0.18f + 0.5f);
        int arrowTipUnscaledSize = RangesKt.coerceAtLeast((int)((int)((float)arrowSeparation * 0.3f + 0.5f)), (int)6);
        int arrowTipHeight = (int)((float)arrowTipUnscaledSize * 0.866f + 0.5f);
        int arrow1LineStartY = layoutY + (int)((float)layoutHeight * 0.5f + 0.5f);
        int arrow1LineStartX = layoutX + layoutWidth;
        int arrowLineEndX = RangesKt.coerceAtMost((int)(width - JBUIScale.scale((int)arrowTipHeight)), (int)(arrow1LineStartX + (int)((float)layoutWidth * 0.6f + 0.2f)));
        int arrow2LineStartX = (int)((float)(arrow1LineStartX + arrowLineEndX) * 0.5f + 0.5f);
        int arrow2LineStartY = arrow1LineStartY + arrowSeparation;
        int arrowEndX = width - arrowMargin;
        int arrow1X = arrowLineEndX;
        int arrow1Y = arrow1LineStartY - (int)((float)JBUIScale.scale((int)arrowTipUnscaledSize) * 0.5f + 0.5f);
        int arrow2X = arrowLineEndX;
        int arrow2Y = arrow1Y + arrowSeparation;
        Integer[] $this$map$iv = new Integer[]{0, arrowTipHeight, 0};
        boolean $i$f$map = false;
        Integer[] integerArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Integer item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            object2 = destination$iv$iv;
            boolean bl = false;
            object = JBUIScale.scale((int)p1);
            object2.add(object);
        }
        object2 = (List)destination$iv$iv;
        $this$map$iv = new Integer[]{0, (int)((float)arrowTipUnscaledSize * 0.5f + 0.5f), arrowTipUnscaledSize};
        object2 = CollectionsKt.toIntArray((Collection)((Collection)object2));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        for (Integer item$iv$iv : $this$mapTo$iv$iv) {
            p1 = ((Number)item$iv$iv).intValue();
            object = destination$iv$iv;
            boolean bl = false;
            Integer n = JBUIScale.scale((int)p1);
            object.add(n);
        }
        object = (List)destination$iv$iv;
        int n = 3;
        int[] nArray = CollectionsKt.toIntArray((Collection)((Collection)object));
        Object object3 = object2;
        Polygon arrowPoly = new Polygon((int[])object3, nArray, n);
        float f = RangesKt.coerceAtLeast((int)((int)((float)arrowSeparation * 0.1f + 0.5f)), (int)2);
        boolean bl = false;
        boolean bl2 = false;
        float p12 = f;
        boolean bl3 = false;
        float connectionStrokeSize = JBUIScale.scale((float)p12);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setColor(arrowColor);
        g.setStroke(new BasicStroke(connectionStrokeSize, 0, 0));
        g.drawLine(arrow1LineStartX, arrow1LineStartY, arrowLineEndX, arrow1LineStartY);
        arrowPoly.translate(arrow1X, arrow1Y);
        g.fillPolygon(arrowPoly);
        arrowPoly.translate(-arrow1X, -arrow1Y);
        g.setStroke(new BasicStroke(connectionStrokeSize, 1, 0));
        g.drawLine(arrow2LineStartX, arrow1LineStartY, arrow2LineStartX, arrow2LineStartY);
        g.setStroke(new BasicStroke(connectionStrokeSize, 0, 0));
        g.drawLine(arrow2LineStartX, arrow2LineStartY, arrowLineEndX, arrow2LineStartY);
        arrowPoly.translate(arrow2X, arrow2Y);
        g.fillPolygon(arrowPoly);
        arrowPoly.translate(-arrow2X, -arrow2Y);
        if (image == null) {
            ResourceRenderingUtilsKt.paintFakeLayout(g, layoutWidth, layoutHeight, layoutX, layoutY);
        } else {
            g.drawImage(image, null, layoutX, layoutY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BufferedImage createImageAndPaint(int width, int height, Function1<? super Graphics2D, Unit> doPaint) {
        BufferedImage bufferedImage = ImageUtil.createImage((int)width, (int)height, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.createImage(wi\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage bufferedImage2 = bufferedImage;
        boolean bl = false;
        boolean bl2 = false;
        BufferedImage $this$apply = bufferedImage2;
        boolean bl3 = false;
        Graphics2D g = $this$apply.createGraphics();
        try {
            Graphics2D graphics2D = g;
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"g");
            doPaint.invoke((Object)graphics2D);
        }
        finally {
            g.dispose();
        }
        return bufferedImage2;
    }

    private static final BufferedImage scaleTo(BufferedImage $this$scaleTo, int width, int height) {
        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)ImageUtil.scaleImage((Image)$this$scaleTo, (int)width, (int)height));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.toBufferedImag\u2026age(this, width, height))");
        return bufferedImage;
    }

    private static final BufferedImage toScaledImage(Icon $this$toScaledImage, int size) {
        int n = $this$toScaledImage.getIconWidth();
        int n2 = $this$toScaledImage.getIconHeight();
        boolean bl = false;
        double scale = (double)size / (double)Math.max(n, n2);
        BufferedImage bufferedImage = ImageUtils.scale((BufferedImage)ImageUtils.iconToImage((Icon)$this$toScaledImage), (double)scale);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtils.scale(ImageUt\u2026iconToImage(this), scale)");
        return bufferedImage;
    }

    public static final /* synthetic */ void access$paintDrawablePlaceholderImage(Graphics2D g, int width, int height) {
        ResourceRenderingUtilsKt.paintDrawablePlaceholderImage(g, width, height);
    }

    public static final /* synthetic */ void access$paintLayoutPlaceHolderImage(Graphics2D g, int width, int height) {
        ResourceRenderingUtilsKt.paintLayoutPlaceHolderImage(g, width, height);
    }

    public static final /* synthetic */ void access$paintNavigationPlaceHolder(Graphics2D g, int width, int height, BufferedImage layoutImage) {
        ResourceRenderingUtilsKt.paintNavigationPlaceHolder(g, width, height, layoutImage);
    }
}

