/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.rendering;

import com.android.tools.idea.ui.resourcemanager.model.Asset;
import com.android.tools.idea.ui.resourcemanager.model.DesignAsset;
import com.android.tools.idea.ui.resourcemanager.model.ResourceAssetSet;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetData;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetDataProvider;
import com.android.tools.idea.ui.resourcemanager.rendering.AssetDataProviderKt;
import com.android.tools.idea.ui.resourcemanager.rendering.ResourceAssetUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/rendering/DefaultAssetDataProvider;", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetDataProvider;", "()V", "getAssetData", "Lcom/android/tools/idea/ui/resourcemanager/rendering/AssetData;", "asset", "Lcom/android/tools/idea/ui/resourcemanager/model/DesignAsset;", "getAssetSetData", "assetSet", "Lcom/android/tools/idea/ui/resourcemanager/model/ResourceAssetSet;", "intellij.android.core"})
public class DefaultAssetDataProvider
implements AssetDataProvider {
    @Override
    @NotNull
    public AssetData getAssetData(@NotNull DesignAsset asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        String title = ResourceAssetUtilsKt.getReadableConfigurations(asset.getQualifiers());
        String string = asset.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asset.file.name");
        String subtitle = string;
        String metadata = asset.getDisplayableFileSize();
        return new AssetData(title, subtitle, metadata);
    }

    @Override
    @NotNull
    public AssetData getAssetSetData(@NotNull ResourceAssetSet assetSet) {
        Intrinsics.checkNotNullParameter((Object)assetSet, (String)"assetSet");
        Asset asset = assetSet.getHighestDensityAsset();
        String title = assetSet.getName();
        String subtitle = asset.getType().getDisplayName();
        String metadata = AssetDataProviderKt.access$versionCountString(assetSet);
        String string = subtitle;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"subtitle");
        return new AssetData(title, string, metadata);
    }
}

