/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager.actions;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorer;
import com.android.tools.idea.ui.resourcemanager.ResourceExplorerKt;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.content.Content;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/actions/ShowFileInResourceManagerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getPsiDir", "Lcom/intellij/psi/PsiDirectory;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isSupportedInResManager", "", "isSupportedResource", "showResourceExplorer", "update", "intellij.android.core"})
public final class ShowFileInResourceManagerAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project != null && file2 != null && this.isSupportedInResManager(file2, project)) {
            this.showResourceExplorer(project, file2);
            return;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean isSupported = this.isSupportedInResManager(file2, project);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(isSupported);
        } else {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(isSupported);
        }
    }

    private final void showResourceExplorer(Project project, VirtualFile file2) {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Resources Explorer");
        Intrinsics.checkNotNull((Object)toolWindow);
        ToolWindow toolWindow2 = toolWindow;
        AndroidFacet facet2 = AndroidFacet.getInstance((VirtualFile)file2, (Project)project);
        if (facet2 != null) {
            toolWindow2.show(new Runnable(toolWindow2, facet2, file2){
                final /* synthetic */ ToolWindow $toolWindow;
                final /* synthetic */ AndroidFacet $facet;
                final /* synthetic */ VirtualFile $file;

                public final void run() {
                    block1: {
                        ResourceExplorer resourceExplorer;
                        Content content2 = this.$toolWindow.getContentManager().getContent(0);
                        JComponent jComponent = content2 != null ? content2.getComponent() : null;
                        if (!(jComponent instanceof ResourceExplorer)) {
                            jComponent = null;
                        }
                        ResourceExplorer resourceExplorer2 = resourceExplorer = (ResourceExplorer)jComponent;
                        if (resourceExplorer2 == null) break block1;
                        resourceExplorer2.selectAsset(this.$facet, this.$file);
                    }
                }
                {
                    this.$toolWindow = toolWindow;
                    this.$facet = androidFacet;
                    this.$file = virtualFile;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedInResManager(VirtualFile file2, Project project) {
        if (file2 == null) return false;
        if (project == null) {
            return false;
        }
        PsiDirectory psiDirectory = this.getPsiDir(file2, project);
        if (psiDirectory == null) return false;
        PsiDirectory dir = psiDirectory;
        if (IdeResourcesUtil.isResourceDirectory(dir)) return true;
        if (!IdeResourcesUtil.isResourceSubdirectory$default(dir, null, 2, null)) return false;
        VirtualFile virtualFile = dir.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"dir.virtualFile");
        if (!this.isSupportedResource(virtualFile)) return false;
        return true;
    }

    private final boolean isSupportedResource(VirtualFile file2) {
        Object object = ResourceFolderType.getFolderType((String)file2.getName());
        if (object == null || (object = object.getName()) == null) {
            return false;
        }
        Object folderName = object;
        return ArraysKt.contains((Object[])ResourceExplorerKt.getMANAGER_SUPPORTED_RESOURCES(), (Object)ResourceType.fromFolderName((String)folderName));
    }

    private final PsiDirectory getPsiDir(VirtualFile file2, Project project) {
        Object object;
        if (file2.isDirectory()) {
            object = PsiManager.getInstance((Project)project).findDirectory(file2);
        } else {
            PsiFile psiFile2 = PsiManager.getInstance((Project)project).findFile(file2);
            object = psiFile2 != null ? psiFile2.getContainingDirectory() : null;
        }
        return object;
    }

    public ShowFileInResourceManagerAction() {
        super("Show In Resource Manager", "Display selected file in the Resource Manager", null);
    }
}

