/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcemanager;

import com.android.resources.ResourceType;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.ui.resourcemanager.ResourceManagerTracking$WhenMappings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ResourceManagerEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\rJ\u0006\u0010\u0013\u001a\u00020\fJ\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\rJ\u0010\u0010\u0017\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u001a\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\rJ\u0018\u0010\u001b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\rJ\u0018\u0010\u001c\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\rJ\u001a\u0010\u001d\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\t\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u001e\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\rJ\u0016\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u0016\u0010#\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u0016\u0010$\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u000e\u0010%\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\fJ\u0016\u0010'\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\rJ\u000e\u0010(\u001a\u00020\n*\u0004\u0018\u00010\rH\u0002\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/ui/resourcemanager/ResourceManagerTracking;", "", "()V", "createEvent", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "kind", "Lcom/google/wireless/android/sdk/stats/ResourceManagerEvent$Kind;", "type", "Lcom/google/wireless/android/sdk/stats/ResourceManagerEvent$ResourceType;", "log", "", "Lcom/android/resources/ResourceType;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "logAssetAddedViaButton", "logAssetAddedViaDnd", "logAssetOpened", "logDensityInferred", "logDetailViewOpened", "logDialogOpens", "logDragOnView", "logDragOnViewGroup", "logPanelCloses", "logPanelOpens", "logPasteOnBlank", "logPasteOnXmlAttribute", "logPasteOnXmlTag", "logPasteUrlText", "logRefreshAsset", "logShowFrameworkToggle", "state", "", "logShowLibrariesToggle", "logShowLocalDependenciesToggle", "logShowThemeAttributesToggle", "logSwitchToGridMode", "logSwitchToListMode", "logTypeFilterEnabled", "toEventType", "intellij.android.core"})
public final class ResourceManagerTracking {
    @NotNull
    public static final ResourceManagerTracking INSTANCE;

    public final void logPanelOpens(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, ResourceManagerEvent.Kind.TOOL_WINDOW_OPEN);
    }

    public final void logDialogOpens(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, ResourceManagerEvent.Kind.RESOURCE_PICKER_DIALOG_OPEN);
    }

    public final void logPanelCloses() {
    }

    public final void logAssetAddedViaButton(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, ResourceManagerEvent.Kind.ASSET_ADDED_VIA_BUTTON);
    }

    public final void logAssetAddedViaDnd(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, ResourceManagerEvent.Kind.ASSET_ADDED_VIA_DND);
    }

    public final void logDetailViewOpened(@NotNull AndroidFacet facet2, @Nullable ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, ResourceManagerEvent.Kind.DETAIL_VIEW_OPENED, type);
    }

    public final void logAssetOpened(@NotNull AndroidFacet facet2, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log(facet2, ResourceManagerEvent.Kind.ASSET_OPENED, type);
    }

    public final void logSwitchToGridMode(@NotNull AndroidFacet facet2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, ResourceManagerEvent.Kind.LIST_MODE_CHANGED);
    }

    public final void logSwitchToListMode() {
    }

    public final void logRefreshAsset(@Nullable Project project, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log(project, ResourceManagerEvent.Kind.REFRESH_RES_PREVIEW, type);
    }

    public final void logShowLocalDependenciesToggle(@NotNull AndroidFacet facet2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, state ? ResourceManagerEvent.Kind.DEPENDENT_MODULES_SHOWN : ResourceManagerEvent.Kind.DEPENDENT_MODULES_HIDDEN);
    }

    public final void logShowLibrariesToggle(@NotNull AndroidFacet facet2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, state ? ResourceManagerEvent.Kind.LIBRARIES_SHOWN : ResourceManagerEvent.Kind.LIBRARIES_HIDDEN);
    }

    public final void logShowFrameworkToggle(@NotNull AndroidFacet facet2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, state ? ResourceManagerEvent.Kind.FRAMEWORK_SHOWN : ResourceManagerEvent.Kind.FRAMEWORK_HIDDEN);
    }

    public final void logShowThemeAttributesToggle(@NotNull AndroidFacet facet2, boolean state) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        this.log(facet2, state ? ResourceManagerEvent.Kind.THEME_ATTR_SHOWN : ResourceManagerEvent.Kind.THEME_ATTR_HIDDEN);
    }

    public final void logTypeFilterEnabled(@NotNull AndroidFacet facet2, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log(facet2, ResourceManagerEvent.Kind.ENABLE_FILTER_BY_TYPE, type);
    }

    public final void logPasteOnBlank(@Nullable Project project, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log(project, ResourceManagerEvent.Kind.DROP_ON_XML_BLANK_SPACE, type);
    }

    public final void logPasteOnXmlTag(@Nullable Project project, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log(project, ResourceManagerEvent.Kind.DROP_ON_XML_TAG, type);
    }

    public final void logPasteOnXmlAttribute(@Nullable Project project, @NotNull ResourceType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.log(project, ResourceManagerEvent.Kind.DROP_ON_XML_ATTRIBUTE, type);
    }

    public final void logPasteUrlText(@Nullable Project project, @Nullable ResourceType type) {
        this.log(project, ResourceManagerEvent.Kind.DROP_AS_TEXT, type);
    }

    public final void logDragOnView(@Nullable ResourceType type) {
        this.log((Project)null, ResourceManagerEvent.Kind.DROP_ON_LAYOUT_VIEW, type);
    }

    public final void logDragOnViewGroup(@Nullable ResourceType type) {
        this.log((Project)null, ResourceManagerEvent.Kind.DROP_ON_LAYOUT_VIEWGROUP, type);
    }

    public final void logDensityInferred() {
        this.log((Project)null, ResourceManagerEvent.Kind.DENSITY_INFERED);
    }

    private final AndroidStudioEvent.Builder createEvent(Project project, ResourceManagerEvent.Kind kind, ResourceManagerEvent.ResourceType type) {
        AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"AndroidStudioEvent.newBuilder()");
        AndroidStudioEvent.Builder builder3 = UsageTrackerUtils.withProjectId(builder2, project).setKind(AndroidStudioEvent.EventKind.RESOURCE_MANAGER).setResourceManagerEvent(ResourceManagerEvent.newBuilder().setKind(kind).setResourceType(type));
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"AndroidStudioEvent.newBu\u2026  .setResourceType(type))");
        return builder3;
    }

    private final void log(AndroidFacet facet2, ResourceManagerEvent.Kind kind) {
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        this.log(module2.getProject(), kind);
    }

    private final void log(Project project, ResourceManagerEvent.Kind kind) {
        UsageTracker.log((AndroidStudioEvent.Builder)this.createEvent(project, kind, ResourceManagerEvent.ResourceType.UNKNOWN));
    }

    private final void log(AndroidFacet facet2, ResourceManagerEvent.Kind kind, ResourceType type) {
        Module module2 = facet2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        this.log(module2.getProject(), kind, type);
    }

    private final void log(Project project, ResourceManagerEvent.Kind kind, ResourceType type) {
        UsageTracker.log((AndroidStudioEvent.Builder)this.createEvent(project, kind, this.toEventType(type)));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ResourceManagerEvent.ResourceType toEventType(ResourceType $this$toEventType) {
        ResourceManagerEvent.ResourceType resourceType;
        ResourceType resourceType2 = $this$toEventType;
        if (resourceType2 != null) {
            switch (ResourceManagerTracking$WhenMappings.$EnumSwitchMapping$0[resourceType2.ordinal()]) {
                case 1: 
                case 2: {
                    resourceType = ResourceManagerEvent.ResourceType.DRAWABLE;
                    return resourceType;
                }
                case 3: {
                    resourceType = ResourceManagerEvent.ResourceType.FONT;
                    return resourceType;
                }
                case 4: {
                    resourceType = ResourceManagerEvent.ResourceType.COLOR;
                    return resourceType;
                }
                case 5: {
                    resourceType = ResourceManagerEvent.ResourceType.LAYOUT;
                    return resourceType;
                }
                case 6: {
                    resourceType = ResourceManagerEvent.ResourceType.STRING;
                    return resourceType;
                }
                case 7: {
                    resourceType = ResourceManagerEvent.ResourceType.NAVIGATION;
                    return resourceType;
                }
                case 8: {
                    resourceType = ResourceManagerEvent.ResourceType.MENU;
                    return resourceType;
                }
                case 9: {
                    resourceType = ResourceManagerEvent.ResourceType.STYLE;
                    return resourceType;
                }
                case 10: {
                    resourceType = ResourceManagerEvent.ResourceType.XML;
                    return resourceType;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    resourceType = ResourceManagerEvent.ResourceType.ANIMATION;
                    return resourceType;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    resourceType = ResourceManagerEvent.ResourceType.VALUE;
                    return resourceType;
                }
            }
        }
        resourceType = ResourceManagerEvent.ResourceType.UNKNOWN;
        return resourceType;
    }

    private ResourceManagerTracking() {
    }

    static {
        ResourceManagerTracking resourceManagerTracking;
        INSTANCE = resourceManagerTracking = new ResourceManagerTracking();
    }
}

