/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.designer.overlays;

import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.ui.designer.overlays.ChooseOverlayDialog;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.ui.designer.overlays.OverlayData;
import com.android.tools.idea.ui.designer.overlays.OverlayEntry;
import com.android.tools.idea.ui.designer.overlays.OverlayNotFoundException;
import com.android.tools.idea.ui.designer.overlays.OverlayProvider;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Toggleable;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class OverlayMenuAction
extends DropDownAction {
    private final EditorDesignSurface mySurface;

    public OverlayMenuAction(@NotNull EditorDesignSurface surface2) {
        if (surface2 == null) {
            OverlayMenuAction.$$$reportNull$$$0(0);
        }
        super("Overlays Menu", "Overlays Menu", StudioIcons.LayoutInspector.MODE_3D);
        this.mySurface = surface2;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        if (context == null) {
            OverlayMenuAction.$$$reportNull$$$0(1);
        }
        List providers2 = OverlayConfiguration.EP_NAME.getExtensionsIfPointIsRegistered();
        this.removeAll();
        if (!providers2.isEmpty()) {
            DefaultActionGroup overlayGroup = DefaultActionGroup.createPopupGroup(() -> "Overlays");
            OverlayEntry currentOverlay = this.mySurface.getOverlayConfiguration().getCurrentOverlayEntry();
            for (OverlayData overlay : this.mySurface.getOverlayConfiguration().getAllOverlays()) {
                boolean isCurrentlySelected = false;
                if (overlay.getOverlayEntry().equals(currentOverlay)) {
                    isCurrentlySelected = true;
                }
                overlayGroup.add((AnAction)new ToggleOverlayAction(this.mySurface, overlay.getOverlayName(), overlay.getOverlayEntry(), isCurrentlySelected));
            }
            this.add((AnAction)overlayGroup);
            for (OverlayProvider provider2 : providers2) {
                this.add(new AddOverlayAction(this.mySurface, provider2));
            }
            this.add(new DeleteOverlayAction(this.mySurface));
            this.addSeparator();
            this.add(new UpdateOverlayAction(this.mySurface));
            this.add(new ToggleCachedOverlayAction(this.mySurface));
            this.add(new CancelOverlayAction(this.mySurface));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CancelOverlayAction
    extends AnAction {
        private final EditorDesignSurface mySurface;

        public CancelOverlayAction(@NotNull EditorDesignSurface surface2) {
            if (surface2 == null) {
                CancelOverlayAction.$$$reportNull$$$0(0);
            }
            super("Cancel Overlay", "Disable current overlay", StudioIcons.LayoutInspector.CLEAR_OVERLAY);
            this.mySurface = surface2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CancelOverlayAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(this.mySurface.getOverlayConfiguration().isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CancelOverlayAction.$$$reportNull$$$0(2);
            }
            if (this.mySurface.getOverlayConfiguration().isOverlayPresent()) {
                this.mySurface.getOverlayConfiguration().clearCurrentOverlay();
                this.mySurface.repaint();
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error cancelling overlay action", null, "There is no overlay action to be cancelled.", NotificationType.WARNING, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction$CancelOverlayAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class DeleteOverlayAction
    extends AnAction {
        @NotNull
        private final EditorDesignSurface mySurface;

        DeleteOverlayAction(@NotNull EditorDesignSurface surface2) {
            if (surface2 == null) {
                DeleteOverlayAction.$$$reportNull$$$0(0);
            }
            super("Delete Overlay...", null, StudioIcons.Common.DELETE);
            this.mySurface = surface2;
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setVisible(!this.mySurface.getOverlayConfiguration().getAllOverlays().isEmpty());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DeleteOverlayAction.$$$reportNull$$$0(1);
            }
            List<OverlayData> overlays = this.mySurface.getOverlayConfiguration().getAllOverlays();
            ChooseOverlayDialog chooser2 = new ChooseOverlayDialog(overlays, "Choose overlay", "Choose the overlay you want to delete");
            chooser2.show();
            List chosen = chooser2.getChosenElements();
            this.mySurface.getOverlayConfiguration().removeOverlays(chosen);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction$DeleteOverlayAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UpdateOverlayAction
    extends AnAction {
        @NotNull
        private final EditorDesignSurface mySurface;

        public UpdateOverlayAction(@NotNull EditorDesignSurface surface2) {
            if (surface2 == null) {
                UpdateOverlayAction.$$$reportNull$$$0(0);
            }
            super("Reload Overlay", "Reload the current overlay", StudioIcons.LayoutEditor.Motion.LOOP);
            this.mySurface = surface2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateOverlayAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(this.mySurface.getOverlayConfiguration().isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                UpdateOverlayAction.$$$reportNull$$$0(2);
            }
            OverlayConfiguration overlayConfiguration = this.mySurface.getOverlayConfiguration();
            OverlayEntry currentOverlay = overlayConfiguration.getCurrentOverlayEntry();
            if (overlayConfiguration.getOverlayImage() != null && !overlayConfiguration.isPlaceholderVisible()) {
                overlayConfiguration.showPlaceholder();
                Promise<OverlayData> promise = currentOverlay.getOverlayProvider().getOverlay(currentOverlay.getId());
                promise.onSuccess(result2 -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        result2.setOverlayProvider(currentOverlay.getOverlayProvider());
                        overlayConfiguration.updateOverlay((OverlayData)result2);
                    }
                });
                promise.onError(t -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        overlayConfiguration.hidePlaceholder();
                        if (t instanceof OverlayNotFoundException) {
                            overlayConfiguration.removeOverlayFromList(currentOverlay);
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error fetching overlay", null, "The overlay you requested does not exist anymore.", NotificationType.ERROR, null));
                        } else {
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error fetching overlay", null, "There was an error fetching the overlay. Please try again.", NotificationType.ERROR, null));
                        }
                    }
                });
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Update error", null, "There is no overlay to be updated. Please select an overlay before trying to update it.", NotificationType.WARNING, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction$UpdateOverlayAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AddOverlayAction
    extends AnAction {
        @NotNull
        private final OverlayProvider myOverlayProvider;
        @NotNull
        private final EditorDesignSurface mySurface;

        AddOverlayAction(@NotNull EditorDesignSurface surface2, @NotNull OverlayProvider provider2) {
            if (surface2 == null) {
                AddOverlayAction.$$$reportNull$$$0(0);
            }
            if (provider2 == null) {
                AddOverlayAction.$$$reportNull$$$0(1);
            }
            super("Add " + provider2.getPluginName() + " Overlay...", null, StudioIcons.LayoutInspector.LOAD_OVERLAY);
            this.myOverlayProvider = provider2;
            this.mySurface = surface2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddOverlayAction.$$$reportNull$$$0(2);
            }
            OverlayConfiguration overlayConfiguration = this.mySurface.getOverlayConfiguration();
            overlayConfiguration.showPlaceholder();
            Promise<OverlayData> promise = this.myOverlayProvider.addOverlay();
            promise.onSuccess(result2 -> {
                if (overlayConfiguration.isPlaceholderVisible()) {
                    result2.setOverlayProvider(this.myOverlayProvider);
                    overlayConfiguration.addOverlay((OverlayData)result2);
                }
            });
            promise.onError(t -> {
                if (overlayConfiguration.isPlaceholderVisible()) {
                    overlayConfiguration.hidePlaceholder();
                    Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error fetching overlay", null, "There was an error fetching the overlay. Please try again.", NotificationType.ERROR, null));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction$AddOverlayAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToggleCachedOverlayAction
    extends AnAction {
        EditorDesignSurface mySurface;

        public ToggleCachedOverlayAction(@NotNull EditorDesignSurface surface2) {
            if (surface2 == null) {
                ToggleCachedOverlayAction.$$$reportNull$$$0(0);
            }
            super("Toggle Overlay", "Toggle current overlay on/off", StudioIcons.LayoutEditor.Toolbar.LAYER);
            this.mySurface = surface2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleCachedOverlayAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setVisible(this.mySurface.getOverlayConfiguration().isOverlayPresent());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayConfiguration configuration;
            if (e == null) {
                ToggleCachedOverlayAction.$$$reportNull$$$0(2);
            }
            if ((configuration = this.mySurface.getOverlayConfiguration()).getOverlayImage() != null && !configuration.isPlaceholderVisible()) {
                if (!configuration.getOverlayVisibility()) {
                    configuration.showCachedOverlay();
                } else {
                    configuration.hideCachedOverlay();
                }
                this.mySurface.repaint();
            } else {
                Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error toggling overlay", null, "There was no overlay to be toggled. Please select an overlay first.", NotificationType.WARNING, null));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction$ToggleCachedOverlayAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class ToggleOverlayAction
    extends AnAction
    implements Toggleable {
        @NotNull
        private final OverlayEntry myOverlayEntry;
        @NotNull
        private final EditorDesignSurface mySurface;

        ToggleOverlayAction(@NotNull EditorDesignSurface surface2, @NotNull String title, @NotNull OverlayEntry overlayEntry, boolean checked) {
            if (surface2 == null) {
                ToggleOverlayAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                ToggleOverlayAction.$$$reportNull$$$0(1);
            }
            if (overlayEntry == null) {
                ToggleOverlayAction.$$$reportNull$$$0(2);
            }
            super(title, null, overlayEntry.getOverlayProvider().getPluginIcon());
            this.myOverlayEntry = overlayEntry;
            this.mySurface = surface2;
            this.getTemplatePresentation().putClientProperty("selected", (Object)checked);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            OverlayConfiguration overlayConfiguration;
            OverlayEntry currentOverlay;
            if (e == null) {
                ToggleOverlayAction.$$$reportNull$$$0(3);
            }
            if (this.myOverlayEntry.equals(currentOverlay = (overlayConfiguration = this.mySurface.getOverlayConfiguration()).getCurrentOverlayEntry())) {
                overlayConfiguration.clearCurrentOverlay();
            } else {
                overlayConfiguration.showPlaceholder();
                Promise<OverlayData> promise = this.myOverlayEntry.getOverlayProvider().getOverlay(this.myOverlayEntry.getId());
                promise.onSuccess(result2 -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        result2.setOverlayProvider(this.myOverlayEntry.getOverlayProvider());
                        overlayConfiguration.updateOverlay((OverlayData)result2);
                    }
                });
                promise.onError(t -> {
                    if (this.mySurface.getOverlayConfiguration().isPlaceholderVisible()) {
                        overlayConfiguration.hidePlaceholder();
                        if (t instanceof OverlayNotFoundException) {
                            overlayConfiguration.removeOverlayFromList(this.myOverlayEntry);
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error fetching overlay", null, "The overlay you requested does not exist anymore.", NotificationType.ERROR, null));
                        } else {
                            Notifications.Bus.notify((Notification)new Notification("Manage Overlays", null, "Error fetching overlay", null, "There was an error fetching the overlay. Please try again.", NotificationType.ERROR, null));
                        }
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overlayEntry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/ui/designer/overlays/OverlayMenuAction$ToggleOverlayAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

