/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.google.common.base.Objects;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiComboBoxItem<T> {
    private T myData;
    private String myLabel;
    private int myMinApi;
    private int myMinBuildApi;

    public ApiComboBoxItem(@NotNull T data, @NotNull String label, int minApi, int minBuildApi) {
        if (data == null) {
            ApiComboBoxItem.$$$reportNull$$$0(0);
        }
        if (label == null) {
            ApiComboBoxItem.$$$reportNull$$$0(1);
        }
        this.myData = data;
        this.myLabel = label;
        this.myMinApi = minApi;
        this.myMinBuildApi = minBuildApi;
    }

    public final T getData() {
        return this.myData;
    }

    public final String getLabel() {
        return this.myLabel;
    }

    public final int getMinApi() {
        return this.myMinApi;
    }

    public final int getMinBuildApi() {
        return this.myMinBuildApi;
    }

    public final boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ApiComboBoxItem other = (ApiComboBoxItem)obj;
        return Objects.equal(this.myData, other.myData) && Objects.equal((Object)this.myLabel, (Object)other.myLabel);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myData, this.myLabel});
    }

    @Nullable
    public final String validate(int projectApi, int projectBuildApi) {
        if (this.myMinApi > projectApi) {
            return String.format(Locale.US, "The feature \"%1$s\" requires a minimum API level of %2$d (project currently set to %3$d)", this.myLabel, this.myMinApi, projectApi);
        }
        if (this.myMinBuildApi > projectBuildApi) {
            return String.format(Locale.US, "The feature \"%1$s\" requires a minimum build API level of %2$d (project currently set to %3$d)", this.myLabel, this.myMinBuildApi, projectBuildApi);
        }
        return null;
    }

    public String toString() {
        return this.myLabel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "label";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/ui/ApiComboBoxItem";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

