/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.transport.Constants;
import com.android.tools.idea.transport.DeployableFile;
import com.android.tools.idea.transport.TransportDeviceManager;
import com.android.tools.idea.transport.TransportFileCopier;
import com.android.tools.profiler.proto.Agent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.download.AndroidProfilerDownloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransportFileManager
implements TransportFileCopier {
    static final String DEVICE_DIR = "/data/local/tmp/perfd/";
    private static final String CODE_CACHE_DIR = "code_cache";
    private static final String DAEMON_CONFIG_FILE = "daemon.config";
    private static final String AGENT_CONFIG_FILE = "agent.config";
    private static final int DEVICE_PORT = 12389;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final MessageBus myMessageBus;

    private static Logger getLogger() {
        return Logger.getInstance(TransportFileManager.class);
    }

    public TransportFileManager(@NotNull IDevice device, @NotNull MessageBus messageBus) {
        if (device == null) {
            TransportFileManager.$$$reportNull$$$0(0);
        }
        if (messageBus == null) {
            TransportFileManager.$$$reportNull$$$0(1);
        }
        this.myDevice = device;
        this.myMessageBus = messageBus;
    }

    public void copyFilesToDevice() throws AdbCommandRejectedException, IOException, ShellCommandUnresponsiveException, SyncException, TimeoutException {
        if (!AndroidProfilerDownloader.getInstance().makeSureComponentIsInPlace()) {
            return;
        }
        this.copyFileToDevice(HostFiles.TRANSPORT);
        if (TransportFileManager.isAtLeastO(this.myDevice)) {
            this.copyFileToDevice(HostFiles.PERFA);
            this.copyFileToDevice(HostFiles.PERFA_OKHTTP);
            this.copyFileToDevice(HostFiles.JVMTI_AGENT);
            this.copyFileToDevice(HostFiles.SIMPLEPERF);
        }
        if (TransportFileManager.isAtLeastP(this.myDevice)) {
            this.copyFileToDevice(HostFiles.PERFETTO);
            this.copyFileToDevice(HostFiles.PERFETTO_SO);
            this.copyFileToDevice(HostFiles.TRACED);
            this.copyFileToDevice(HostFiles.TRACED_PROBE);
        }
        this.pushDaemonConfig();
        this.pushAgentConfig(AGENT_CONFIG_FILE, null);
    }

    @NotNull
    static String getTransportExecutablePath() {
        String string = DEVICE_DIR + HostFiles.TRANSPORT.getFileName();
        if (string == null) {
            TransportFileManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getDaemonConfigPath() {
        return "/data/local/tmp/perfd/daemon.config";
    }

    @NotNull
    public static String getAgentConfigFile() {
        return "/data/local/tmp/perfd/agent.config";
    }

    void copyHostFileToDevice(@NotNull DeployableFile hostFile) throws AdbCommandRejectedException, IOException {
        if (hostFile == null) {
            TransportFileManager.$$$reportNull$$$0(3);
        }
        this.copyFileToDevice(hostFile);
    }

    private static boolean isAtLeastO(IDevice device) {
        return device.getVersion().getFeatureLevel() >= 26;
    }

    private static boolean isAtLeastP(IDevice device) {
        return device.getVersion().getFeatureLevel() >= 28;
    }

    private void pushDaemonConfig() throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        Transport.DaemonConfig.Builder configBuilder = Transport.DaemonConfig.newBuilder().setCommon(this.buildCommonConfig());
        ((TransportDeviceManager.TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TransportDeviceManager.TOPIC)).customizeDaemonConfig(configBuilder);
        File configFile = FileUtil.createTempFile((String)DAEMON_CONFIG_FILE, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        configBuilder.build().writeTo((OutputStream)oStream);
        this.myDevice.executeShellCommand("rm -f /data/local/tmp/perfd/daemon.config", (IShellOutputReceiver)new NullOutputReceiver());
        this.myDevice.pushFile(configFile.getAbsolutePath(), "/data/local/tmp/perfd/daemon.config");
    }

    public void pushAgentConfig(@NotNull String configName, @Nullable AndroidRunConfigurationBase runConfig) throws AdbCommandRejectedException, IOException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        if (configName == null) {
            TransportFileManager.$$$reportNull$$$0(4);
        }
        Agent.AgentConfig.Builder agentConfigBuilder = Agent.AgentConfig.newBuilder().setCommon(this.buildCommonConfig());
        ((TransportDeviceManager.TransportDeviceManagerListener)this.myMessageBus.syncPublisher(TransportDeviceManager.TOPIC)).customizeAgentConfig(agentConfigBuilder, runConfig);
        File configFile = FileUtil.createTempFile((String)configName, null, (boolean)true);
        FileOutputStream oStream = new FileOutputStream(configFile);
        agentConfigBuilder.build().writeTo((OutputStream)oStream);
        this.myDevice.executeShellCommand("rm -f /data/local/tmp/perfd/" + configName, (IShellOutputReceiver)new NullOutputReceiver());
        this.myDevice.pushFile(configFile.getAbsolutePath(), DEVICE_DIR + configName);
    }

    @NotNull
    private Common.CommonConfig.Builder buildCommonConfig() {
        Common.CommonConfig.SocketType socketType = TransportFileManager.isAtLeastO(this.myDevice) ? Common.CommonConfig.SocketType.ABSTRACT_SOCKET : Common.CommonConfig.SocketType.UNSPECIFIED_SOCKET;
        Common.CommonConfig.Builder builder2 = Common.CommonConfig.newBuilder().setSocketType(socketType).setServiceAddress("127.0.0.1:12389").setServiceSocketName("@AndroidStudioTransport");
        if (builder2 == null) {
            TransportFileManager.$$$reportNull$$$0(5);
        }
        return builder2;
    }

    @Override
    public List<String> copyFileToDevice(@NotNull DeployableFile hostFile) throws AdbCommandRejectedException, IOException {
        if (hostFile == null) {
            TransportFileManager.$$$reportNull$$$0(6);
        }
        Path dirPath = hostFile.getDir().toPath();
        ArrayList<String> paths = new ArrayList<String>();
        if (!hostFile.isExecutable()) {
            Path path2 = dirPath.resolve(hostFile.getFileName());
            paths.add(this.pushFileToDevice(path2, hostFile.getFileName(), hostFile.isExecutable()));
            return paths;
        }
        if (!hostFile.isAbiDependent()) {
            Abi abi = this.getBestAbi(hostFile);
            Path path3 = dirPath.resolve(abi + "/" + hostFile.getFileName());
            paths.add(this.pushFileToDevice(path3, hostFile.getFileName(), true));
        } else {
            String format2 = hostFile.getOnDeviceAbiFileNameFormat();
            assert (format2 != null);
            for (Abi abi : this.getBestAbis(hostFile)) {
                Path path4 = dirPath.resolve(abi + "/" + hostFile.getFileName());
                paths.add(this.pushFileToDevice(path4, String.format(format2, abi.getCpuArch()), true));
            }
        }
        return paths;
    }

    private String pushFileToDevice(Path localPath, String fileName, boolean executable) throws AdbCommandRejectedException, IOException {
        String deviceFilePath = DEVICE_DIR + fileName;
        try {
            if (!Files.exists(localPath, new LinkOption[0])) {
                throw new RuntimeException(String.format("File %s could not be found for device: %s", localPath.toString(), this.myDevice));
            }
            TransportFileManager.getLogger().info(String.format("Pushing %s to %s...", fileName, DEVICE_DIR));
            this.myDevice.executeShellCommand("rm -f " + deviceFilePath, (IShellOutputReceiver)new NullOutputReceiver());
            this.myDevice.executeShellCommand("mkdir -p " + deviceFilePath.substring(0, deviceFilePath.lastIndexOf(47)), (IShellOutputReceiver)new NullOutputReceiver());
            this.myDevice.pushFile(localPath.toString(), deviceFilePath);
            if (executable) {
                String cmd = "chmod +x " + deviceFilePath + " || chmod 777 " + deviceFilePath;
                this.myDevice.executeShellCommand(cmd, (IShellOutputReceiver)new NullOutputReceiver());
            }
            TransportFileManager.getLogger().info(String.format("Successfully pushed %s to %s.", fileName, DEVICE_DIR));
        }
        catch (ShellCommandUnresponsiveException | SyncException | TimeoutException e) {
            throw new RuntimeException(e);
        }
        return deviceFilePath;
    }

    public String configureStartupAgent(@NotNull String packageName, @NotNull String configName) {
        if (packageName == null) {
            TransportFileManager.$$$reportNull$$$0(7);
        }
        if (configName == null) {
            TransportFileManager.$$$reportNull$$$0(8);
        }
        if (this.myDevice.getVersion().getFeatureLevel() < 27) {
            return "";
        }
        String packageDataPath = this.getPackageDataPath(packageName);
        if (packageDataPath.isEmpty()) {
            return "";
        }
        String agentName = String.format(HostFiles.JVMTI_AGENT.getOnDeviceAbiFileNameFormat(), this.getBestAbi(HostFiles.JVMTI_AGENT).getCpuArch());
        String[] requiredAgentFiles = new String[]{agentName, HostFiles.PERFA.getFileName()};
        try {
            for (String agentFile : requiredAgentFiles) {
                this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, String.format("rm -rf ./%s/%s", CODE_CACHE_DIR, agentFile)), (IShellOutputReceiver)new NullOutputReceiver());
                this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, String.format("cp %s ./%s/", DEVICE_DIR + agentFile, CODE_CACHE_DIR)), (IShellOutputReceiver)new NullOutputReceiver());
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException ignored) {
            return "";
        }
        return String.format("--attach-agent %s/%s/%s=%s", packageDataPath, CODE_CACHE_DIR, agentName, DEVICE_DIR + configName);
    }

    @NotNull
    private String getPackageDataPath(@NotNull String packageName) {
        if (packageName == null) {
            TransportFileManager.$$$reportNull$$$0(9);
        }
        final String[] result2 = new String[1];
        try {
            this.myDevice.executeShellCommand(this.buildRunAsCommand(packageName, "pwd"), (IShellOutputReceiver)new MultiLineReceiver(){

                public void processNewLines(String[] lines2) {
                    if (result2[0] == null) {
                        result2[0] = lines2[0];
                    }
                }

                public boolean isCancelled() {
                    return false;
                }
            });
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException throwable) {
            // empty catch block
        }
        if (result2[0] == null || result2[0].startsWith("run-as: ")) {
            return "";
        }
        String string = result2[0];
        if (string == null) {
            TransportFileManager.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private String buildRunAsCommand(@NotNull String packageName, @NotNull String command) {
        if (packageName == null) {
            TransportFileManager.$$$reportNull$$$0(11);
        }
        if (command == null) {
            TransportFileManager.$$$reportNull$$$0(12);
        }
        String string = String.format("run-as %s sh -c '%s'", packageName, command);
        if (string == null) {
            TransportFileManager.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private Abi getBestAbi(@NotNull DeployableFile hostFile) {
        List<Abi> abis;
        if (hostFile == null) {
            TransportFileManager.$$$reportNull$$$0(14);
        }
        if ((abis = this.getBestAbis(hostFile)).isEmpty()) {
            throw new RuntimeException("Could not find ABI file for: " + hostFile.getFileName());
        }
        Abi abi = abis.get(0);
        if (abi == null) {
            TransportFileManager.$$$reportNull$$$0(15);
        }
        return abi;
    }

    @NotNull
    private List<Abi> getBestAbis(@NotNull DeployableFile hostFile) {
        if (hostFile == null) {
            TransportFileManager.$$$reportNull$$$0(16);
        }
        File dir = hostFile.getDir();
        List supportedAbis = this.myDevice.getAbis().stream().map(abi -> Abi.getEnum((String)abi)).filter(abi -> new File(dir, abi + "/" + hostFile.getFileName()).exists()).collect(Collectors.toList());
        ArrayList<Abi> bestAbis = new ArrayList<Abi>();
        HashSet<String> seenCpuArch = new HashSet<String>();
        for (Abi abi2 : supportedAbis) {
            if (seenCpuArch.contains(abi2.getCpuArch())) continue;
            seenCpuArch.add(abi2.getCpuArch());
            bestAbis.add(abi2);
        }
        ArrayList<Abi> arrayList = bestAbis;
        if (arrayList == null) {
            TransportFileManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/transport/TransportFileManager";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/transport/TransportFileManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransportExecutablePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommonConfig";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageDataPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRunAsCommand";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestAbi";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestAbis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyHostFileToDevice";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pushAgentConfig";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFileToDevice";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureStartupAgent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPackageDataPath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildRunAsCommand";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getBestAbi";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBestAbis";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HostFiles {
        @NotNull
        static final DeployableFile TRANSPORT = new DeployableFile.Builder("transport").setReleaseDir(Constants.TRANSPORT_RELEASE_DIR).setDevDir(Constants.TRANSPORT_DEV_DIR).setExecutable(true).build();
        @NotNull
        static final DeployableFile PERFA = new DeployableFile.Builder("perfa.jar").build();
        @NotNull
        static final DeployableFile PERFA_OKHTTP = new DeployableFile.Builder("perfa_okhttp.dex").build();
        @NotNull
        static final DeployableFile JVMTI_AGENT = new DeployableFile.Builder("libjvmtiagent.so").setReleaseDir(Constants.JVMTI_AGENT_RELEASE_DIR).setDevDir(Constants.JVMTI_AGENT_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("libjvmtiagent_%s.so").build();
        @NotNull
        static final DeployableFile SIMPLEPERF = new DeployableFile.Builder("simpleperf").setReleaseDir(Constants.SIMPLEPERF_RELEASE_DIR).setDevDir(Constants.SIMPLEPERF_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("simpleperf_%s").build();
        @NotNull
        static final DeployableFile PERFETTO = new DeployableFile.Builder("perfetto").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("perfetto_%s").build();
        @NotNull
        static final DeployableFile PERFETTO_SO = new DeployableFile.Builder("libperfetto.so").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("%s/libperfetto.so").build();
        @NotNull
        static final DeployableFile TRACED = new DeployableFile.Builder("traced").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("traced_%s").build();
        @NotNull
        static final DeployableFile TRACED_PROBE = new DeployableFile.Builder("traced_probes").setReleaseDir(Constants.PERFETTO_RELEASE_DIR).setDevDir(Constants.PERFETTO_DEV_DIR).setExecutable(true).setOnDeviceAbiFileNameFormat("traced_probes_%s").build();

        private HostFiles() {
        }
    }
}

