/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.transport;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.transport.Constants;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.android.download.AndroidProfilerDownloader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeployableFile {
    @NotNull
    private final String myFileName;
    @NotNull
    private final String myReleaseDir;
    @NotNull
    private final String myDevDir;
    @Nullable
    private final String myOnDeviceAbiFileNameFormat;
    private final boolean myExecutable;
    @NotNull
    private final Supplier<Boolean> myIsRunningFromSourcesSupplier;
    @NotNull
    private final Supplier<String> myHomePathSupplier;
    @NotNull
    private final Supplier<String> mySourcesRootSupplier;

    private DeployableFile(@NotNull Builder builder2) {
        if (builder2 == null) {
            DeployableFile.$$$reportNull$$$0(0);
        }
        this.myFileName = builder2.myFileName;
        this.myReleaseDir = builder2.myReleaseDir;
        this.myDevDir = builder2.myDevDir;
        this.myOnDeviceAbiFileNameFormat = builder2.myOnDeviceAbiFileNameFormat;
        this.myIsRunningFromSourcesSupplier = builder2.myIsRunningFromSourcesSupplier;
        this.myHomePathSupplier = builder2.myHomePathSupplier;
        this.mySourcesRootSupplier = builder2.mySourcesRootSupplier;
        this.myExecutable = builder2.myExecutable;
    }

    @NotNull
    public String getFileName() {
        String string = this.myFileName;
        if (string == null) {
            DeployableFile.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isExecutable() {
        return this.myExecutable;
    }

    public boolean isAbiDependent() {
        return this.myOnDeviceAbiFileNameFormat != null;
    }

    @Nullable
    public String getOnDeviceAbiFileNameFormat() {
        return this.myOnDeviceAbiFileNameFormat;
    }

    @NotNull
    private File getDir(@NotNull String parent, @NotNull String child) {
        File childFile;
        if (parent == null) {
            DeployableFile.$$$reportNull$$$0(2);
        }
        if (child == null) {
            DeployableFile.$$$reportNull$$$0(3);
        }
        if ((childFile = new File(child)).isAbsolute()) {
            File file2 = childFile;
            if (file2 == null) {
                DeployableFile.$$$reportNull$$$0(4);
            }
            return file2;
        }
        return new File(parent, child);
    }

    @NotNull
    public File getDir() {
        if (this.myIsRunningFromSourcesSupplier.get().booleanValue()) {
            return this.getDir(this.mySourcesRootSupplier.get(), this.myDevDir);
        }
        return this.getDir(this.myHomePathSupplier.get(), this.myReleaseDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/transport/DeployableFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/transport/DeployableFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        @NotNull
        private final String myFileName;
        @NotNull
        private String myReleaseDir;
        @NotNull
        private String myDevDir;
        @Nullable
        private String myOnDeviceAbiFileNameFormat;
        @NotNull
        private Supplier<Boolean> myIsRunningFromSourcesSupplier;
        @NotNull
        private Supplier<String> myHomePathSupplier;
        @NotNull
        private Supplier<String> mySourcesRootSupplier;
        private boolean myExecutable;

        public Builder(@NotNull String fileName) {
            if (fileName == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myReleaseDir = Constants.PERFA_RELEASE_DIR;
            this.myDevDir = Constants.PERFA_DEV_DIR;
            this.myIsRunningFromSourcesSupplier = StudioPathManager::isRunningFromSources;
            this.myHomePathSupplier = () -> {
                if (IdeInfo.getInstance().isAndroidStudio()) {
                    return PathManager.getHomePath();
                }
                AndroidProfilerDownloader.getInstance().makeSureComponentIsInPlace();
                return AndroidProfilerDownloader.getInstance().getPluginDir().getAbsolutePath();
            };
            this.mySourcesRootSupplier = StudioPathManager::getSourcesRoot;
            this.myExecutable = false;
            this.myFileName = fileName;
        }

        @NotNull
        public Builder setReleaseDir(@NotNull String releaseDir) {
            if (releaseDir == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myReleaseDir = releaseDir;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setDevDir(@NotNull String devDir) {
            if (devDir == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myDevDir = devDir;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder setExecutable(boolean executable) {
            this.myExecutable = executable;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        public Builder setOnDeviceAbiFileNameFormat(@NotNull String format2) {
            if (format2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myOnDeviceAbiFileNameFormat = format2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @VisibleForTesting
        @NotNull
        public Builder setIsRunningFromSources(boolean isRunningFromSources) {
            this.myIsRunningFromSourcesSupplier = () -> isRunningFromSources;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @VisibleForTesting
        @NotNull
        public Builder setHomePath(String homePath) {
            this.myHomePathSupplier = () -> homePath;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @VisibleForTesting
        @NotNull
        public Builder setSourcesRoot(String sourcesRoot) {
            this.mySourcesRootSupplier = () -> sourcesRoot;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public DeployableFile build() {
            return new DeployableFile(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "releaseDir";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/transport/DeployableFile$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "devDir";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/transport/DeployableFile$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setReleaseDir";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDevDir";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setExecutable";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setOnDeviceAbiFileNameFormat";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setIsRunningFromSources";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setHomePath";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSourcesRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setReleaseDir";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setDevDir";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setOnDeviceAbiFileNameFormat";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

