/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRootSearchScope
extends GlobalSearchScope {
    @NotNull
    private final TObjectIntHashMap<File> myDirRootPaths;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;

    public FileRootSearchScope(@NotNull Project project, @NotNull Collection<File> rootDirPaths) {
        if (project == null) {
            FileRootSearchScope.$$$reportNull$$$0(0);
        }
        if (rootDirPaths == null) {
            FileRootSearchScope.$$$reportNull$$$0(1);
        }
        super(project);
        this.myDirRootPaths = new TObjectIntHashMap();
        int i2 = 1;
        for (File root2 : rootDirPaths) {
            this.myDirRootPaths.put((Object)root2, i2++);
        }
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean accept(@NotNull File file2) {
        if (file2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(2);
        }
        while (!file2.exists()) {
            if (this.myDirRootPaths.containsKey((Object)file2)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)true);
        if (virtualFile != null) {
            return this.accept(virtualFile);
        }
        return false;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        VirtualFile sourceRootForFile;
        File path2;
        if (file2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(3);
        }
        if (this.myDirRootPaths.contains((Object)(path2 = VfsUtilCore.virtualToIoFile((VirtualFile)file2)))) {
            return true;
        }
        if (this.myProjectFileIndex.isInContent(file2) && (sourceRootForFile = this.myProjectFileIndex.getSourceRootForFile(file2)) != null) {
            path2 = VfsUtilCore.virtualToIoFile((VirtualFile)sourceRootForFile);
            return this.myDirRootPaths.contains((Object)path2);
        }
        VirtualFile classRootForFile = this.myProjectFileIndex.getClassRootForFile(file2);
        if (classRootForFile != null) {
            path2 = VfsUtilCore.virtualToIoFile((VirtualFile)classRootForFile);
            return this.myDirRootPaths.contains((Object)path2);
        }
        return false;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1;
        if (file1 == null) {
            FileRootSearchScope.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(5);
        }
        if (Objects.equals(r1 = this.getFileRoot(file1), r2 = this.getFileRoot(file2))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int i1 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r1));
        int i2 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r2));
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            FileRootSearchScope.$$$reportNull$$$0(6);
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(7);
        }
        if (this.myProjectFileIndex.isInContent(file2)) {
            return this.myProjectFileIndex.getSourceRootForFile(file2);
        }
        return this.myProjectFileIndex.getClassRootForFile(file2);
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(8);
        }
        if (scope2 instanceof FileRootSearchScope) {
            FileRootSearchScope fileRootSearchScope = this.add((FileRootSearchScope)scope2);
            if (fileRootSearchScope == null) {
                FileRootSearchScope.$$$reportNull$$$0(9);
            }
            return fileRootSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope2);
        if (globalSearchScope == null) {
            FileRootSearchScope.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    protected FileRootSearchScope add(@NotNull FileRootSearchScope scope2) {
        if (scope2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(11);
        }
        return this.calculate(scope2, true);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    protected FileRootSearchScope subtract(@NotNull FileRootSearchScope scope2) {
        if (scope2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(12);
        }
        return this.calculate(scope2, false);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    private FileRootSearchScope calculate(@NotNull FileRootSearchScope scope2, boolean add2) {
        if (scope2 == null) {
            FileRootSearchScope.$$$reportNull$$$0(13);
        }
        HashSet<File> roots = new HashSet<File>();
        this.myDirRootPaths.forEach(file2 -> {
            roots.add((File)file2);
            return true;
        });
        scope2.myDirRootPaths.forEach(file2 -> {
            if (add2) {
                roots.add((File)file2);
            } else {
                roots.remove(file2);
            }
            return true;
        });
        Project project = this.getProject();
        assert (project != null);
        return new FileRootSearchScope(project, roots);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDirPaths";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/testartifacts/scopes/FileRootSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/FileRootSearchScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileRoot";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

