/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.ide.common.gradle.model.IdeAndroidArtifact;
import com.android.ide.common.gradle.model.IdeBaseArtifact;
import com.android.ide.common.gradle.model.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.projectsystem.TestArtifactSearchScopes;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExtIdeaCompilerOutput;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module2, @NotNull JavaParameters javaParameters) {
        if (javaParameters == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(0);
        }
        if (module2 == null || !GradleProjectInfo.getInstance(module2.getProject()).isBuildWithGradle()) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module2);
        if (androidModel == null) {
            AndroidJunitPatcher.addFoldersToClasspath(module2, null, javaParameters.getClassPath());
            return;
        }
        IdeJavaArtifact testArtifact = androidModel.getSelectedVariant().getUnitTestArtifact();
        if (testArtifact == null) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.getInstance(module2);
        if (testScopes == null) {
            return;
        }
        for (String path2 : classPath.getPathList()) {
            if (testScopes.includeInUnitTestClasspath(new File(path2))) continue;
            classPath.remove(path2);
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module2);
        if (platform == null) {
            return;
        }
        String originalClassPath = classPath.getPathsString();
        try {
            AndroidJunitPatcher.addRuntimeJarsToClasspath(testArtifact, classPath);
            AndroidJunitPatcher.replaceAndroidJarWithMockableJar(classPath, platform, testArtifact);
            AndroidJunitPatcher.addFoldersToClasspath(module2, testArtifact, classPath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Error patching the JUnit class path. Original class path:%n%s", originalClassPath), e);
        }
    }

    private static void replaceAndroidJarWithMockableJar(@NotNull PathsList classPath, @NotNull AndroidPlatform platform, @NotNull IdeJavaArtifact artifact) {
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(1);
        }
        if (platform == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(3);
        }
        String androidJarPath = platform.getTarget().getPath(1);
        for (Object entry : classPath.getPathList()) {
            if (!FileUtil.pathsEqual((String)androidJarPath, (String)entry)) continue;
            classPath.remove((String)entry);
        }
        ArrayList<String> mockableJars = new ArrayList<String>();
        for (String path2 : classPath.getPathList()) {
            if (!FilePaths.stringToFile((String)path2).getName().startsWith("mockable-")) continue;
            mockableJars.add(path2);
        }
        for (String mockableJar : mockableJars) {
            classPath.remove(mockableJar);
        }
        File mockableJar = artifact.getMockablePlatformJar();
        if (mockableJar != null) {
            classPath.addTail(mockableJar.getPath());
        } else {
            for (String mockableJarPath : mockableJars) {
                if (!mockableJarPath.endsWith("-" + platform.getApiLevel() + ".jar")) continue;
                classPath.addTail(mockableJarPath);
                return;
            }
        }
    }

    private static void addFoldersToClasspath(@NotNull Module module2, @Nullable IdeJavaArtifact testArtifact, @NotNull PathsList classPath) {
        if (module2 == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(4);
        }
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(5);
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module2.getProject());
        CompileScope scope2 = compilerManager.createModulesCompileScope(new Module[]{module2}, true, true);
        if (testArtifact != null) {
            classPath.addAllFiles(ExcludedRoots.getAdditionalClasspathFolders((IdeBaseArtifact)testArtifact));
        }
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.getInstance(module2);
        for (Module affectedModule : scope2.getAffectedModules()) {
            File kotlinClasses;
            File javaMainResources;
            File javaTestResources;
            JavaModuleModel javaModel;
            AndroidModuleModel affectedAndroidModel = AndroidModuleModel.get(affectedModule);
            if (affectedAndroidModel != null) {
                IdeAndroidArtifact mainArtifact = affectedAndroidModel.getMainArtifact();
                for (File folder : ExcludedRoots.getAdditionalClasspathFolders((IdeBaseArtifact)mainArtifact)) {
                    AndroidJunitPatcher.addToClasspath(folder, classPath, testScopes);
                }
            }
            if ((javaModel = JavaModuleModel.get(affectedModule)) == null) continue;
            ExtIdeaCompilerOutput output = javaModel.getCompilerOutput();
            File file2 = javaTestResources = output == null ? null : output.getTestResourcesDir();
            if (javaTestResources != null) {
                AndroidJunitPatcher.addToClasspath(javaTestResources, classPath, testScopes);
            }
            File file3 = javaMainResources = output == null ? null : output.getMainResourcesDir();
            if (javaMainResources != null) {
                AndroidJunitPatcher.addToClasspath(javaMainResources, classPath, testScopes);
            }
            if (javaModel.getBuildFolderPath() == null || !(kotlinClasses = javaModel.getBuildFolderPath().toPath().resolve("classes").resolve("kotlin").toFile()).exists()) continue;
            AndroidJunitPatcher.addToClasspath(new File(kotlinClasses, "main"), classPath, testScopes);
            AndroidJunitPatcher.addToClasspath(new File(kotlinClasses, "test"), classPath, testScopes);
        }
    }

    private static void addToClasspath(@NotNull File folder, @NotNull PathsList classPath, @Nullable TestArtifactSearchScopes scopes) {
        if (folder == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(6);
        }
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(7);
        }
        if (scopes == null || scopes.includeInUnitTestClasspath(folder)) {
            classPath.add(folder);
        }
    }

    private static void addRuntimeJarsToClasspath(@NotNull IdeJavaArtifact testArtifact, @NotNull PathsList classPath) {
        if (testArtifact == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(8);
        }
        if (classPath == null) {
            AndroidJunitPatcher.$$$reportNull$$$0(9);
        }
        for (File runtimeClasspath : testArtifact.getLevel2Dependencies().getRuntimeOnlyClasses()) {
            classPath.add(runtimeClasspath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArtifact";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "patchJavaParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceAndroidJarWithMockableJar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldersToClasspath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addToClasspath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addRuntimeJarsToClasspath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

