/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.view;

import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultStats;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResults;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCase;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidTestCaseResult;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestResultsRow;
import com.android.tools.idea.testartifacts.instrumented.testsuite.view.AndroidTestResultsRow$WhenMappings;
import java.io.File;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\"\u001a\u00020!H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/testartifacts/instrumented/testsuite/view/AndroidTestResultsRow;", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResults;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "methodName", "", "className", "packageName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getMethodName", "myTestCases", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCase;", "getPackageName", "addTestCase", "", "device", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "testCase", "getBenchmark", "getDuration", "Ljava/time/Duration;", "getErrorStackTrace", "getLogcat", "getResultStats", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultStats;", "getRetentionSnapshot", "Ljava/io/File;", "getStartTime", "", "(Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;)Ljava/lang/Long;", "getTestCaseResult", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidTestCaseResult;", "getTestResultSummary", "getTestResultSummaryText", "getTotalDuration", "intellij.android.core"})
final class AndroidTestResultsRow
extends DefaultMutableTreeNode
implements AndroidTestResults {
    private final Map<String, AndroidTestCase> myTestCases;
    @NotNull
    private final String methodName;
    @NotNull
    private final String className;
    @NotNull
    private final String packageName;

    public final void addTestCase(@NotNull AndroidDevice device, @NotNull AndroidTestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        this.myTestCases.put(device.getId(), testCase);
    }

    @Override
    @Nullable
    public AndroidTestCaseResult getTestCaseResult(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device.getId());
        return androidTestCase != null ? androidTestCase.getResult() : null;
    }

    @Override
    @NotNull
    public String getLogcat(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Object object = this.myTestCases.get(device.getId());
        if (object == null || (object = ((AndroidTestCase)object).getLogcat()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    public Long getStartTime(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device.getId());
        return androidTestCase != null ? androidTestCase.getStartTimestampMillis() : null;
    }

    @Override
    @Nullable
    public Duration getDuration(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Object object = this.myTestCases.get(device.getId());
        if (object == null || (object = ((AndroidTestCase)object).getStartTimestampMillis()) == null) {
            return null;
        }
        long start2 = (Long)object;
        Object object2 = this.myTestCases.get(device.getId());
        long end = object2 != null && (object2 = ((AndroidTestCase)object2).getEndTimestampMillis()) != null ? (Long)object2 : System.currentTimeMillis();
        long l = end - start2;
        long l2 = 0L;
        boolean bl = false;
        return Duration.ofMillis(Math.max(l, l2));
    }

    @Override
    @NotNull
    public Duration getTotalDuration() {
        Duration duration2 = Duration.ofMillis(SequencesKt.sumOfLong((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.myTestCases.values()), (Function1)getTotalDuration.1.INSTANCE)));
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.ofMillis(myTest\u2026- start, 0L)\n    }.sum())");
        return duration2;
    }

    @Override
    @NotNull
    public String getErrorStackTrace(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Object object = this.myTestCases.get(device.getId());
        if (object == null || (object = ((AndroidTestCase)object).getErrorStackTrace()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @NotNull
    public String getBenchmark(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Object object = this.myTestCases.get(device.getId());
        if (object == null || (object = ((AndroidTestCase)object).getBenchmark()) == null) {
            object = "";
        }
        return object;
    }

    @Override
    @Nullable
    public File getRetentionSnapshot(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        AndroidTestCase androidTestCase = this.myTestCases.get(device.getId());
        return androidTestCase != null ? androidTestCase.getRetentionSnapshot() : null;
    }

    @Override
    @NotNull
    public AndroidTestCaseResult getTestResultSummary() {
        return AndroidTestResultsKt.getSummaryResult(this.getResultStats());
    }

    @Override
    @NotNull
    public String getTestResultSummaryText() {
        AndroidTestResultStats stats = this.getResultStats();
        return stats.getFailed() == 1 ? "Fail" : (stats.getFailed() > 0 ? "Fail (" + stats.getFailed() + ')' : (stats.getCancelled() > 0 ? "Cancelled" : (stats.getRunning() > 0 ? "Running" : (stats.getPassed() > 0 ? "Pass" : (stats.getSkipped() > 0 ? "Skip" : "")))));
    }

    @Override
    @NotNull
    public AndroidTestResultStats getResultStats() {
        AndroidTestResultStats stats = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        Iterable $this$forEach$iv = this.myTestCases.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidTestCase it = (AndroidTestCase)element$iv;
            boolean bl = false;
            switch (AndroidTestResultsRow$WhenMappings.$EnumSwitchMapping$0[it.getResult().ordinal()]) {
                case 1: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getPassed();
                    androidTestResultStats.setPassed(n + 1);
                    break;
                }
                case 2: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getFailed();
                    androidTestResultStats.setFailed(n + 1);
                    break;
                }
                case 3: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getSkipped();
                    androidTestResultStats.setSkipped(n + 1);
                    break;
                }
                case 4: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getRunning();
                    androidTestResultStats.setRunning(n + 1);
                    break;
                }
                case 5: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getCancelled();
                    androidTestResultStats.setCancelled(n + 1);
                    break;
                }
            }
        }
        return stats;
    }

    @Override
    @NotNull
    public AndroidTestResultStats getResultStats(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        AndroidTestResultStats stats = new AndroidTestResultStats(0, 0, 0, 0, 0, 31, null);
        AndroidTestCaseResult androidTestCaseResult = this.getTestCaseResult(device);
        if (androidTestCaseResult != null) {
            switch (AndroidTestResultsRow$WhenMappings.$EnumSwitchMapping$1[androidTestCaseResult.ordinal()]) {
                case 1: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getPassed();
                    androidTestResultStats.setPassed(n + 1);
                    break;
                }
                case 2: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getFailed();
                    androidTestResultStats.setFailed(n + 1);
                    break;
                }
                case 3: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getSkipped();
                    androidTestResultStats.setSkipped(n + 1);
                    break;
                }
                case 4: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getRunning();
                    androidTestResultStats.setRunning(n + 1);
                    break;
                }
                case 5: {
                    AndroidTestResultStats androidTestResultStats = stats;
                    int n = androidTestResultStats.getCancelled();
                    androidTestResultStats.setCancelled(n + 1);
                    break;
                }
            }
        }
        return stats;
    }

    @Override
    @NotNull
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getPackageName() {
        return this.packageName;
    }

    public AndroidTestResultsRow(@NotNull String methodName, @NotNull String className2, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)className2, (String)"className");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        this.methodName = methodName;
        this.className = className2;
        this.packageName = packageName;
        boolean bl = false;
        this.myTestCases = new LinkedHashMap();
    }
}

