/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented.testsuite.export;

import com.android.annotations.concurrency.AnyThread;
import com.android.annotations.concurrency.UiThread;
import com.android.annotations.concurrency.WorkerThread;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestResultsTreeNode;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.AndroidTestResultsXmlFormatter;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.ExportUtilsKt;
import com.android.tools.idea.testartifacts.instrumented.testsuite.export.ExportUtilsKt$WhenMappings;
import com.android.tools.idea.testartifacts.instrumented.testsuite.model.AndroidDevice;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.export.ExportTestResultsAction;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.StringWriter;
import java.net.URL;
import java.time.Duration;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001aB\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0003\u001a$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0003\u001a`\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u0017H\u0007\u001a \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0003\u001a4\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00012\b\u0010!\u001a\u0004\u0018\u00010\"H\u0003\u00a8\u0006#"}, d2={"createOutputText", "", "exportConfig", "Lcom/intellij/execution/testframework/export/ExportTestResultsConfiguration;", "executionDuration", "Ljava/time/Duration;", "rootResultsNode", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/api/AndroidTestResultsTreeNode;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "devices", "", "Lcom/android/tools/idea/testartifacts/instrumented/testsuite/model/AndroidDevice;", "toolWindowId", "createTransformerHandler", "Ljavax/xml/transform/sax/TransformerHandler;", "exportAndroidTestMatrixResultXmlFile", "", "project", "Lcom/intellij/openapi/project/Project;", "exportFile", "Ljava/io/File;", "onFinishedFunc", "Lkotlin/Function0;", "openEditorOrBrowser", "result", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "", "showBalloon", "type", "Lcom/intellij/openapi/ui/MessageType;", "text", "listener", "Ljavax/swing/event/HyperlinkListener;", "intellij.android.core"})
public final class ExportUtilsKt {
    @AnyThread
    public static final void exportAndroidTestMatrixResultXmlFile(@NotNull Project project, @Nullable String toolWindowId, @NotNull ExportTestResultsConfiguration exportConfig, @NotNull File exportFile, @NotNull Duration executionDuration, @NotNull AndroidTestResultsTreeNode rootResultsNode, @NotNull RunConfiguration runConfiguration, @NotNull List<AndroidDevice> devices2, @NotNull Function0<Unit> onFinishedFunc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)exportConfig, (String)"exportConfig");
        Intrinsics.checkNotNullParameter((Object)exportFile, (String)"exportFile");
        Intrinsics.checkNotNullParameter((Object)executionDuration, (String)"executionDuration");
        Intrinsics.checkNotNullParameter((Object)rootResultsNode, (String)"rootResultsNode");
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Intrinsics.checkNotNullParameter(onFinishedFunc, (String)"onFinishedFunc");
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(exportConfig, executionDuration, rootResultsNode, runConfiguration, devices2, toolWindowId, exportFile, project, onFinishedFunc, project, ExecutionBundle.message((String)"export.test.results.task.name", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            final /* synthetic */ ExportTestResultsConfiguration $exportConfig;
            final /* synthetic */ Duration $executionDuration;
            final /* synthetic */ AndroidTestResultsTreeNode $rootResultsNode;
            final /* synthetic */ RunConfiguration $runConfiguration;
            final /* synthetic */ List $devices;
            final /* synthetic */ String $toolWindowId;
            final /* synthetic */ File $exportFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ Function0 $onFinishedFunc;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void resultFile;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                String string = ExportUtilsKt.access$createOutputText(this.$exportConfig, this.$executionDuration, this.$rootResultsNode, this.$runConfiguration, this.$devices, this.$toolWindowId);
                if (string == null) {
                    return;
                }
                String outputText = string;
                Object object = (Pair)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Pair<? extends VirtualFile, ? extends String>>(this, outputText){
                    final /* synthetic */ exportAndroidTestMatrixResultXmlFile.2 this$0;
                    final /* synthetic */ String $outputText;

                    @NotNull
                    public final Pair<VirtualFile, String> invoke() {
                        boolean $i$f$runWriteAction = false;
                        return (Pair)ApplicationManager.getApplication().runWriteAction(new Computable(this){
                            final /* synthetic */ exportAndroidTestMatrixResultXmlFile.run.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final T compute() {
                                Pair pair;
                                VirtualFile parent;
                                boolean bl = false;
                                this.this$0.this$0.$exportFile.getParentFile().mkdirs();
                                VirtualFile virtualFile = parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.this$0.this$0.$exportFile.getParentFile());
                                if (virtualFile == null || !virtualFile.isValid()) {
                                    pair = new Pair(null, (Object)ExecutionBundle.message((String)"failed.to.create.output.file", (Object[])new Object[]{this.this$0.this$0.$exportFile.getPath()}));
                                } else {
                                    VirtualFile virtualFile2 = parent.findChild(this.this$0.this$0.$exportFile.getName());
                                    if (virtualFile2 == null) {
                                        virtualFile2 = parent.createChildData((Object)((Object)this.this$0.this$0), this.this$0.this$0.$exportFile.getName());
                                    }
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"parent.findChild(exportF\u2026ta(this, exportFile.name)");
                                    VirtualFile resultFile = virtualFile2;
                                    VfsUtil.saveText((VirtualFile)resultFile, (String)this.this$0.$outputText);
                                    pair = new Pair((Object)resultFile, null);
                                }
                                return (T)pair;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$outputText = string;
                        super(0);
                    }
                }), (int)1, null);
                VirtualFile virtualFile = (VirtualFile)object.component1();
                String errorMessage = (String)object.component2();
                object = errorMessage;
                boolean bl = false;
                boolean bl2 = false;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                    MessageType messageType = MessageType.ERROR;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
                    String string2 = ExecutionBundle.message((String)"export.test.results.failed", (Object[])new Object[]{errorMessage});
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ExecutionBundle.message(\u2026ts.failed\", errorMessage)");
                    ExportUtilsKt.access$showBalloon(this.$project, this.$toolWindowId, messageType, string2, null);
                    return;
                }
                if (resultFile == null) {
                    return;
                }
                if (this.$exportConfig.isOpenResults()) {
                    ExportUtilsKt.access$openEditorOrBrowser((VirtualFile)resultFile, this.$project, this.$exportConfig.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                } else {
                    HyperlinkListener listener2 = new HyperlinkListener(this, (VirtualFile)resultFile){
                        final /* synthetic */ exportAndroidTestMatrixResultXmlFile.2 this$0;
                        final /* synthetic */ VirtualFile $resultFile;

                        public final void hyperlinkUpdate(HyperlinkEvent e) {
                            HyperlinkEvent hyperlinkEvent = e;
                            Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"e");
                            if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                                ExportUtilsKt.access$openEditorOrBrowser(this.$resultFile, this.this$0.$project, this.this$0.$exportConfig.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$resultFile = virtualFile;
                        }
                    };
                    MessageType messageType = MessageType.INFO;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.INFO");
                    String string3 = ExecutionBundle.message((String)"export.test.results.succeeded", (Object[])new Object[]{this.$exportFile.getName()});
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ExecutionBundle.message(\u2026ceeded\", exportFile.name)");
                    ExportUtilsKt.access$showBalloon(this.$project, this.$toolWindowId, messageType, string3, listener2);
                }
            }

            public void onFinished() {
                this.$onFinishedFunc.invoke();
            }
            {
                this.$exportConfig = $captured_local_variable$0;
                this.$executionDuration = $captured_local_variable$1;
                this.$rootResultsNode = $captured_local_variable$2;
                this.$runConfiguration = $captured_local_variable$3;
                this.$devices = $captured_local_variable$4;
                this.$toolWindowId = $captured_local_variable$5;
                this.$exportFile = $captured_local_variable$6;
                this.$project = $captured_local_variable$7;
                this.$onFinishedFunc = $captured_local_variable$8;
                super($super_call_param$9, $super_call_param$10, $super_call_param$11, $super_call_param$12);
            }
        });
    }

    public static /* synthetic */ void exportAndroidTestMatrixResultXmlFile$default(Project project, String string, ExportTestResultsConfiguration exportTestResultsConfiguration, File file2, Duration duration2, AndroidTestResultsTreeNode androidTestResultsTreeNode, RunConfiguration runConfiguration, List list, Function0 function0, int n, Object object) {
        if ((n & 0x100) != 0) {
            function0 = exportAndroidTestMatrixResultXmlFile.1.INSTANCE;
        }
        ExportUtilsKt.exportAndroidTestMatrixResultXmlFile(project, string, exportTestResultsConfiguration, file2, duration2, androidTestResultsTreeNode, runConfiguration, list, (Function0<Unit>)function0);
    }

    @WorkerThread
    private static final String createOutputText(ExportTestResultsConfiguration exportConfig, Duration executionDuration, AndroidTestResultsTreeNode rootResultsNode, RunConfiguration runConfiguration, List<AndroidDevice> devices2, String toolWindowId) {
        TransformerHandler transformerHandler = ExportUtilsKt.createTransformerHandler(exportConfig, runConfiguration, toolWindowId);
        if (transformerHandler == null) {
            return null;
        }
        TransformerHandler transformerHandler2 = transformerHandler;
        StringWriter writer = new StringWriter();
        transformerHandler2.setResult(new StreamResult(writer));
        new AndroidTestResultsXmlFormatter(executionDuration, rootResultsNode, devices2, runConfiguration, transformerHandler2, null, 32, null).execute();
        return writer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private static final TransformerHandler createTransformerHandler(ExportTestResultsConfiguration exportConfig, RunConfiguration runConfiguration, String toolWindowId) {
        TransformerHandler transformerHandler;
        TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
        if (transformerFactory == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.xml.transform.sax.SAXTransformerFactory");
        }
        SAXTransformerFactory transformerFactory2 = (SAXTransformerFactory)transformerFactory;
        ExportTestResultsConfiguration.ExportFormat exportFormat = exportConfig.getExportFormat();
        if (exportFormat != null) {
            switch (ExportUtilsKt$WhenMappings.$EnumSwitchMapping$0[exportFormat.ordinal()]) {
                case 1: {
                    TransformerHandler transformerHandler2 = transformerFactory2.newTransformerHandler();
                    boolean bl = false;
                    boolean bl2 = false;
                    TransformerHandler $this$apply = transformerHandler2;
                    boolean bl3 = false;
                    Transformer transformer = $this$apply.getTransformer();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Transformer $this$apply2 = transformer;
                    boolean bl6 = false;
                    $this$apply2.setOutputProperty("indent", "yes");
                    $this$apply2.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    transformerHandler = transformerHandler2;
                    return transformerHandler;
                }
                case 2: {
                    StreamSource xslSource = new StreamSource(URLUtil.openStream((URL)ExportTestResultsAction.class.getResource("intellij-export.xsl")));
                    TransformerHandler transformerHandler3 = transformerFactory2.newTransformerHandler(xslSource);
                    boolean bl = false;
                    boolean bl7 = false;
                    TransformerHandler $this$apply = transformerHandler3;
                    boolean bl8 = false;
                    Transformer transformer = $this$apply.getTransformer();
                    boolean bl9 = false;
                    boolean bl10 = false;
                    Transformer $this$apply3 = transformer;
                    boolean bl11 = false;
                    Object[] objectArray = new Object[2];
                    objectArray[0] = runConfiguration.getName();
                    ConfigurationType configurationType = runConfiguration.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"runConfiguration.type");
                    objectArray[1] = configurationType.getDisplayName();
                    $this$apply3.setParameter("TITLE", ExecutionBundle.message((String)"export.test.results.filename", (Object[])objectArray));
                    transformerHandler = transformerHandler3;
                    return transformerHandler;
                }
            }
        }
        File xslFile = new File(exportConfig.getUserTemplatePath());
        if (!xslFile.isFile()) {
            Project project = runConfiguration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"runConfiguration.project");
            MessageType messageType = MessageType.ERROR;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
            String string = ExecutionBundle.message((String)"export.test.results.custom.template.not.found", (Object[])new Object[]{xslFile.getPath()});
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExecutionBundle.message(\u2026not.found\", xslFile.path)");
            ExportUtilsKt.showBalloon(project, toolWindowId, messageType, string, null);
            return null;
        }
        TransformerHandler transformerHandler4 = transformerFactory2.newTransformerHandler(new StreamSource(xslFile));
        boolean bl = false;
        boolean bl12 = false;
        TransformerHandler $this$apply = transformerHandler4;
        boolean bl13 = false;
        Transformer transformer = $this$apply.getTransformer();
        boolean bl14 = false;
        boolean bl15 = false;
        Transformer $this$apply4 = transformer;
        boolean bl16 = false;
        Object[] objectArray = new Object[2];
        objectArray[0] = runConfiguration.getName();
        ConfigurationType configurationType = runConfiguration.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"runConfiguration.type");
        objectArray[1] = configurationType.getDisplayName();
        $this$apply4.setParameter("TITLE", ExecutionBundle.message((String)"export.test.results.filename", (Object[])objectArray));
        transformerHandler = transformerHandler4;
        return transformerHandler;
    }

    @AnyThread
    private static final void showBalloon(Project project, String toolWindowId, MessageType type, String text2, HyperlinkListener listener2) {
        String string = toolWindowId;
        if (string == null) {
            return;
        }
        String toolWindowId2 = string;
        ApplicationManager.getApplication().invokeLater(new Runnable(project, toolWindowId2, type, text2, listener2){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $toolWindowId;
            final /* synthetic */ MessageType $type;
            final /* synthetic */ String $text;
            final /* synthetic */ HyperlinkListener $listener;

            public final void run() {
                if (this.$project.isDisposed()) {
                    return;
                }
                if (ToolWindowManager.Companion.getInstance(this.$project).getToolWindow(this.$toolWindowId) != null) {
                    ToolWindowManager.Companion.getInstance(this.$project).notifyByBalloon(this.$toolWindowId, this.$type, this.$text, null, this.$listener);
                }
            }
            {
                this.$project = project;
                this.$toolWindowId = string;
                this.$type = messageType;
                this.$text = string2;
                this.$listener = hyperlinkListener2;
            }
        });
    }

    @UiThread
    private static final void openEditorOrBrowser(VirtualFile result2, Project project, boolean editor2) {
        ApplicationManager.getApplication().invokeLater(new Runnable(editor2, project, result2){
            final /* synthetic */ boolean $editor;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $result;

            public final void run() {
                if (this.$editor) {
                    FileEditorManager.getInstance((Project)this.$project).openFile(this.$result, true);
                } else {
                    BrowserUtil.browse((VirtualFile)this.$result);
                }
            }
            {
                this.$editor = bl;
                this.$project = project;
                this.$result = virtualFile;
            }
        });
    }

    public static final /* synthetic */ String access$createOutputText(ExportTestResultsConfiguration exportConfig, Duration executionDuration, AndroidTestResultsTreeNode rootResultsNode, RunConfiguration runConfiguration, List devices2, String toolWindowId) {
        return ExportUtilsKt.createOutputText(exportConfig, executionDuration, rootResultsNode, runConfiguration, devices2, toolWindowId);
    }

    public static final /* synthetic */ void access$showBalloon(Project project, String toolWindowId, MessageType type, String text2, HyperlinkListener listener2) {
        ExportUtilsKt.showBalloon(project, toolWindowId, type, text2, listener2);
    }

    public static final /* synthetic */ void access$openEditorOrBrowser(VirtualFile result2, Project project, boolean editor2) {
        ExportUtilsKt.openEditorOrBrowser(result2, project, editor2);
    }
}

