/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidClassBrowserBase<T extends JComponent>
extends BrowseModuleValueActionListener<T> {
    protected final ConfigurationModuleSelector myModuleSelector;
    protected final String myDialogTitle;
    protected final boolean myIncludeLibraryClasses;

    public AndroidClassBrowserBase(@NotNull Project project, @NotNull ConfigurationModuleSelector moduleSelector, @NotNull String dialogTitle, boolean includeLibraryClasses) {
        if (project == null) {
            AndroidClassBrowserBase.$$$reportNull$$$0(0);
        }
        if (moduleSelector == null) {
            AndroidClassBrowserBase.$$$reportNull$$$0(1);
        }
        if (dialogTitle == null) {
            AndroidClassBrowserBase.$$$reportNull$$$0(2);
        }
        super(project);
        this.myIncludeLibraryClasses = includeLibraryClasses;
        this.myDialogTitle = dialogTitle;
        this.myModuleSelector = moduleSelector;
    }

    @Nullable
    protected PsiClass findClass(String className2) {
        return this.myModuleSelector.findClass(className2);
    }

    protected String showDialog() {
        PsiClass initialSelection;
        Project project = this.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        Module module2 = this.myModuleSelector.getModule();
        if (module2 == null) {
            Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            return null;
        }
        GlobalSearchScope scope2 = this.myIncludeLibraryClasses ? module2.getModuleWithDependenciesAndLibrariesScope(true) : module2.getModuleWithDependenciesScope();
        TreeClassChooser chooser2 = this.createTreeClassChooser(project, scope2, initialSelection = facade.findClass(this.getText(), scope2), new ClassFilter(){

            public boolean isAccepted(PsiClass aClass) {
                if (aClass.isInterface()) {
                    return false;
                }
                PsiModifierList modifierList = aClass.getModifierList();
                return modifierList == null || !modifierList.hasModifierProperty("abstract");
            }
        });
        if (chooser2 == null) {
            return null;
        }
        chooser2.showDialog();
        PsiClass selClass = chooser2.getSelected();
        return selClass != null ? selClass.getQualifiedName() : null;
    }

    @Nullable
    protected abstract TreeClassChooser createTreeClassChooser(@NotNull Project var1, @NotNull GlobalSearchScope var2, @Nullable PsiClass var3, @NotNull ClassFilter var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "moduleSelector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dialogTitle";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/testartifacts/instrumented/AndroidClassBrowserBase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

