/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.annotations.concurrency.Slow;
import com.android.repository.Revision;
import com.android.tools.idea.downloads.DownloadService;
import com.android.tools.idea.stats.Distribution;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ResourceUtil;
import com.intellij.util.download.FileDownloader;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DistributionService
extends DownloadService {
    private static final Logger LOG = Logger.getInstance(DistributionService.class);
    private static final String STATS_URL = "https://dl.google.com/android/studio/metadata/distributions.json";
    private static final String STATS_FILENAME = "distributions.json";
    private static final String DOWNLOAD_FILENAME = "distributions_temp.json";
    private static final URL FALLBACK_URL = DistributionService.class.getClassLoader().getResource("wizardData/distributions.json");
    private static final File CACHE_PATH = new File(PathManager.getSystemPath(), "stats");
    private List<Distribution> myDistributions;
    private static DistributionService ourInstance;

    @NotNull
    public static DistributionService getInstance() {
        if (ourInstance == null) {
            ourInstance = new DistributionService();
        }
        DistributionService distributionService = ourInstance;
        if (distributionService == null) {
            DistributionService.$$$reportNull$$$0(0);
        }
        return distributionService;
    }

    @Nullable
    public List<Distribution> getDistributions() {
        return this.myDistributions;
    }

    @Slow
    public double getSupportedDistributionForApiLevel(int apiLevel) {
        if (apiLevel <= 0) {
            return 0.0;
        }
        this.refreshSynchronously();
        List<Distribution> distributions = this.getDistributions();
        if (distributions == null) {
            return -1.0;
        }
        double unsupportedSum = 0.0;
        for (Distribution d : distributions) {
            if (d.getApiLevel() >= apiLevel) break;
            unsupportedSum += d.getDistributionPercentage();
        }
        return 1.0 - unsupportedSum;
    }

    @Nullable
    public Distribution getDistributionForApiLevel(int apiLevel) {
        this.refreshSynchronously();
        List<Distribution> distributions = this.getDistributions();
        if (distributions == null) {
            return null;
        }
        for (Distribution d : distributions) {
            if (d.getApiLevel() != apiLevel) continue;
            return d;
        }
        return null;
    }

    DistributionService(@NotNull FileDownloader downloader, @NotNull File cachePath, @NotNull URL fallback) {
        if (downloader == null) {
            DistributionService.$$$reportNull$$$0(1);
        }
        if (cachePath == null) {
            DistributionService.$$$reportNull$$$0(2);
        }
        if (fallback == null) {
            DistributionService.$$$reportNull$$$0(3);
        }
        super(downloader, "Distribution Stats", fallback, cachePath, STATS_FILENAME);
    }

    private DistributionService() {
        super("Distribution Stats", STATS_URL, FALLBACK_URL, CACHE_PATH, DOWNLOAD_FILENAME, STATS_FILENAME);
    }

    @Override
    public void loadFromFile(@NotNull URL url) {
        if (url == null) {
            DistributionService.$$$reportNull$$$0(4);
        }
        try {
            String jsonString = ResourceUtil.loadText((InputStream)URLUtil.openStream((URL)url));
            List<Distribution> distributions = DistributionService.loadDistributionsFromJson(jsonString);
            this.myDistributions = distributions != null ? ImmutableList.copyOf(distributions) : null;
        }
        catch (IOException e) {
            LOG.error("Error while trying to load distributions file", (Throwable)e);
        }
    }

    @Nullable
    private static List<Distribution> loadDistributionsFromJson(String jsonString) {
        Type fullRevisionType = new TypeToken<Revision>(){}.getType();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(fullRevisionType, (json, typeOfT, context) -> Revision.parseRevision((String)json.getAsString()));
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<Distribution>>(){}.getType();
        try {
            return (List)gson.fromJson(jsonString, listType);
        }
        catch (JsonParseException e) {
            LOG.error("Parse exception while reading distributions.json", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/stats/DistributionService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/stats/DistributionService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFromFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

