/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.actions.CreateClassAction;
import com.android.tools.idea.actions.MakeIdeaModuleAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.progress.StudioProgressManagerAdapter;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.stats.GcPauseWatcher;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationProducer;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.ide.ApplicationLoadListener;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt.idea.KaptProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;

public class AndroidStudioInitializer
implements ActionConfigurationCustomizer {
    public void customize(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            AndroidStudioInitializer.$$$reportNull$$$0(0);
        }
        AndroidStudioInitializer.checkInstallation();
        AndroidStudioInitializer.setUpNewFilePopupActions(actionManager);
        AndroidStudioInitializer.setUpMakeActions(actionManager);
        AndroidStudioInitializer.disableGroovyLanguageInjection();
        if (((Boolean)StudioFlags.CUSTOM_JAVA_NEW_CLASS_DIALOG.get()).booleanValue()) {
            AndroidStudioInitializer.replaceNewClassDialog(actionManager);
        }
        AndroidStudioInitializer.setupAnalytics();
        AndroidStudioInitializer.disableIdeaJUnitConfigurations(actionManager);
        AndroidStudioInitializer.disableKaptImportHandlers();
        AndroidStudioInitializer.hideRarelyUsedIntellijActions(actionManager);
        AndroidStudioInitializer.setupResourceManagerActions(actionManager);
        if (((Boolean)StudioFlags.TWEAK_COLOR_SCHEME.get()).booleanValue()) {
            AndroidStudioInitializer.tweakDefaultColorScheme();
        }
        AndroidStudioInitializer.setUpDeviceComboBoxActions(actionManager);
    }

    private static void tweakDefaultColorScheme() {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        TextAttributes textAttributes = colorsScheme.getAttributes(HighlighterColors.TEXT);
        TextAttributes xmlTagAttributes = colorsScheme.getAttributes(XmlHighlighterColors.XML_TAG);
        xmlTagAttributes.setBackgroundColor(textAttributes.getBackgroundColor());
    }

    private static void setUpDeviceComboBoxActions(@NotNull ActionManager manager) {
        if (manager == null) {
            AndroidStudioInitializer.$$$reportNull$$$0(1);
        }
        String id = (Boolean)StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED.get() != false ? "SelectMultipleDevices" : "RunOnMultipleDevices";
        Actions.hideAction(manager, id);
    }

    private static void setupResourceManagerActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "Images.ShowThumbnails");
        AnAction servicesAction = actionManager.getAction("ServiceView.ShowServices");
        Actions.replaceAction(actionManager, "ServiceView.ShowServices", servicesAction);
    }

    private static void setupAnalytics() {
        Application application;
        if (!(AnalyticsSettings.getOptedIn() || (application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment() || Boolean.getBoolean("disable.android.analytics.consent.dialog.for.test"))) {
            ApplicationManager.getApplication().invokeLater(() -> AppUIUtil.showConsentsAgreementIfNeeded((Logger)AndroidStudioInitializer.getLog()));
        }
        application = ApplicationInfo.getInstance();
        UsageTracker.setVersion((String)application.getStrictVersion());
        UsageTracker.setIdeBrand((AndroidStudioEvent.IdeBrand)AndroidStudioInitializer.getIdeBrand());
        if (ApplicationManager.getApplication().isInternal()) {
            UsageTracker.setIdeaIsInternal((boolean)true);
        }
        AndroidStudioUsageTracker.setup(JobScheduler.getScheduler());
        new GcPauseWatcher();
    }

    private static AndroidStudioEvent.IdeBrand getIdeBrand() {
        if (IdeInfo.isGameTool()) {
            return AndroidStudioEvent.IdeBrand.GAME_TOOLS;
        }
        boolean isAswb = Arrays.stream(PluginManagerCore.getPlugins()).filter(plugin -> plugin.isBundled()).anyMatch(plugin -> plugin.getName().contains("G3Plugins") || plugin.getName().contains("Blaze"));
        return isAswb ? AndroidStudioEvent.IdeBrand.ANDROID_STUDIO_WITH_BLAZE : AndroidStudioEvent.IdeBrand.ANDROID_STUDIO;
    }

    private static void checkInstallation() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            AndroidStudioInitializer.getLog().info("Unable to find Studio home directory");
            return;
        }
        File studioHomePath = FilePaths.stringToFile((String)studioHome);
        if (!studioHomePath.isDirectory()) {
            AndroidStudioInitializer.getLog().info(String.format("The path '%1$s' does not belong to an existing directory", studioHomePath.getPath()));
            return;
        }
        File androidPluginLibFolderPath = new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android", "lib"}));
        if (!androidPluginLibFolderPath.isDirectory()) {
            AndroidStudioInitializer.getLog().info(String.format("The path '%1$s' does not belong to an existing directory", androidPluginLibFolderPath.getPath()));
            return;
        }
        if (new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android-designer"})).exists()) {
            String msg = "Your Android Studio installation is corrupt and will not work properly.\n(Found plugins/android-designer which should not be present.)\nThis usually happens if Android Studio is extracted into an existing older version.\n\nPlease reinstall (and make sure the new installation directory is empty first.)";
            String title = "Corrupt Installation";
            int option = Messages.showDialog((String)msg, (String)title, (String[])new String[]{"Quit", "Proceed Anyway"}, (int)0, (Icon)Messages.getErrorIcon());
            if (option == 0) {
                ApplicationManager.getApplication().exit();
            }
        }
    }

    private static void setUpNewFilePopupActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "NewHtmlFile");
        Actions.hideAction(actionManager, "NewPackageInfo");
        Actions.hideAction(actionManager, "NewForm");
        Actions.hideAction(actionManager, "NewDialog");
        Actions.hideAction(actionManager, "NewFormSnapshot");
        Actions.hideAction(actionManager, "Groovy.NewClass");
        Actions.hideAction(actionManager, "Groovy.NewScript");
    }

    private static void setUpMakeActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "CompileDirty");
        Actions.replaceAction(actionManager, "MakeModule", new MakeIdeaModuleAction());
        Actions.hideAction(actionManager, "CompileProject");
        Actions.hideAction(actionManager, "Compile");
    }

    private static void disableGroovyLanguageInjection() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExtensionPoint extensionPoint = MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getPoint((AreaInstance)project);
                for (MultiHostInjector injector : (MultiHostInjector[])extensionPoint.getExtensions()) {
                    if (!(injector instanceof GrConcatenationInjector)) continue;
                    extensionPoint.unregisterExtension(injector.getClass());
                    return;
                }
                AndroidStudioInitializer.getLog().info("Failed to disable 'org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector'");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/startup/AndroidStudioInitializer$1", "projectOpened"));
            }
        });
    }

    private static void replaceNewClassDialog(ActionManager actionManager) {
        Actions.replaceAction(actionManager, "NewClass", new CreateClassAction());
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        for (String templateName : new String[]{"Singleton", "Class", "Interface", "Enum", "AnnotationType"}) {
            FileTemplate template = fileTemplateManager.getInternalTemplate(templateName);
            template.setText(fileTemplateManager.getJ2eeTemplate(templateName).getText());
        }
    }

    private static void disableKaptImportHandlers() {
        ExtensionPoint resolverExtensionPoint = GradleProjectResolverExtension.EP_NAME.getPoint();
        resolverExtensionPoint.unregisterExtension(KaptProjectResolverExtension.class);
    }

    private static void disableIdeaJUnitConfigurations(ActionManager actionManager) {
        ExtensionPoint configurationProducerExtensionPoint = RunConfigurationProducer.EP_NAME.getPoint();
        for (RunConfigurationProducer runConfigurationProducer : (RunConfigurationProducer[])configurationProducerExtensionPoint.getExtensions()) {
            if (!(runConfigurationProducer instanceof JUnitConfigurationProducer) || runConfigurationProducer instanceof AndroidJUnitConfigurationProducer) continue;
            configurationProducerExtensionPoint.unregisterExtension(runConfigurationProducer.getClass());
        }
        ExtensionPoint configurationTypeExtensionPoint = ConfigurationType.CONFIGURATION_TYPE_EP.getPoint();
        for (ConfigurationType configurationType : (ConfigurationType[])configurationTypeExtensionPoint.getExtensions()) {
            if (!(configurationType instanceof JUnitConfigurationType) || configurationType instanceof AndroidJUnitConfigurationType) continue;
            configurationTypeExtensionPoint.unregisterExtension(configurationType.getClass());
        }
        Actions.hideAction(actionManager, "excludeFromSuite");
        Actions.hideAction(actionManager, "AddToISuite");
    }

    private static void hideRarelyUsedIntellijActions(ActionManager actionManager) {
        Actions.hideAction(actionManager, "SaveFileAsTemplate");
    }

    @NotNull
    private static Logger getLog() {
        Logger logger2 = Logger.getInstance(AndroidStudioInitializer.class);
        if (logger2 == null) {
            AndroidStudioInitializer.$$$reportNull$$$0(2);
        }
        return logger2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/startup/AndroidStudioInitializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/startup/AndroidStudioInitializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setUpDeviceComboBoxActions";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class AndroidStudioLoadListener
    implements ApplicationLoadListener {
        public void beforeApplicationLoaded(@NotNull Application application, @NotNull String configPath) {
            if (application == null) {
                AndroidStudioLoadListener.$$$reportNull$$$0(0);
            }
            if (configPath == null) {
                AndroidStudioLoadListener.$$$reportNull$$$0(1);
            }
            StudioProgressManagerAdapter.initialize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "application";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configPath";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/startup/AndroidStudioInitializer$AndroidStudioLoadListener";
            objectArray[2] = "beforeApplicationLoaded";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

