/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.mainView;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteDatabaseId;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.ui.mainView.AddColumns;
import com.android.tools.idea.sqlite.ui.mainView.AddTable;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorView;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorViewImpl;
import com.android.tools.idea.sqlite.ui.mainView.IndexedSqliteColumn;
import com.android.tools.idea.sqlite.ui.mainView.IndexedSqliteTable;
import com.android.tools.idea.sqlite.ui.mainView.LeftPanelView;
import com.android.tools.idea.sqlite.ui.mainView.RemoveColumns;
import com.android.tools.idea.sqlite.ui.mainView.RemoveTable;
import com.android.tools.idea.sqlite.ui.mainView.SchemaDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.ViewDatabase;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\nJ.\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\b\u0010(\u001a\u00020\u0006H\u0002J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u0006H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u00100\u001a\u0004\u0018\u00010\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u00101\u001a\u00020.H\u0002J\u0018\u00102\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000206H\u0002J\u000e\u00107\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u000206J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010<\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001bJ\u000e\u0010?\u001a\u00020\u00152\u0006\u0010@\u001a\u000206R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView;", "", "mainView", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;", "(Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;)V", "component", "Ljavax/swing/JPanel;", "getComponent", "()Ljavax/swing/JPanel;", "databasesCount", "", "getDatabasesCount", "()I", "keepConnectionsOpenButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "refreshSchemaButton", "rootPanel", "runSqlButton", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "addColumnsToTableNode", "", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "tableNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "columnsToAdd", "", "Lcom/android/tools/idea/sqlite/ui/mainView/IndexedSqliteColumn;", "addDatabaseSchema", "viewDatabase", "Lcom/android/tools/idea/sqlite/ui/mainView/ViewDatabase;", "schema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "index", "addNewTableNode", "databaseNode", "sqliteTableToAdd", "Lcom/android/tools/idea/sqlite/ui/mainView/IndexedSqliteTable;", "sqliteColumnsToAdd", "createCenterPanel", "createCollapseTreeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "createNorthPanel", "findColumnNode", "columnName", "", "findDatabaseNode", "findTableNode", "tableName", "fireAction", "e", "Ljava/awt/event/InputEvent;", "hasLiveDatabases", "", "removeDatabaseSchema", "setRefreshButtonState", "state", "setUpSchemaTree", "setUpSchemaTreeListeners", "updateDatabase", "diffOperations", "Lcom/android/tools/idea/sqlite/ui/mainView/SchemaDiffOperation;", "updateKeepConnectionOpenButton", "enabled", "SchemaTreeCellRenderer", "intellij.android.debuggers"})
public final class LeftPanelView {
    private final JPanel rootPanel;
    private final Tree tree;
    private final CommonButton refreshSchemaButton;
    private final CommonButton runSqlButton;
    private final CommonButton keepConnectionsOpenButton;
    @NotNull
    private final JPanel component;
    private final DatabaseInspectorViewImpl mainView;

    @NotNull
    public final JPanel getComponent() {
        return this.component;
    }

    public final int getDatabasesCount() {
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
        Object object = treeModel.getRoot();
        if (!(object instanceof DefaultMutableTreeNode)) {
            object = null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return defaultMutableTreeNode != null ? defaultMutableTreeNode.getChildCount() : 0;
    }

    @NotNull
    public final AnAction createCollapseTreeAction() {
        return (AnAction)new CollapseAllAction((JTree)this.tree);
    }

    public final void updateKeepConnectionOpenButton(boolean enabled) {
        if (enabled) {
            this.keepConnectionsOpenButton.setIcon(StudioIcons.DatabaseInspector.KEEP_DATABASES_OPEN);
        } else {
            this.keepConnectionsOpenButton.setIcon(StudioIcons.DatabaseInspector.ALLOW_DATABASES_TO_CLOSE);
        }
        this.keepConnectionsOpenButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.keepConnectionsOpenButton.getIcon()));
    }

    /*
     * WARNING - void declaration
     */
    public final void addDatabaseSchema(@NotNull ViewDatabase viewDatabase, @Nullable SqliteSchema schema, int index2) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        TreeModel treeModel = this.tree.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        }
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        if (treeModel2.getRoot() == null) {
            DefaultMutableTreeNode root2 = new DefaultMutableTreeNode("Databases");
            treeModel2.setRoot(root2);
            defaultMutableTreeNode = root2;
        } else {
            Object object = treeModel2.getRoot();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        }
        DefaultMutableTreeNode root3 = defaultMutableTreeNode;
        DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(viewDatabase);
        Object object = schema;
        if (object != null && (object = ((SqliteSchema)object).getTables()) != null) {
            Iterable $this$sortedBy$iv = (Iterable)object;
            boolean $i$f$sortedBy = false;
            boolean bl = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    SqliteTable it = (SqliteTable)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (SqliteTable)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            if (object != null) {
                void $this$forEach$iv;
                $this$sortedBy$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqliteTable table2 = (SqliteTable)element$iv;
                    boolean bl2 = false;
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(table2);
                    Iterable $this$forEach$iv2 = table2.getColumns();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SqliteColumn column = (SqliteColumn)element$iv2;
                        boolean bl3 = false;
                        tableNode.add(new DefaultMutableTreeNode(column));
                    }
                    schemaNode.add(tableNode);
                }
            }
        }
        treeModel2.insertNodeInto(schemaNode, root3, index2);
        if (schema == null) {
            this.tree.expandPath(new TreePath(root3));
        } else {
            this.tree.expandPath(new TreePath(schemaNode.getPath()));
        }
        this.refreshSchemaButton.setEnabled(true);
        this.runSqlButton.setEnabled(true);
        this.keepConnectionsOpenButton.setEnabled(this.hasLiveDatabases());
    }

    /*
     * WARNING - void declaration
     */
    public final void updateDatabase(@NotNull ViewDatabase viewDatabase, @NotNull List<? extends SchemaDiffOperation> diffOperations) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        Intrinsics.checkNotNullParameter(diffOperations, (String)"diffOperations");
        TreeModel treeModel = this.tree.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        }
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        DefaultMutableTreeNode databaseNode = this.findDatabaseNode(viewDatabase);
        databaseNode.setUserObject(viewDatabase);
        for (SchemaDiffOperation schemaDiffOperation : diffOperations) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            DefaultMutableTreeNode tableNode;
            boolean bl;
            String string;
            SchemaDiffOperation schemaDiffOperation2 = schemaDiffOperation;
            if (schemaDiffOperation2 instanceof AddTable) {
                this.addNewTableNode(treeModel2, databaseNode, ((AddTable)schemaDiffOperation).getIndexedSqliteTable(), ((AddTable)schemaDiffOperation).getColumns());
                continue;
            }
            if (schemaDiffOperation2 instanceof AddColumns) {
                if (this.findTableNode(databaseNode, ((AddColumns)schemaDiffOperation).getTableName()) == null) {
                    string = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", ((AddColumns)schemaDiffOperation).getTableName());
                    bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                tableNode.setUserObject(((AddColumns)schemaDiffOperation).getNewTable());
                this.addColumnsToTableNode(treeModel2, tableNode, ((AddColumns)schemaDiffOperation).getColumns());
                continue;
            }
            if (schemaDiffOperation2 instanceof RemoveTable) {
                if (this.findTableNode(databaseNode, ((RemoveTable)schemaDiffOperation).getTableName()) == null) {
                    string = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", ((RemoveTable)schemaDiffOperation).getTableName());
                    bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                treeModel2.removeNodeFromParent(tableNode);
                continue;
            }
            if (!(schemaDiffOperation2 instanceof RemoveColumns)) continue;
            if (this.findTableNode(databaseNode, ((RemoveColumns)schemaDiffOperation).getTableName()) == null) {
                string = DatabaseInspectorBundle.INSTANCE.message("tree.node.not.found", ((RemoveColumns)schemaDiffOperation).getTableName());
                bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            tableNode.setUserObject(((RemoveColumns)schemaDiffOperation).getNewTable());
            Iterable $this$map$iv = ((RemoveColumns)schemaDiffOperation).getColumnsToRemove();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SqliteColumn sqliteColumn = (SqliteColumn)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                DefaultMutableTreeNode defaultMutableTreeNode = this.findColumnNode(tableNode, it.getName());
                collection2.add(defaultMutableTreeNode);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl3 = false;
                treeModel2.removeNodeFromParent(it);
            }
        }
    }

    public final int removeDatabaseSchema(@NotNull ViewDatabase viewDatabase) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        TreeModel treeModel = this.tree.getModel();
        if (treeModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultTreeModel");
        }
        DefaultTreeModel treeModel2 = (DefaultTreeModel)treeModel;
        DefaultMutableTreeNode databaseNode = this.findDatabaseNode(viewDatabase);
        treeModel2.removeNodeFromParent(databaseNode);
        this.keepConnectionsOpenButton.setEnabled(this.hasLiveDatabases());
        if (this.getDatabasesCount() == 0) {
            this.tree.setModel((TreeModel)new DefaultTreeModel(null));
            this.refreshSchemaButton.setEnabled(false);
            this.runSqlButton.setEnabled(false);
        }
        return this.getDatabasesCount();
    }

    private final JPanel createNorthPanel() {
        JPanel northPanel = new JPanel(new FlowLayout(0));
        this.refreshSchemaButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)AllIcons.Actions.Refresh));
        this.refreshSchemaButton.setName("refresh-schema-button");
        this.refreshSchemaButton.setEnabled(false);
        this.refreshSchemaButton.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("action.refresh.schema.tooltip", new String[0]));
        northPanel.add((Component)this.refreshSchemaButton);
        this.refreshSchemaButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.refreshAllOpenDatabasesSchemaActionInvoked();
                }
            }
            {
                this.this$0 = leftPanelView;
            }
        });
        this.runSqlButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)StudioIcons.DatabaseInspector.NEW_QUERY));
        this.runSqlButton.setName("run-sql-button");
        this.runSqlButton.setEnabled(false);
        this.runSqlButton.setToolTipText(DatabaseInspectorBundle.INSTANCE.message("action.run.query.tooltip", new String[0]));
        northPanel.add((Component)this.runSqlButton);
        this.runSqlButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.openSqliteEvaluatorTabActionInvoked();
                }
            }
            {
                this.this$0 = leftPanelView;
            }
        });
        this.keepConnectionsOpenButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)this.keepConnectionsOpenButton.getIcon()));
        this.keepConnectionsOpenButton.setName("keep-connections-open-button");
        this.keepConnectionsOpenButton.setEnabled(false);
        new HelpTooltip().setTitle(DatabaseInspectorBundle.INSTANCE.message("action.keep.open.tooltip.title", new String[0])).setDescription(DatabaseInspectorBundle.INSTANCE.message("action.keep.open.tooltip.desc", new String[0])).setLink(DatabaseInspectorBundle.INSTANCE.message("learn.more", new String[0]), (Runnable)createNorthPanel.3.INSTANCE).installOn((JComponent)this.keepConnectionsOpenButton);
        northPanel.add((Component)this.keepConnectionsOpenButton);
        this.keepConnectionsOpenButton.addActionListener(new ActionListener(this){
            final /* synthetic */ LeftPanelView this$0;

            public final void actionPerformed(ActionEvent it) {
                Iterable $this$forEach$iv = LeftPanelView.access$getMainView$p(this.this$0).getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it2 = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it2.toggleKeepConnectionOpenActionInvoked();
                }
            }
            {
                this.this$0 = leftPanelView;
            }
        });
        return northPanel;
    }

    private final JPanel createCenterPanel() {
        JPanel centerPanel2 = new JPanel(new BorderLayout());
        centerPanel2.setBorder(IdeBorderFactory.createBorder((int)2));
        JBScrollPane scrollPane = new JBScrollPane((Component)this.tree);
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        centerPanel2.add((Component)scrollPane, "Center");
        return centerPanel2;
    }

    private final void setUpSchemaTree(Tree tree) {
        tree.setCellRenderer((TreeCellRenderer)((Object)new SchemaTreeCellRenderer()));
        tree.setRootVisible(false);
        tree.setModel((TreeModel)new DefaultTreeModel(null));
        tree.setToggleClickCount(0);
        StatusText statusText = tree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"tree.emptyText");
        statusText.setText(DatabaseInspectorBundle.INSTANCE.message("nothing.to.show", new String[0]));
        StatusText statusText2 = tree.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText2, (String)"tree.emptyText");
        statusText2.setShowAboveCenter(false);
        tree.setName("left-panel-tree");
        this.setUpSchemaTreeListeners(tree);
    }

    private final void setUpSchemaTreeListeners(Tree tree) {
        KeyAdapter treeKeyAdapter2 = new KeyAdapter(this, tree){
            final /* synthetic */ LeftPanelView this$0;
            final /* synthetic */ Tree $tree;

            public void keyPressed(@NotNull KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getKeyCode() == 10) {
                    LeftPanelView.access$fireAction(this.this$0, this.$tree, event);
                }
            }
            {
                this.this$0 = this$0;
                this.$tree = $captured_local_variable$1;
            }
        };
        DoubleClickListener treeDoubleClickListener2 = new DoubleClickListener(this, tree){
            final /* synthetic */ LeftPanelView this$0;
            final /* synthetic */ Tree $tree;

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LeftPanelView.access$fireAction(this.this$0, this.$tree, event);
                return true;
            }
            {
                this.this$0 = this$0;
                this.$tree = $captured_local_variable$1;
            }
        };
        tree.addKeyListener((KeyListener)treeKeyAdapter2);
        treeDoubleClickListener2.installOn((Component)tree);
    }

    private final void fireAction(Tree tree, InputEvent e) {
        TreePath treePath = tree.getSelectionPath();
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        if (!(object instanceof DefaultMutableTreeNode)) {
            object = null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode lastPathComponent = defaultMutableTreeNode;
        Object sqliteTable = lastPathComponent.getUserObject();
        if (sqliteTable instanceof SqliteTable) {
            TreeNode treeNode = lastPathComponent.getParent();
            if (treeNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode;
            Object object2 = parentNode.getUserObject();
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.ui.mainView.ViewDatabase");
            }
            ViewDatabase viewDatabase = (ViewDatabase)object2;
            Iterable $this$forEach$iv = this.mainView.getListeners();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DatabaseInspectorView.Listener l = (DatabaseInspectorView.Listener)element$iv;
                boolean bl = false;
                l.tableNodeActionInvoked(viewDatabase.getDatabaseId(), (SqliteTable)sqliteTable);
            }
            e.consume();
        } else {
            TreePath path2 = new TreePath(lastPathComponent.getPath());
            if (tree.isExpanded(path2)) {
                tree.collapsePath(path2);
            } else {
                tree.expandPath(path2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addNewTableNode(DefaultTreeModel treeModel, DefaultMutableTreeNode databaseNode, IndexedSqliteTable sqliteTableToAdd, List<IndexedSqliteColumn> sqliteColumnsToAdd) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void sqliteTable;
        IndexedSqliteTable indexedSqliteTable = sqliteTableToAdd;
        SqliteTable sqliteTable2 = indexedSqliteTable.component1();
        int index2 = indexedSqliteTable.component2();
        DefaultMutableTreeNode newTableNode = new DefaultMutableTreeNode(sqliteTable);
        Iterable $this$sortedBy$iv = sqliteColumnsToAdd;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                IndexedSqliteColumn it = (IndexedSqliteColumn)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getIndex());
                it = (IndexedSqliteColumn)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getIndex();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        });
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexedSqliteColumn indexedSqliteColumn = (IndexedSqliteColumn)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            SqliteColumn sqliteColumn = it.getSqliteColumn();
            collection2.add(sqliteColumn);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqliteColumn column = (SqliteColumn)element$iv;
            boolean bl3 = false;
            newTableNode.add(new DefaultMutableTreeNode(column));
        }
        treeModel.insertNodeInto(newTableNode, databaseNode, index2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addColumnsToTableNode(DefaultTreeModel treeModel, DefaultMutableTreeNode tableNode, List<IndexedSqliteColumn> columnsToAdd) {
        Iterable $this$forEach$iv = columnsToAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void sqliteColumn;
            IndexedSqliteColumn indexedSqliteColumn = (IndexedSqliteColumn)element$iv;
            boolean bl = false;
            IndexedSqliteColumn indexedSqliteColumn2 = indexedSqliteColumn;
            SqliteColumn sqliteColumn2 = indexedSqliteColumn2.component1();
            int index2 = indexedSqliteColumn2.component2();
            DefaultMutableTreeNode newColumnNode = new DefaultMutableTreeNode(sqliteColumn);
            treeModel.insertNodeInto(newColumnNode, tableNode, index2);
        }
    }

    private final DefaultMutableTreeNode findDatabaseNode(ViewDatabase viewDatabase) {
        Object element$iv2;
        block2: {
            TreeModel treeModel = this.tree.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
            Object object = treeModel.getRoot();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            }
            DefaultMutableTreeNode root2 = (DefaultMutableTreeNode)object;
            Enumeration<TreeNode> enumeration = root2.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"root.children()");
            Enumeration<TreeNode> enumeration2 = enumeration;
            boolean bl = false;
            Sequence $this$first$iv = SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2)), (Function1)findDatabaseNode.1.INSTANCE);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getUserObject(), (Object)viewDatabase)) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return (DefaultMutableTreeNode)element$iv2;
    }

    private final DefaultMutableTreeNode findTableNode(DefaultMutableTreeNode databaseNode, String tableName) {
        Object v2;
        block2: {
            Enumeration<TreeNode> enumeration = databaseNode.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"databaseNode.children()");
            Enumeration<TreeNode> enumeration2 = enumeration;
            boolean bl = false;
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2)), (Function1)findTableNode.1.INSTANCE), (Function1)findTableNode.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl2 = false;
                Object object = it.getUserObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteTable");
                }
                if (!Intrinsics.areEqual((Object)((SqliteTable)object).getName(), (Object)tableName)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final DefaultMutableTreeNode findColumnNode(DefaultMutableTreeNode databaseNode, String columnName) {
        Object v2;
        block2: {
            Enumeration<TreeNode> enumeration = databaseNode.children();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"databaseNode.children()");
            Enumeration<TreeNode> enumeration2 = enumeration;
            boolean bl = false;
            Sequence $this$firstOrNull$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2)), (Function1)findColumnNode.1.INSTANCE), (Function1)findColumnNode.2.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DefaultMutableTreeNode it = (DefaultMutableTreeNode)element$iv;
                boolean bl2 = false;
                Object object = it.getUserObject();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.android.tools.idea.sqlite.model.SqliteColumn");
                }
                if (!Intrinsics.areEqual((Object)((SqliteColumn)object).getName(), (Object)columnName)) continue;
                v2 = element$iv;
                break block2;
            }
            v2 = null;
        }
        return v2;
    }

    private final boolean hasLiveDatabases() {
        TreeModel treeModel = this.tree.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
        Object object = treeModel.getRoot();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
        }
        DefaultMutableTreeNode root2 = (DefaultMutableTreeNode)object;
        Enumeration<TreeNode> enumeration = root2.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"root.children()");
        Object object2 = enumeration;
        boolean bl = false;
        object2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(object2)), (Function1)hasLiveDatabases.1.INSTANCE), (Function1)hasLiveDatabases.2.INSTANCE));
        bl = false;
        return !object2.isEmpty();
    }

    public final void setRefreshButtonState(boolean state) {
        this.refreshSchemaButton.setEnabled(state);
    }

    public LeftPanelView(@NotNull DatabaseInspectorViewImpl mainView) {
        Intrinsics.checkNotNullParameter((Object)mainView, (String)"mainView");
        this.mainView = mainView;
        this.rootPanel = new JPanel(new BorderLayout());
        this.tree = new Tree();
        this.refreshSchemaButton = new CommonButton(AllIcons.Actions.Refresh);
        this.runSqlButton = new CommonButton(StudioIcons.DatabaseInspector.NEW_QUERY);
        this.keepConnectionsOpenButton = new CommonButton(StudioIcons.DatabaseInspector.KEEP_DATABASES_OPEN);
        this.component = this.rootPanel;
        JPanel northPanel = this.createNorthPanel();
        JPanel centerPanel2 = this.createCenterPanel();
        this.rootPanel.add((Component)northPanel, "North");
        this.rootPanel.add((Component)centerPanel2, "Center");
        this.setUpSchemaTree(this.tree);
    }

    public static final /* synthetic */ DatabaseInspectorViewImpl access$getMainView$p(LeftPanelView $this) {
        return $this.mainView;
    }

    public static final /* synthetic */ void access$fireAction(LeftPanelView $this, Tree tree, InputEvent e) {
        $this.fireAction(tree, e);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView$SchemaTreeCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "()V", "colorTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.debuggers"})
    private static final class SchemaTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final SimpleTextAttributes colorTextAttributes = new SimpleTextAttributes(0, (Color)JBColor.gray);

        public void customizeCellRenderer(@NotNull JTree tree, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            this.setToolTipText(null);
            if (value2 instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof ViewDatabase) {
                    this.append(((ViewDatabase)userObject).getDatabaseId().getName());
                    if (((ViewDatabase)userObject).isOpen()) {
                        this.setIcon(((ViewDatabase)userObject).getDatabaseId() instanceof SqliteDatabaseId.LiveSqliteDatabaseId ? StudioIcons.DatabaseInspector.DATABASE : StudioIcons.DatabaseInspector.DATABASE_OFFLINE);
                    } else {
                        this.append(" (closed)", this.colorTextAttributes);
                        this.setIcon(StudioIcons.DatabaseInspector.DATABASE_UNAVAILABLE);
                    }
                    this.setToolTipText(((ViewDatabase)userObject).getDatabaseId().getPath());
                } else if (userObject instanceof SqliteTable) {
                    this.setIcon(((SqliteTable)userObject).isView() ? StudioIcons.DatabaseInspector.VIEW : StudioIcons.DatabaseInspector.TABLE);
                    Intrinsics.checkNotNullExpressionValue((Object)this.append(((SqliteTable)userObject).getName()), (String)"append(userObject.name)");
                } else if (userObject instanceof SqliteColumn) {
                    if (((SqliteColumn)userObject).getInPrimaryKey()) {
                        this.setIcon(StudioIcons.DatabaseInspector.PRIMARY_KEY);
                    } else {
                        this.setIcon(StudioIcons.DatabaseInspector.COLUMN);
                    }
                    this.append(((SqliteColumn)userObject).getName());
                    this.append("  :  ", this.colorTextAttributes);
                    String string = ((SqliteColumn)userObject).getAffinity().name();
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
                    Locale locale2 = locale;
                    boolean bl = false;
                    String string2 = string;
                    boolean bl2 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toUpperCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
                    this.append(string4, this.colorTextAttributes);
                    this.append(((SqliteColumn)userObject).isNullable() ? "" : ", NOT NULL", this.colorTextAttributes);
                } else if (userObject instanceof String) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.append((String)userObject), (String)"append(userObject)");
                }
            }
            if (hasFocus && this.getIcon() != null) {
                Icon icon2 = this.getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"icon");
                this.setIcon(ColoredIconGenerator.generateWhiteIcon((Icon)icon2));
            }
        }
    }
}

