/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.ui.mainView;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.stdui.Chunk;
import com.android.tools.adtui.stdui.EmptyStatePanel;
import com.android.tools.adtui.stdui.LabelData;
import com.android.tools.adtui.stdui.NewLineChunk;
import com.android.tools.adtui.stdui.TextChunk;
import com.android.tools.adtui.stdui.UrlData;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.sqlite.controllers.TabId;
import com.android.tools.idea.sqlite.localization.DatabaseInspectorBundle;
import com.android.tools.idea.sqlite.ui.UtilsKt;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorView;
import com.android.tools.idea.sqlite.ui.mainView.DatabaseInspectorViewImpl;
import com.android.tools.idea.sqlite.ui.mainView.LeftPanelView;
import com.android.tools.idea.sqlite.ui.mainView.SchemaDiffOperation;
import com.android.tools.idea.sqlite.ui.mainView.ViewDatabase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.UIBundle;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBEditorTabsBorder;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0003LMNB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0013H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0019H\u0016J(\u0010)\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\nH\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0/H\u0002J\u0010\u00100\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0019H\u0016J(\u00101\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u00102\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0013H\u0016J\u001a\u00103\u001a\u00020\"2\u0006\u00104\u001a\u00020\u000e2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u00020\"2\u0006\u00104\u001a\u00020\u000eH\u0016J\u0010\u00108\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020;H\u0016J\u0018\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>H\u0016J\b\u0010@\u001a\u00020\"H\u0016J\u001e\u0010A\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EH\u0016J\u0016\u0010G\u001a\u00020\"2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020I0EH\u0016J\u0010\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020;H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorView;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "centerPanel", "Ljavax/swing/JPanel;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "databaseInspectorHelpUrl", "", "leftPanelView", "Lcom/android/tools/idea/sqlite/ui/mainView/LeftPanelView;", "listeners", "", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorView$Listener;", "getListeners", "()Ljava/util/List;", "offlineModeHelpUrl", "openTabs", "", "Lcom/android/tools/idea/sqlite/controllers/TabId;", "Lcom/intellij/ui/tabs/TabInfo;", "tabs", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$BorderedTabs;", "viewContext", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SqliteViewContext;", "workBench", "Lcom/android/tools/adtui/workbench/WorkBench;", "addEmptyStatePanel", "", "text", "url", "addListener", "listener", "closeTab", "tabId", "createTab", "tabName", "tabIcon", "Ljavax/swing/Icon;", "tabContent", "createToolWindowDefinition", "Lcom/android/tools/adtui/workbench/ToolWindowDefinition;", "focusTab", "openTab", "removeListener", "reportError", "message", "throwable", "", "reportSyncProgress", "resetCenterPanelAndAddView", "setRefreshButtonState", "state", "", "showEnterOfflineModePanel", "filesDownloaded", "", "totalFilesToDownload", "showOfflineModeUnavailablePanel", "updateDatabaseSchema", "viewDatabase", "Lcom/android/tools/idea/sqlite/ui/mainView/ViewDatabase;", "diffOperations", "", "Lcom/android/tools/idea/sqlite/ui/mainView/SchemaDiffOperation;", "updateDatabases", "databaseDiffOperations", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseDiffOperation;", "updateKeepConnectionOpenButton", "keepOpen", "BorderedTabs", "SchemaPanelToolContent", "SqliteViewContext", "intellij.android.debuggers"})
public final class DatabaseInspectorViewImpl
implements DatabaseInspectorView {
    @NotNull
    private final List<DatabaseInspectorView.Listener> listeners;
    private final JPanel centerPanel;
    private final LeftPanelView leftPanelView;
    private final SqliteViewContext viewContext;
    private final WorkBench<SqliteViewContext> workBench;
    private final BorderedTabs tabs;
    @NotNull
    private final JComponent component;
    private final Map<TabId, TabInfo> openTabs;
    private final String databaseInspectorHelpUrl;
    private final String offlineModeHelpUrl;

    @NotNull
    public final List<DatabaseInspectorView.Listener> getListeners() {
        return this.listeners;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void addListener(@NotNull DatabaseInspectorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DatabaseInspectorView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void updateDatabases(@NotNull List<? extends DatabaseDiffOperation> databaseDiffOperations) {
        Intrinsics.checkNotNullParameter(databaseDiffOperations, (String)"databaseDiffOperations");
        for (DatabaseDiffOperation databaseDiffOperation : databaseDiffOperations) {
            DatabaseDiffOperation databaseDiffOperation2 = databaseDiffOperation;
            if (databaseDiffOperation2 instanceof DatabaseDiffOperation.AddDatabase) {
                this.leftPanelView.addDatabaseSchema(((DatabaseDiffOperation.AddDatabase)databaseDiffOperation).getViewDatabase(), ((DatabaseDiffOperation.AddDatabase)databaseDiffOperation).getSchema(), ((DatabaseDiffOperation.AddDatabase)databaseDiffOperation).getIndex());
                continue;
            }
            if (!(databaseDiffOperation2 instanceof DatabaseDiffOperation.RemoveDatabase)) continue;
            this.leftPanelView.removeDatabaseSchema(((DatabaseDiffOperation.RemoveDatabase)databaseDiffOperation).getViewDatabase());
        }
        if (this.openTabs.isEmpty() || this.leftPanelView.getDatabasesCount() == 0) {
            this.addEmptyStatePanel(DatabaseInspectorBundle.INSTANCE.message("default.empty.state.message", new String[0]), this.databaseInspectorHelpUrl);
        }
    }

    @Override
    public void updateDatabaseSchema(@NotNull ViewDatabase viewDatabase, @NotNull List<? extends SchemaDiffOperation> diffOperations) {
        Intrinsics.checkNotNullParameter((Object)viewDatabase, (String)"viewDatabase");
        Intrinsics.checkNotNullParameter(diffOperations, (String)"diffOperations");
        this.leftPanelView.updateDatabase(viewDatabase, diffOperations);
    }

    @Override
    public void openTab(@NotNull TabId tabId, @NotNull String tabName, @NotNull Icon tabIcon, @NotNull JComponent component) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        Intrinsics.checkNotNullParameter((Object)tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter((Object)tabIcon, (String)"tabIcon");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.openTabs.isEmpty()) {
            this.resetCenterPanelAndAddView((JComponent)((Object)this.tabs));
        }
        TabInfo tab = this.createTab(tabId, tabName, tabIcon, component);
        this.tabs.addTab(tab);
        this.tabs.select(tab, true);
        this.openTabs.put(tabId, tab);
    }

    @Override
    public void focusTab(@NotNull TabId tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        TabInfo tabInfo = this.openTabs.get(tabId);
        Intrinsics.checkNotNull((Object)tabInfo);
        this.tabs.select(tabInfo, true);
    }

    @Override
    public void closeTab(@NotNull TabId tabId) {
        Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
        TabInfo tab = this.openTabs.remove(tabId);
        this.tabs.removeTab(tab);
        if (this.openTabs.isEmpty()) {
            this.addEmptyStatePanel(DatabaseInspectorBundle.INSTANCE.message("default.empty.state.message", new String[0]), this.databaseInspectorHelpUrl);
        }
    }

    @Override
    public void reportError(@NotNull String message2, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        UtilsKt.notifyError(message2, throwable);
    }

    @Override
    public void setRefreshButtonState(boolean state) {
        this.leftPanelView.setRefreshButtonState(state);
    }

    @Override
    public void showEnterOfflineModePanel(int filesDownloaded, int totalFilesToDownload) {
        EmptyStatePanel enterOfflineModePanel2 = new EmptyStatePanel(new LabelData(new Chunk[]{(Chunk)new TextChunk("Moving to offline mode"), (Chunk)NewLineChunk.INSTANCE, (Chunk)new TextChunk("" + '(' + filesDownloaded + '/' + totalFilesToDownload + ") databases downloaded...")}), null, new ActionData("Cancel", (Function0)new Function0<Unit>(this){
            final /* synthetic */ DatabaseInspectorViewImpl this$0;

            public final void invoke() {
                Iterable $this$forEach$iv = this.this$0.getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it.cancelOfflineModeInvoked();
                }
            }
            {
                this.this$0 = databaseInspectorViewImpl;
                super(0);
            }
        }), 2, null);
        enterOfflineModePanel2.setName("right-panel-offline-mode");
        this.resetCenterPanelAndAddView((JComponent)enterOfflineModePanel2);
    }

    @Override
    public void showOfflineModeUnavailablePanel() {
        this.addEmptyStatePanel("Offline mode unavailable.", this.offlineModeHelpUrl);
    }

    @Override
    public void updateKeepConnectionOpenButton(boolean keepOpen) {
        this.leftPanelView.updateKeepConnectionOpenButton(keepOpen);
    }

    @Override
    public void reportSyncProgress(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
    }

    private final void addEmptyStatePanel(String text2, String url) {
        EmptyStatePanel emptyStatePanel = new EmptyStatePanel(text2, new UrlData("Learn more", url), null, 4, null);
        emptyStatePanel.setName("right-panel-empty-state");
        this.resetCenterPanelAndAddView((JComponent)emptyStatePanel);
    }

    private final TabInfo createTab(TabId tabId, String tabName, Icon tabIcon, JComponent tabContent) {
        TabInfo tab = new TabInfo(tabContent);
        tab.setObject((Object)tabId);
        DefaultActionGroup tabActionGroup = new DefaultActionGroup();
        tabActionGroup.add(new AnAction(this, tabId, DatabaseInspectorBundle.INSTANCE.message("action.close.tab", new String[0]), DatabaseInspectorBundle.INSTANCE.message("action.close.tab.desc", new String[0]), AllIcons.Actions.Close){
            final /* synthetic */ DatabaseInspectorViewImpl this$0;
            final /* synthetic */ TabId $tabId;

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Iterable $this$forEach$iv = this.this$0.getListeners();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                    boolean bl = false;
                    it.closeTabActionInvoked(this.$tabId);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setHoveredIcon(AllIcons.Actions.CloseHovered);
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setVisible(true);
                Presentation presentation3 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
                presentation3.setText(UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]));
            }
            {
                this.this$0 = this$0;
                this.$tabId = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
        tab.setTabLabelActions((ActionGroup)tabActionGroup, "EditorTab");
        tab.setIcon(tabIcon);
        tab.setText(tabName);
        return tab;
    }

    private final void resetCenterPanelAndAddView(JComponent component) {
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add(component);
        this.centerPanel.revalidate();
        this.centerPanel.repaint();
    }

    private final ToolWindowDefinition<SqliteViewContext> createToolWindowDefinition() {
        return new ToolWindowDefinition("Databases", StudioIcons.DatabaseInspector.TABLE, "DATABASES", Side.LEFT, Split.TOP, AutoHide.DOCKED, ToolWindowDefinition.DEFAULT_SIDE_WIDTH, ToolWindowDefinition.DEFAULT_BUTTON_SIZE, 0, new Function(this){
            final /* synthetic */ DatabaseInspectorViewImpl this$0;

            public final ToolContent<SqliteViewContext> apply(Disposable it) {
                return this.this$0.new SchemaPanelToolContent();
            }
            {
                this.this$0 = databaseInspectorViewImpl;
            }
        });
    }

    public DatabaseInspectorViewImpl(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        boolean bl = false;
        this.listeners = new ArrayList();
        this.centerPanel = new JPanel(new BorderLayout());
        this.leftPanelView = new LeftPanelView(this);
        this.viewContext = new SqliteViewContext(this.leftPanelView.getComponent());
        this.workBench = new WorkBench(project, "Database Inspector", null, parentDisposable);
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getInstance(project)");
        this.tabs = new BorderedTabs(project, ideFocusManager, (Disposable)project);
        this.component = (JComponent)this.workBench;
        bl = false;
        this.openTabs = new LinkedHashMap();
        this.databaseInspectorHelpUrl = "https://d.android.com/r/studio-ui/db-inspector-help";
        this.offlineModeHelpUrl = "https://d.android.com/r/studio-ui/db-inspector-help/offline";
        this.workBench.init((JComponent)this.centerPanel, (Object)this.viewContext, CollectionsKt.listOf(this.createToolWindowDefinition()), false);
        this.addEmptyStatePanel(DatabaseInspectorBundle.INSTANCE.message("waiting.for.connection", new String[0]), this.databaseInspectorHelpUrl);
        this.tabs.setName("right-panel-tabs-panel");
        BorderedTabs borderedTabs = this.tabs;
        boolean bl2 = false;
        boolean bl3 = false;
        BorderedTabs $this$apply = borderedTabs;
        boolean bl4 = false;
        $this$apply.setTabDraggingEnabled(true);
        $this$apply.setUiDecorator(1.1.INSTANCE);
        $this$apply.addTabMouseListener(new MouseAdapter($this$apply, this){
            final /* synthetic */ BorderedTabs $this_apply;
            final /* synthetic */ DatabaseInspectorViewImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = databaseInspectorViewImpl;
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isCloseClick((MouseEvent)e)) {
                    TabInfo targetTabInfo;
                    TabInfo tabInfo = targetTabInfo = this.$this_apply.findInfo(e);
                    Object object = tabInfo != null ? tabInfo.getObject() : null;
                    if (!(object instanceof TabId)) {
                        object = null;
                    }
                    TabId tabId = (TabId)object;
                    if (tabId == null) {
                        return;
                    }
                    TabId tabId2 = tabId;
                    Iterable $this$forEach$iv = this.this$0.getListeners();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DatabaseInspectorView.Listener it = (DatabaseInspectorView.Listener)element$iv;
                        boolean bl = false;
                        it.closeTabActionInvoked(tabId2);
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0012\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SchemaPanelToolContent;", "Lcom/android/tools/adtui/workbench/ToolContent;", "Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SqliteViewContext;", "(Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl;)V", "component", "Ljavax/swing/JComponent;", "dispose", "", "getAdditionalActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getComponent", "setToolContext", "toolContext", "intellij.android.debuggers"})
    public final class SchemaPanelToolContent
    implements ToolContent<SqliteViewContext> {
        private JComponent component;

        public void setToolContext(@Nullable SqliteViewContext toolContext) {
            Object object = toolContext;
            if (object == null || (object = ((SqliteViewContext)object).getComponent()) == null) {
                object = new JPanel();
            }
            this.component = object;
        }

        @NotNull
        public JComponent getComponent() {
            JComponent jComponent = this.component;
            if (jComponent == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"component");
            }
            return jComponent;
        }

        public void dispose() {
        }

        @NotNull
        public List<AnAction> getAdditionalActions() {
            return CollectionsKt.listOf((Object)DatabaseInspectorViewImpl.this.leftPanelView.createCollapseTreeAction());
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$SqliteViewContext;", "", "component", "Ljavax/swing/JComponent;", "(Ljavax/swing/JComponent;)V", "getComponent", "()Ljavax/swing/JComponent;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.debuggers"})
    public static final class SqliteViewContext {
        @NotNull
        private final JComponent component;

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        public SqliteViewContext(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.component = component;
        }

        @NotNull
        public final JComponent component1() {
            return this.component;
        }

        @NotNull
        public final SqliteViewContext copy(@NotNull JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return new SqliteViewContext(component);
        }

        public static /* synthetic */ SqliteViewContext copy$default(SqliteViewContext sqliteViewContext, JComponent jComponent, int n, Object object) {
            if ((n & 1) != 0) {
                jComponent = sqliteViewContext.component;
            }
            return sqliteViewContext.copy(jComponent);
        }

        @NotNull
        public String toString() {
            return "SqliteViewContext(component=" + this.component + ")";
        }

        public int hashCode() {
            JComponent jComponent = this.component;
            return jComponent != null ? jComponent.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SqliteViewContext)) break block3;
                    SqliteViewContext sqliteViewContext = (SqliteViewContext)object;
                    if (!Intrinsics.areEqual((Object)this.component, (Object)sqliteViewContext.component)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/sqlite/ui/mainView/DatabaseInspectorViewImpl$BorderedTabs;", "Lcom/intellij/ui/tabs/impl/JBTabsImpl;", "project", "Lcom/intellij/openapi/project/Project;", "focusManager", "Lcom/intellij/openapi/wm/IdeFocusManager;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/IdeFocusManager;Lcom/intellij/openapi/Disposable;)V", "createTabBorder", "Lcom/intellij/ui/tabs/impl/JBEditorTabsBorder;", "intellij.android.debuggers"})
    private static final class BorderedTabs
    extends JBTabsImpl {
        @NotNull
        protected JBEditorTabsBorder createTabBorder() {
            return new JBEditorTabsBorder((JBTabsImpl)this);
        }

        public BorderedTabs(@NotNull Project project, @NotNull IdeFocusManager focusManager, @NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)focusManager, (String)"focusManager");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(project, focusManager, parent);
        }
    }
}

