/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.fileType;

import com.android.tools.idea.sqlite.DatabaseInspectorFlagController;
import com.android.tools.idea.sqlite.fileType.SqliteFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/sqlite/fileType/SqliteFileTypeDetector;", "Lcom/intellij/openapi/fileTypes/FileTypeRegistry$FileTypeDetector;", "()V", "SQLITE3_FORMAT_HEADER", "", "detect", "Lcom/intellij/openapi/fileTypes/FileType;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "firstBytes", "Lcom/intellij/openapi/util/io/ByteSequence;", "firstCharsIfText", "", "getDesiredContentPrefixLength", "", "intellij.android.debuggers"})
public final class SqliteFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    private final byte[] SQLITE3_FORMAT_HEADER;

    @Nullable
    public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        FileType fileType;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)firstBytes, (String)"firstBytes");
        if (!DatabaseInspectorFlagController.INSTANCE.isOpenFileEnabled()) {
            fileType = null;
        } else if (firstBytes.length() < this.SQLITE3_FORMAT_HEADER.length) {
            fileType = null;
        } else {
            byte[] byArray = firstBytes.subSequence(0, this.SQLITE3_FORMAT_HEADER.length).toBytes();
            byte[] byArray2 = this.SQLITE3_FORMAT_HEADER;
            boolean bl = false;
            fileType = Arrays.equals(byArray, byArray2) ? (FileType)SqliteFileType.INSTANCE : null;
        }
        return fileType;
    }

    public int getDesiredContentPrefixLength() {
        return this.SQLITE3_FORMAT_HEADER.length;
    }

    public SqliteFileTypeDetector() {
        String string = "SQLite format 3\u0000";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        this.SQLITE3_FORMAT_HEADER = byArray;
    }
}

