/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.live;

import androidx.sqlite.inspection.SqliteInspectorProtocol;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.DatabaseInspectorAnalyticsTracker;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt;
import com.android.tools.idea.sqlite.databaseConnection.live.UtilsKt$WhenMappings;
import com.android.tools.idea.sqlite.model.ResultSetSqliteColumn;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteAffinity;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteColumnValue;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.SqliteValue;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a$\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013*\b\u0012\u0004\u0012\u00020\u00160\u00132\u0006\u0010\u0017\u001a\u00020\u0018\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001bH\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0000\u001a\u0012\u0010 \u001a\u00020!*\b\u0012\u0004\u0012\u00020\"0\u0014H\u0000\u00a8\u0006#"}, d2={"buildQueryCommand", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Command;", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "databaseConnectionId", "", "getErrorMessage", "", "errorContent", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$ErrorContent;", "handleError", "", "project", "Lcom/intellij/openapi/project/Project;", "command", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "handleErrorContent", "mapToColumns", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Lcom/android/tools/idea/sqlite/model/ResultSetSqliteColumn;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Response;", "executor", "Ljava/util/concurrent/Executor;", "toSqliteColumn", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Column;", "toSqliteColumnValue", "Lcom/android/tools/idea/sqlite/model/SqliteColumnValue;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$CellValue;", "colName", "toSqliteSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "Landroidx/sqlite/inspection/SqliteInspectorProtocol$Table;", "intellij.android.debuggers"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SqliteInspectorProtocol.Command buildQueryCommand(@NotNull SqliteStatement sqliteStatement, int databaseConnectionId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        Iterable $this$map$iv = sqliteStatement.getParametersValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void param;
            SqliteValue sqliteValue = (SqliteValue)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            SqliteInspectorProtocol.QueryParameterValue.Builder builder2 = SqliteInspectorProtocol.QueryParameterValue.newBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            SqliteInspectorProtocol.QueryParameterValue.Builder builder3 = builder2;
            boolean bl4 = false;
            void var17_16 = param;
            if (var17_16 instanceof SqliteValue.StringValue) {
                SqliteInspectorProtocol.QueryParameterValue.Builder builder4 = builder3;
                Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"builder");
                builder4.setStringValue(((SqliteValue.StringValue)param).getValue());
            }
            SqliteInspectorProtocol.QueryParameterValue queryParameterValue = builder2.build();
            collection2.add(queryParameterValue);
        }
        List parameterValues = (List)destination$iv$iv;
        SqliteInspectorProtocol.QueryCommand.Builder queryBuilder = SqliteInspectorProtocol.QueryCommand.newBuilder().setQuery(sqliteStatement.getSqliteStatementText()).addAllQueryParameterValues((Iterable)parameterValues).setDatabaseId(databaseConnectionId);
        SqliteInspectorProtocol.Command command = SqliteInspectorProtocol.Command.newBuilder().setQuery(queryBuilder).build();
        Intrinsics.checkNotNullExpressionValue((Object)command, (String)"SqliteInspectorProtocol.\u2026ery(queryBuilder).build()");
        return command;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final SqliteColumnValue toSqliteColumnValue(@NotNull SqliteInspectorProtocol.CellValue $this$toSqliteColumnValue, @NotNull String colName) {
        Intrinsics.checkNotNullParameter((Object)$this$toSqliteColumnValue, (String)"$this$toSqliteColumnValue");
        Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
        SqliteInspectorProtocol.CellValue.OneOfCase oneOfCase = $this$toSqliteColumnValue.getOneOfCase();
        if (oneOfCase != null) {
            switch (UtilsKt$WhenMappings.$EnumSwitchMapping$0[oneOfCase.ordinal()]) {
                case 1: {
                    String string = $this$toSqliteColumnValue.getStringValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue");
                    SqliteColumnValue sqliteColumnValue = new SqliteColumnValue(colName, new SqliteValue.StringValue(string));
                    return sqliteColumnValue;
                }
                case 2: {
                    SqliteColumnValue sqliteColumnValue = new SqliteColumnValue(colName, new SqliteValue.StringValue(String.valueOf($this$toSqliteColumnValue.getDoubleValue())));
                    return sqliteColumnValue;
                }
                case 3: {
                    String string = BaseEncoding.base16().encode($this$toSqliteColumnValue.getBlobValue().toByteArray());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BaseEncoding.base16().en\u2026(blobValue.toByteArray())");
                    SqliteColumnValue sqliteColumnValue = new SqliteColumnValue(colName, new SqliteValue.StringValue(string));
                    return sqliteColumnValue;
                }
                case 4: {
                    SqliteColumnValue sqliteColumnValue = new SqliteColumnValue(colName, new SqliteValue.StringValue(String.valueOf($this$toSqliteColumnValue.getLongValue())));
                    return sqliteColumnValue;
                }
                case 5: {
                    SqliteColumnValue sqliteColumnValue = new SqliteColumnValue(colName, SqliteValue.NullValue.INSTANCE);
                    return sqliteColumnValue;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        String string = "value is null";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SqliteSchema toSqliteSchema(@NotNull List<SqliteInspectorProtocol.Table> $this$toSqliteSchema) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toSqliteSchema, (String)"$this$toSqliteSchema");
        Iterable $this$map$iv = $this$toSqliteSchema;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void table2;
            SqliteInspectorProtocol.Table table3 = (SqliteInspectorProtocol.Table)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            List list = table2.getColumnsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"table.columnsList");
            Iterable $this$map$iv2 = list;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                SqliteInspectorProtocol.Column column = (SqliteInspectorProtocol.Column)item$iv$iv2;
                Collection collection3 = destination$iv$iv2;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                SqliteColumn sqliteColumn = UtilsKt.toSqliteColumn((SqliteInspectorProtocol.Column)v1);
                collection3.add(sqliteColumn);
            }
            List columns2 = (List)destination$iv$iv2;
            RowIdName rowIdName = com.android.tools.idea.sqlite.model.UtilsKt.getRowIdName(columns2);
            String string = table2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"table.name");
            SqliteTable sqliteTable = new SqliteTable(string, columns2, rowIdName, table2.getIsView());
            collection2.add(sqliteTable);
        }
        List tables = (List)destination$iv$iv;
        return new SqliteSchema(tables);
    }

    @NotNull
    public static final ListenableFuture<List<ResultSetSqliteColumn>> mapToColumns(@NotNull ListenableFuture<SqliteInspectorProtocol.Response> $this$mapToColumns, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter($this$mapToColumns, (String)"$this$mapToColumns");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return FutureUtils.transform($this$mapToColumns, (Executor)executor, (Function1)mapToColumns.1.INSTANCE);
    }

    public static final void handleError(@NotNull Project project, @NotNull SqliteInspectorProtocol.Command command, @NotNull SqliteInspectorProtocol.ErrorContent errorContent, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (errorContent.getErrorCode() == SqliteInspectorProtocol.ErrorContent.ErrorCode.ERROR_NO_OPEN_DATABASE_WITH_REQUESTED_ID || errorContent.getErrorCode() == SqliteInspectorProtocol.ErrorContent.ErrorCode.ERROR_DB_CLOSED_DURING_OPERATION) {
            return;
        }
        SqliteInspectorProtocol.Command.OneOfCase oneOfCase = command.getOneOfCase();
        if (oneOfCase != null) {
            switch (UtilsKt$WhenMappings.$EnumSwitchMapping$1[oneOfCase.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    UtilsKt.handleErrorContent(project, errorContent, logger2);
                    break;
                }
            }
        }
    }

    private static final void handleErrorContent(Project project, SqliteInspectorProtocol.ErrorContent errorContent, Logger logger2) {
        DatabaseInspectorAnalyticsTracker analyticsTracker = DatabaseInspectorAnalyticsTracker.Companion.getInstance(project);
        SqliteInspectorProtocol.ErrorRecoverability errorRecoverability = errorContent.getRecoverability();
        Intrinsics.checkNotNullExpressionValue((Object)errorRecoverability, (String)"errorContent.recoverability");
        SqliteInspectorProtocol.ErrorRecoverability.OneOfCase oneOfCase = errorRecoverability.getOneOfCase();
        if (oneOfCase != null) {
            switch (UtilsKt$WhenMappings.$EnumSwitchMapping$2[oneOfCase.ordinal()]) {
                case 1: {
                    SqliteInspectorProtocol.ErrorRecoverability errorRecoverability2 = errorContent.getRecoverability();
                    Intrinsics.checkNotNullExpressionValue((Object)errorRecoverability2, (String)"errorContent.recoverability");
                    if (!errorRecoverability2.getIsRecoverable()) {
                        logger2.warn("Unrecoverable error from on-device inspector: " + errorContent.getMessage() + '\n' + errorContent.getStackTrace());
                        analyticsTracker.trackErrorOccurred(AppInspectionEvent.DatabaseInspectorEvent.ErrorKind.IS_RECOVERABLE_FALSE);
                        break;
                    }
                    analyticsTracker.trackErrorOccurred(AppInspectionEvent.DatabaseInspectorEvent.ErrorKind.IS_RECOVERABLE_TRUE);
                    break;
                }
                case 2: {
                    logger2.warn("Unknown if recoverable error from on-device inspector: " + errorContent.getMessage() + '\n' + errorContent.getStackTrace());
                    analyticsTracker.trackErrorOccurred(AppInspectionEvent.DatabaseInspectorEvent.ErrorKind.IS_RECOVERABLE_UNKNOWN);
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final String getErrorMessage(@NotNull SqliteInspectorProtocol.ErrorContent errorContent) {
        Intrinsics.checkNotNullParameter((Object)errorContent, (String)"errorContent");
        SqliteInspectorProtocol.ErrorRecoverability errorRecoverability = errorContent.getRecoverability();
        Intrinsics.checkNotNullExpressionValue((Object)errorRecoverability, (String)"errorContent.recoverability");
        SqliteInspectorProtocol.ErrorRecoverability.OneOfCase oneOfCase = errorRecoverability.getOneOfCase();
        if (oneOfCase != null) {
            switch (UtilsKt$WhenMappings.$EnumSwitchMapping$3[oneOfCase.ordinal()]) {
                case 1: {
                    SqliteInspectorProtocol.ErrorRecoverability errorRecoverability2 = errorContent.getRecoverability();
                    Intrinsics.checkNotNullExpressionValue((Object)errorRecoverability2, (String)"errorContent.recoverability");
                    String string = errorRecoverability2.getIsRecoverable() ? errorContent.getMessage() : "An error has occurred which requires you to restart your app: " + errorContent.getMessage();
                    String string2 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (errorContent.recover\u2026Content.message}\"\n      }");
                    return string2;
                }
                case 2: {
                    String string2 = "An error has occurred which might require you to restart your app: " + errorContent.getMessage();
                    return string2;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        String string = "value is null";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private static final SqliteColumn toSqliteColumn(SqliteInspectorProtocol.Column $this$toSqliteColumn) {
        String string = $this$toSqliteColumn.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        String string2 = $this$toSqliteColumn.getType();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type");
        return new SqliteColumn(string, SqliteAffinity.Companion.fromTypename(string2), !$this$toSqliteColumn.getIsNotNull(), $this$toSqliteColumn.getPrimaryKey() > 0);
    }
}

