/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite.databaseConnection.jdbc;

import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.sqlite.databaseConnection.DatabaseConnection;
import com.android.tools.idea.sqlite.databaseConnection.SqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcDatabaseConnection$WhenMappings;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.JdbcUtilsKt;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.LazyJdbcSqliteResultSet;
import com.android.tools.idea.sqlite.databaseConnection.jdbc.PagedJdbcSqliteResultSet;
import com.android.tools.idea.sqlite.model.RowIdName;
import com.android.tools.idea.sqlite.model.SqliteColumn;
import com.android.tools.idea.sqlite.model.SqliteSchema;
import com.android.tools.idea.sqlite.model.SqliteStatement;
import com.android.tools.idea.sqlite.model.SqliteTable;
import com.android.tools.idea.sqlite.model.UtilsKt;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection;", "Lcom/android/tools/idea/sqlite/databaseConnection/DatabaseConnection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "connection", "Ljava/sql/Connection;", "sqliteFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "pooledExecutor", "Ljava/util/concurrent/Executor;", "(Lcom/intellij/openapi/Disposable;Ljava/sql/Connection;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/concurrent/Executor;)V", "sequentialTaskExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "getSequentialTaskExecutor", "()Ljava/util/concurrent/ExecutorService;", "close", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "execute", "sqliteStatement", "Lcom/android/tools/idea/sqlite/model/SqliteStatement;", "query", "Lcom/android/tools/idea/sqlite/databaseConnection/SqliteResultSet;", "readColumnDefinitions", "", "Lcom/android/tools/idea/sqlite/model/SqliteColumn;", "tableName", "", "readSchema", "Lcom/android/tools/idea/sqlite/model/SqliteSchema;", "Companion", "intellij.android.debuggers"})
public final class JdbcDatabaseConnection
implements DatabaseConnection {
    @NotNull
    private final ExecutorService sequentialTaskExecutor;
    private final Connection connection;
    private final VirtualFile sqliteFile;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ExecutorService getSequentialTaskExecutor() {
        return this.sequentialTaskExecutor;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> close() {
        return FutureUtils.executeAsync((Executor)this.sequentialTaskExecutor, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ JdbcDatabaseConnection this$0;

            public final void invoke() {
                JdbcDatabaseConnection.access$getConnection$p(this.this$0).close();
                JdbcDatabaseConnection.access$getLogger$cp().info("Successfully closed database: " + JdbcDatabaseConnection.access$getSqliteFile$p(this.this$0).getPath());
            }
            {
                this.this$0 = jdbcDatabaseConnection;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteSchema> readSchema() {
        return FutureUtils.executeAsync((Executor)this.sequentialTaskExecutor, (Function0)((Function0)new Function0<SqliteSchema>(this){
            final /* synthetic */ JdbcDatabaseConnection this$0;

            @NotNull
            public final SqliteSchema invoke() {
                ResultSet tables = JdbcDatabaseConnection.access$getConnection$p(this.this$0).getMetaData().getTables(null, null, null, null);
                boolean bl = false;
                List sqliteTables = new ArrayList<E>();
                while (tables.next()) {
                    Connection connection = JdbcDatabaseConnection.access$getConnection$p(this.this$0);
                    String string = tables.getString("TABLE_NAME");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tables.getString(\"TABLE_NAME\")");
                    List columns2 = JdbcDatabaseConnection.access$readColumnDefinitions(this.this$0, connection, string);
                    RowIdName rowIdName = UtilsKt.getRowIdName(columns2);
                    String string2 = tables.getString("TABLE_NAME");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tables.getString(\"TABLE_NAME\")");
                    sqliteTables.add(new SqliteTable(string2, columns2, rowIdName, Intrinsics.areEqual((Object)tables.getString("TABLE_TYPE"), (Object)"VIEW")));
                }
                SqliteSchema sqliteSchema = new SqliteSchema(sqliteTables);
                boolean bl2 = false;
                boolean bl3 = false;
                SqliteSchema $this$apply = sqliteSchema;
                boolean bl4 = false;
                JdbcDatabaseConnection.access$getLogger$cp().info("Successfully read database schema: " + JdbcDatabaseConnection.access$getSqliteFile$p(this.this$0).getPath());
                return sqliteSchema;
            }
            {
                this.this$0 = jdbcDatabaseConnection;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public ListenableFuture<SqliteResultSet> query(@NotNull SqliteStatement sqliteStatement) {
        JdbcSqliteResultSet jdbcSqliteResultSet;
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        switch (JdbcDatabaseConnection$WhenMappings.$EnumSwitchMapping$0[sqliteStatement.getStatementType().ordinal()]) {
            case 1: {
                jdbcSqliteResultSet = new PagedJdbcSqliteResultSet(this.sequentialTaskExecutor, this.connection, sqliteStatement);
                break;
            }
            case 2: 
            case 3: {
                jdbcSqliteResultSet = new LazyJdbcSqliteResultSet(this.sequentialTaskExecutor, this.connection, sqliteStatement);
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("SqliteStatement must be of type SELECT, EXPLAIN or PRAGMA, but is " + (Object)((Object)sqliteStatement.getStatementType()));
            }
        }
        JdbcSqliteResultSet resultSet = jdbcSqliteResultSet;
        Disposer.register((Disposable)this, (Disposable)resultSet);
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)resultSet);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"Futures.immediateFuture(resultSet)");
        return listenableFuture;
    }

    @Override
    @NotNull
    public ListenableFuture<Unit> execute(@NotNull SqliteStatement sqliteStatement) {
        Intrinsics.checkNotNullParameter((Object)sqliteStatement, (String)"sqliteStatement");
        return FutureUtils.executeAsync((Executor)this.sequentialTaskExecutor, (Function0)((Function0)new Function0<Unit>(this, sqliteStatement){
            final /* synthetic */ JdbcDatabaseConnection this$0;
            final /* synthetic */ SqliteStatement $sqliteStatement;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                AutoCloseable autoCloseable = JdbcUtilsKt.resolvePreparedStatement(JdbcDatabaseConnection.access$getConnection$p(this.this$0), this.$sqliteStatement);
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    PreparedStatement preparedStatement = (PreparedStatement)autoCloseable;
                    boolean bl3 = false;
                    int n = preparedStatement.executeUpdate();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    int it = n;
                    boolean bl6 = false;
                    JdbcDatabaseConnection.access$getLogger$cp().info("SQL statement \"" + this.$sqliteStatement.getSqliteStatementText() + "\" executed with success.");
                    int n2 = n;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            {
                this.this$0 = jdbcDatabaseConnection;
                this.$sqliteStatement = sqliteStatement;
                super(0);
            }
        }));
    }

    /*
     * Exception decompiling
     */
    private final List<SqliteColumn> readColumnDefinitions(Connection connection, String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JdbcDatabaseConnection(@NotNull Disposable parentDisposable, @NotNull Connection connection, @NotNull VirtualFile sqliteFile, @NotNull Executor pooledExecutor) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)sqliteFile, (String)"sqliteFile");
        Intrinsics.checkNotNullParameter((Object)pooledExecutor, (String)"pooledExecutor");
        this.connection = connection;
        this.sqliteFile = sqliteFile;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Sqlite JDBC service", (Executor)pooledExecutor);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026service\", pooledExecutor)");
        this.sequentialTaskExecutor = executorService;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(JdbcDatabaseConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(JdbcD\u2026seConnection::class.java)");
        logger = logger2;
    }

    @Override
    public void dispose() {
        DatabaseConnection.DefaultImpls.dispose(this);
    }

    public static final /* synthetic */ Connection access$getConnection$p(JdbcDatabaseConnection $this) {
        return $this.connection;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ VirtualFile access$getSqliteFile$p(JdbcDatabaseConnection $this) {
        return $this.sqliteFile;
    }

    public static final /* synthetic */ List access$readColumnDefinitions(JdbcDatabaseConnection $this, Connection connection, String tableName) {
        return $this.readColumnDefinitions(connection, tableName);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/sqlite/databaseConnection/jdbc/JdbcDatabaseConnection$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.debuggers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

