/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sqlite;

import com.android.tools.idea.flags.StudioFlags;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0007R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/sqlite/DatabaseInspectorFlagController;", "", "()V", "isFeatureEnabled", "", "kotlin.jvm.PlatformType", "()Ljava/lang/Boolean;", "isOfflineModeEnabled", "()Z", "isOpenFileEnabled", "enableFeature", "enabled", "enableOfflineMode", "enableOpenFile", "intellij.android.debuggers"})
public final class DatabaseInspectorFlagController {
    @NotNull
    public static final DatabaseInspectorFlagController INSTANCE;

    public final Boolean isFeatureEnabled() {
        return (Boolean)StudioFlags.DATABASE_INSPECTOR_ENABLED.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOpenFileEnabled() {
        Object object = StudioFlags.DATABASE_INSPECTOR_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DATABASE_INSPECTOR_ENABLED.get()");
        if ((Boolean)object == false) return false;
        Object object2 = StudioFlags.DATABASE_INSPECTOR_OPEN_FILES_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DATABASE_INSPECTOR_OPEN_FILES_ENABLED.get()");
        if ((Boolean)object2 == false) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOfflineModeEnabled() {
        Object object = StudioFlags.DATABASE_INSPECTOR_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DATABASE_INSPECTOR_ENABLED.get()");
        if ((Boolean)object == false) return false;
        Object object2 = StudioFlags.DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED.get()");
        if ((Boolean)object2 == false) return false;
        return true;
    }

    @TestOnly
    public final boolean enableFeature(boolean enabled) {
        Boolean previous = this.isFeatureEnabled();
        StudioFlags.DATABASE_INSPECTOR_ENABLED.clearOverride();
        if (Intrinsics.areEqual((Object)enabled, (Object)((Boolean)StudioFlags.DATABASE_INSPECTOR_ENABLED.get())) ^ true) {
            StudioFlags.DATABASE_INSPECTOR_ENABLED.override((Object)enabled);
        }
        Boolean bl = previous;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"previous");
        return bl;
    }

    @TestOnly
    public final boolean enableOpenFile(boolean enabled) {
        boolean previous = this.isOpenFileEnabled();
        StudioFlags.DATABASE_INSPECTOR_OPEN_FILES_ENABLED.clearOverride();
        if (Intrinsics.areEqual((Object)enabled, (Object)((Boolean)StudioFlags.DATABASE_INSPECTOR_OPEN_FILES_ENABLED.get())) ^ true) {
            StudioFlags.DATABASE_INSPECTOR_OPEN_FILES_ENABLED.override((Object)enabled);
        }
        return previous;
    }

    @TestOnly
    public final boolean enableOfflineMode(boolean enabled) {
        boolean previous = this.isOfflineModeEnabled();
        StudioFlags.DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED.clearOverride();
        if (Intrinsics.areEqual((Object)enabled, (Object)((Boolean)StudioFlags.DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED.get())) ^ true) {
            StudioFlags.DATABASE_INSPECTOR_OFFLINE_MODE_ENABLED.override((Object)enabled);
        }
        return previous;
    }

    private DatabaseInspectorFlagController() {
    }

    static {
        DatabaseInspectorFlagController databaseInspectorFlagController;
        INSTANCE = databaseInspectorFlagController = new DatabaseInspectorFlagController();
    }
}

