/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressIndicatorAdapter;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.wizard.StudioWizardDialogBuilder;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.utils.HtmlBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SdkQuickfixUtils {
    private static final ProgressIndicator REPO_LOGGER = new StudioLoggerProgressIndicator(SdkQuickfixUtils.class);

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Component parent, @NotNull Collection<String> requestedPaths2, boolean backgroundable) {
        if (requestedPaths2 == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(0);
        }
        return SdkQuickfixUtils.createDialog(null, parent, requestedPaths2, null, null, SdkQuickfixUtils.getSdkHandler(), null, backgroundable);
    }

    @Nullable
    public static ModelWizardDialog createDialogForPackages(@Nullable Component parent, @NotNull Collection<UpdatablePackage> requestedPackages, @NotNull Collection<LocalPackage> uninstallPackages, boolean backgroundable) {
        if (requestedPackages == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(1);
        }
        if (uninstallPackages == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(2);
        }
        return SdkQuickfixUtils.createDialog(null, parent, null, requestedPackages, uninstallPackages, SdkQuickfixUtils.getSdkHandler(), null, backgroundable);
    }

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Project project, @NotNull Collection<String> requestedPaths2) {
        if (requestedPaths2 == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(3);
        }
        return SdkQuickfixUtils.createDialogForPaths(project, requestedPaths2, null);
    }

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Project project, @NotNull Collection<String> requestedPaths2, @Nullable String noOpMessage) {
        if (requestedPaths2 == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(4);
        }
        return SdkQuickfixUtils.createDialog(project, null, requestedPaths2, null, null, SdkQuickfixUtils.getSdkHandler(), noOpMessage, false);
    }

    @Nullable
    public static ModelWizardDialog createDialogForPaths(@Nullable Project project, @NotNull Collection<String> requestedPaths2, boolean backgroundable) {
        if (requestedPaths2 == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(5);
        }
        return SdkQuickfixUtils.createDialog(project, null, requestedPaths2, null, null, SdkQuickfixUtils.getSdkHandler(), null, backgroundable);
    }

    public static void showSdkMissingDialog() {
        String cancelText;
        String okText;
        String title;
        String msg = AndroidBundle.message("android.sdk.missing.msg", new Object[0]);
        if (Messages.showOkCancelDialog((Project)null, (String)msg, (String)(title = AndroidBundle.message("android.sdk.missing.title", new Object[0])), (String)(okText = AndroidBundle.message("android.sdk.open.manager", new Object[0])), (String)(cancelText = CommonBundle.getCancelButtonText()), (Icon)Messages.getErrorIcon()) == 0) {
            SdkQuickfixUtils.showAndroidSdkManager();
        }
    }

    public static void showAndroidSdkManager() {
        ActionManager.getInstance().getAction("Android.RunAndroidSdkManager").actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, dataId -> null));
    }

    private static AndroidSdkHandler getSdkHandler() {
        AndroidSdkData data = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        if (data == null) {
            SdkQuickfixUtils.showSdkMissingDialog();
            return null;
        }
        return data.getSdkHandler();
    }

    @VisibleForTesting
    @Nullable
    static ModelWizardDialog createDialog(@Nullable Project project, @Nullable Component parent, @Nullable Collection<String> requestedPaths2, @Nullable Collection<UpdatablePackage> requestedPackages, @Nullable Collection<LocalPackage> requestedUninstalls, @Nullable AndroidSdkHandler sdkHandler, @Nullable String noOpMessage, boolean backgroundable) {
        if (sdkHandler == null) {
            return null;
        }
        RepoManager mgr = sdkHandler.getSdkManager(REPO_LOGGER);
        if (mgr.getLocalPath() == null) {
            SdkQuickfixUtils.showSdkMissingDialog();
            return null;
        }
        ArrayList<String> unknownPaths = new ArrayList<String>();
        List<UpdatablePackage> resolvedPackages = new ArrayList<UpdatablePackage>();
        if (requestedPackages != null && !requestedPackages.isEmpty() || requestedPaths2 != null && !requestedPaths2.isEmpty()) {
            mgr.load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, null, null, null, (ProgressRunner)new StudioProgressRunner(true, false, "Finding Available SDK Components", project), (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), true);
            RepositoryPackages packages = mgr.getPackages();
            if (requestedPackages == null) {
                requestedPackages = new ArrayList<UpdatablePackage>();
            }
            requestedPackages.addAll(SdkQuickfixUtils.lookupPaths(requestedPaths2, packages, unknownPaths));
            try {
                resolvedPackages = SdkQuickfixUtils.resolve(requestedPackages, packages);
            }
            catch (PackageResolutionException e) {
                Messages.showErrorDialog((String)e.getMessage(), (String)"Error Resolving Packages");
                return null;
            }
        }
        HashSet<LocalPackage> resolvedUninstalls = new HashSet<LocalPackage>();
        if (requestedUninstalls != null) {
            resolvedUninstalls.addAll(requestedUninstalls);
            resolvedPackages.forEach(updatable -> resolvedUninstalls.remove(updatable.getLocal()));
        }
        ArrayList<UpdatablePackage> unavailableDownloads = new ArrayList<UpdatablePackage>();
        SdkQuickfixUtils.verifyAvailability(resolvedPackages, unavailableDownloads);
        if (!unknownPaths.isEmpty() || !unavailableDownloads.isEmpty()) {
            String title = "Packages Unavailable";
            HtmlBuilder builder2 = new HtmlBuilder();
            builder2.openHtmlBody().add(String.format("%1$s packages are not available for download!", resolvedPackages.isEmpty() ? "All" : "Some")).newline().newline().add("The following packages are not available:").beginList();
            for (UpdatablePackage updatablePackage : unavailableDownloads) {
                builder2.listItem().add(updatablePackage.getRepresentative().getDisplayName());
            }
            for (String string : unknownPaths) {
                builder2.listItem().add("Package id " + string);
            }
            builder2.endList().closeHtmlBody();
            Messages.showErrorDialog((String)builder2.getHtml(), (String)title);
        }
        if (resolvedPackages.isEmpty() && resolvedUninstalls.isEmpty()) {
            if (noOpMessage != null) {
                Messages.showErrorDialog((Project)project, (String)noOpMessage, (String)"SDK Manager");
            }
            return null;
        }
        List installRequests = ContainerUtil.map(resolvedPackages, UpdatablePackage::getRemote);
        ModelWizard.Builder wizardBuilder = new ModelWizard.Builder(new ModelWizardStep[0]);
        wizardBuilder.addStep(new LicenseAgreementStep(new LicenseAgreementModel(mgr.getLocalPath()), installRequests));
        InstallSelectedPackagesStep installStep = new InstallSelectedPackagesStep(resolvedPackages, resolvedUninstalls, sdkHandler, backgroundable);
        wizardBuilder.addStep(installStep);
        ModelWizard modelWizard = wizardBuilder.build();
        String title = "SDK Quickfix Installation";
        return new StudioWizardDialogBuilder(modelWizard, title, parent).setProject(project).setModalityType(DialogWrapper.IdeModalityType.IDE).setCancellationPolicy(ModelWizardDialog.CancellationPolicy.CAN_CANCEL_UNTIL_CAN_FINISH).build();
    }

    @NotNull
    private static Collection<UpdatablePackage> lookupPaths(Collection<String> requestedPaths2, RepositoryPackages packages, List<String> unknownPaths) {
        Map consolidated = packages.getConsolidatedPkgs();
        ArrayList<UpdatablePackage> result2 = new ArrayList<UpdatablePackage>();
        if (requestedPaths2 != null) {
            for (String path2 : requestedPaths2) {
                UpdatablePackage p = (UpdatablePackage)consolidated.get(path2);
                if (p == null || !p.hasRemote()) {
                    unknownPaths.add(path2);
                    continue;
                }
                result2.add(p);
            }
        }
        ArrayList<UpdatablePackage> arrayList = result2;
        if (arrayList == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static void verifyAvailability(List<UpdatablePackage> requestedPackages, List<UpdatablePackage> unavailableDownloads) {
        ListIterator<UpdatablePackage> iter = requestedPackages.listIterator();
        while (iter.hasNext()) {
            UpdatablePackage p = (UpdatablePackage)iter.next();
            if (p.hasRemote()) continue;
            iter.remove();
            unavailableDownloads.add(p);
        }
    }

    public static List<UpdatablePackage> resolve(@Nullable Collection<UpdatablePackage> requestedPackages, @NotNull RepositoryPackages packages) throws PackageResolutionException {
        if (packages == null) {
            SdkQuickfixUtils.$$$reportNull$$$0(7);
        }
        ArrayList<UpdatablePackage> result2 = new ArrayList<UpdatablePackage>();
        if (requestedPackages == null) {
            requestedPackages = new ArrayList<UpdatablePackage>();
        }
        ArrayList resolved = Lists.newArrayList(requestedPackages);
        ArrayList<RemotePackage> remotes = new ArrayList<RemotePackage>();
        for (UpdatablePackage p : resolved) {
            if (!p.hasRemote()) continue;
            remotes.add(p.getRemote());
        }
        final AtomicReference warning = new AtomicReference();
        ProgressIndicatorAdapter errorCollector = new ProgressIndicatorAdapter(){

            public void logWarning(@NotNull String s) {
                if (s == null) {
                    1.$$$reportNull$$$0(0);
                }
                warning.set(s);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils$1", "logWarning"));
            }
        };
        List requiredPackages = InstallerUtil.computeRequiredPackages(remotes, (RepositoryPackages)packages, (ProgressIndicator)errorCollector);
        if (requiredPackages == null) {
            throw new PackageResolutionException((String)warning.get());
        }
        Set requiredPaths = requiredPackages.stream().map(RepoPackage::getPath).collect(Collectors.toCollection(LinkedHashSet::new));
        Map allPackages = packages.getConsolidatedPkgs();
        for (String path2 : requiredPaths) {
            UpdatablePackage requiredPackage = (UpdatablePackage)allPackages.get(path2);
            if (requiredPackage == null) {
                throw new PackageResolutionException("Failed to find package with key " + path2);
            }
            result2.add(requiredPackage);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedPaths";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedPackages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninstallPackages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/wizard/SdkQuickfixUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDialogForPaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDialogForPackages";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PackageResolutionException
    extends Exception {
        public PackageResolutionException(String message2) {
            super(message2);
        }
    }
}

