/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractUninstaller;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatchUninstaller
extends AbstractUninstaller
implements PatchOperation {
    private LocalPackage myPatcher;
    private File myEmptyDir;
    private File myGeneratedPatch;

    public PatchUninstaller(@NotNull LocalPackage p, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (p == null) {
            PatchUninstaller.$$$reportNull$$$0(0);
        }
        if (mgr == null) {
            PatchUninstaller.$$$reportNull$$$0(1);
        }
        if (fop == null) {
            PatchUninstaller.$$$reportNull$$$0(2);
        }
        super(p, mgr, fop);
        this.myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
        this.myEmptyDir = FileOpUtils.getNewTempDir((String)"PatchUninstaller", (FileOp)this.mFop);
        this.registerStateChangeListener((op, progress) -> {
            if (this.getInstallStatus() == PackageOperation.InstallStatus.COMPLETE) {
                this.mFop.deleteFileOrFolder(this.getLocation(progress));
            }
        });
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            PatchUninstaller.$$$reportNull$$$0(3);
        }
        LocalPackage localPackage = this.myPatcher;
        if (localPackage == null) {
            PatchUninstaller.$$$reportNull$$$0(4);
        }
        return localPackage;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        File file2 = this.myEmptyDir;
        if (file2 == null) {
            PatchUninstaller.$$$reportNull$$$0(5);
        }
        return file2;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return "<None>";
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.getPackage();
    }

    protected boolean doPrepare(@Nullable File installTemp, ProgressIndicator progress) {
        if (this.myPatcher == null) {
            return false;
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTemp, this.mFop, progress);
        return this.myGeneratedPatch != null;
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (progress == null) {
            PatchUninstaller.$$$reportNull$$$0(6);
        }
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, this.mFop, progress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/install/patch/PatchUninstaller";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/install/patch/PatchUninstaller";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFilesRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPatcher";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doComplete";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

