/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileUtilKt;
import com.android.tools.idea.sdk.install.patch.FullInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.tools.idea.sdk.install.patch.PatchUninstaller;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerFactory
extends AbstractInstallerFactory {
    private static final String KNOWN_GOOD_VERSION = "patcher;v4";
    private static final long PSEUDO_PATCH_CUTOFF = 0x6400000L;
    private final PatchRunner.Factory myPatchRunnerFactory;

    public PatchInstallerFactory() {
        this(new PatchRunner.DefaultFactory());
    }

    @VisibleForTesting
    PatchInstallerFactory(@NotNull PatchRunner.Factory runnerFactory) {
        if (runnerFactory == null) {
            PatchInstallerFactory.$$$reportNull$$$0(0);
        }
        this.myPatchRunnerFactory = runnerFactory;
    }

    @NotNull
    protected Installer doCreateInstaller(@NotNull RemotePackage remote, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        LocalPackage local;
        if (remote == null) {
            PatchInstallerFactory.$$$reportNull$$$0(1);
        }
        if (mgr == null) {
            PatchInstallerFactory.$$$reportNull$$$0(2);
        }
        if (downloader == null) {
            PatchInstallerFactory.$$$reportNull$$$0(3);
        }
        if (fop == null) {
            PatchInstallerFactory.$$$reportNull$$$0(4);
        }
        if (PatchInstallerFactory.hasPatch(local = (LocalPackage)mgr.getPackages().getLocalPackages().get(remote.getPath()), remote)) {
            return new PatchInstaller(local, remote, downloader, mgr, fop);
        }
        return new FullInstaller(local, remote, mgr, downloader, fop);
    }

    private static boolean hasPatch(@Nullable LocalPackage local, @NotNull RemotePackage remote) {
        if (remote == null) {
            PatchInstallerFactory.$$$reportNull$$$0(5);
        }
        Archive archive = remote.getArchive();
        assert (archive != null);
        return local != null && archive.getPatch(local.getVersion()) != null;
    }

    @NotNull
    protected Uninstaller doCreateUninstaller(@NotNull LocalPackage local, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (local == null) {
            PatchInstallerFactory.$$$reportNull$$$0(6);
        }
        if (mgr == null) {
            PatchInstallerFactory.$$$reportNull$$$0(7);
        }
        if (fop == null) {
            PatchInstallerFactory.$$$reportNull$$$0(8);
        }
        return new PatchUninstaller(local, mgr, fop);
    }

    protected boolean canHandlePackage(@NotNull RepoPackage p, @NotNull RepoManager manager, @NotNull FileOp fop) {
        LocalPackage patcher;
        if (p == null) {
            PatchInstallerFactory.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            PatchInstallerFactory.$$$reportNull$$$0(10);
        }
        if (fop == null) {
            PatchInstallerFactory.$$$reportNull$$$0(11);
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        if (p instanceof LocalPackage) {
            if (fop.isWindows()) {
                try {
                    if (FileUtilKt.recursiveSize((Path)fop.toPath(((LocalPackage)p).getLocation())) >= 0x6400000L) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LocalPackage latestPatcher = PatchInstallerUtil.getLatestPatcher(manager);
                return latestPatcher != null && !latestPatcher.equals(p);
            }
            return false;
        }
        LocalPackage local = (LocalPackage)manager.getPackages().getLocalPackages().get(p.getPath());
        RemotePackage remote = (RemotePackage)p;
        if (local == null || !fop.isWindows() && !PatchInstallerFactory.hasPatch(local, remote)) {
            return false;
        }
        if (PatchInstallerFactory.hasPatch(local, remote)) {
            patcher = PatchInstallerUtil.getDependantPatcher((RemotePackage)p, manager);
            if (patcher != null && this.myPatchRunnerFactory.getPatchRunner(patcher, (ProgressIndicator)progress, fop) != null) {
                return true;
            }
            if (PatchInstallerUtil.getInProgressDependantPatcherInstall((RemotePackage)p, manager) != null) {
                return true;
            }
            if (!fop.isWindows()) {
                return false;
            }
        }
        if (((RemotePackage)p).getArchive().getComplete().getSize() >= 0x6400000L) {
            return false;
        }
        patcher = PatchInstallerUtil.getLatestPatcher(manager);
        return patcher != null && PatchInstallerUtil.comparePatcherPaths(patcher.getPath(), KNOWN_GOOD_VERSION) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerFactory";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateInstaller";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPatch";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doCreateUninstaller";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "canHandlePackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

