/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.SdkConstants;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.adb.AdbService;
import java.io.File;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class PlatformToolsInstallListener
implements PackageOperation.StatusChangeListener {
    private final AndroidSdkHandler mySdkHandler;

    public PlatformToolsInstallListener(AndroidSdkHandler sdkHandler) {
        this.mySdkHandler = sdkHandler;
    }

    private void stopAdb(ProgressIndicator progress) {
        AdbService adbService2 = AdbService.getInstance();
        progress.logInfo("Stopping ADB...");
        File adb = this.getAdb(progress);
        if (adb != null) {
            try {
                adbService2.getDebugBridge(adb).get();
            }
            catch (Exception e) {
                progress.logWarning("Failed to get ADB instance", (Throwable)e);
            }
        }
        try {
            adbService2.terminateDdmlib();
        }
        catch (TimeoutException e) {
            progress.logWarning("Failed to terminate running ADB instance", (Throwable)e);
        }
    }

    private File getAdb(@NotNull ProgressIndicator progress) {
        LocalPackage localPackage;
        if (progress == null) {
            PlatformToolsInstallListener.$$$reportNull$$$0(0);
        }
        if ((localPackage = this.mySdkHandler.getLocalPackage("platform-tools", progress)) != null) {
            return new File(localPackage.getLocation().getPath(), SdkConstants.FN_ADB);
        }
        return null;
    }

    public void statusChanged(PackageOperation installer, ProgressIndicator progress) {
        if (installer.getInstallStatus() == PackageOperation.InstallStatus.RUNNING) {
            this.stopAdb(progress);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/android/tools/idea/sdk/install/PlatformToolsInstallListener", "getAdb"));
    }
}

