/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IdeSdks {
    @NonNls
    public static final String MAC_JDK_CONTENT_PATH = "Contents/Home";
    @NonNls
    private static final String ANDROID_SDK_PATH_KEY = "android.sdk.path";
    @NotNull
    public static final JavaSdkVersion DEFAULT_JDK_VERSION = JavaSdkVersion.JDK_11;
    @NotNull
    public static final String JDK_LOCATION_ENV_VARIABLE_NAME = "STUDIO_GRADLE_JDK";
    private static final JavaSdkVersion MIN_JDK_VERSION = JavaSdkVersion.JDK_1_8;
    private static final JavaSdkVersion MAX_JDK_VERSION = JavaSdkVersion.JDK_11;
    @NotNull
    private static final Logger LOG = Logger.getInstance(IdeSdks.class);
    @NotNull
    private final AndroidSdks myAndroidSdks;
    @NotNull
    private final Jdks myJdks;
    @NotNull
    private final EmbeddedDistributionPaths myEmbeddedDistributionPaths;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Map<String, LocalPackage> localPackagesByPrefix;
    private final EnvVariableSettings myEnvVariableSettings;

    @NotNull
    public static IdeSdks getInstance() {
        IdeSdks ideSdks = (IdeSdks)ApplicationManager.getApplication().getService(IdeSdks.class);
        if (ideSdks == null) {
            IdeSdks.$$$reportNull$$$0(0);
        }
        return ideSdks;
    }

    public IdeSdks() {
        this(AndroidSdks.getInstance(), Jdks.getInstance(), EmbeddedDistributionPaths.getInstance(), IdeInfo.getInstance());
    }

    @NonInjectable
    @VisibleForTesting
    public IdeSdks(@NotNull AndroidSdks sdks, @NotNull Jdks jdks, @NotNull EmbeddedDistributionPaths embeddedDistributionPaths, @NotNull IdeInfo ideInfo) {
        if (sdks == null) {
            IdeSdks.$$$reportNull$$$0(1);
        }
        if (jdks == null) {
            IdeSdks.$$$reportNull$$$0(2);
        }
        if (embeddedDistributionPaths == null) {
            IdeSdks.$$$reportNull$$$0(3);
        }
        if (ideInfo == null) {
            IdeSdks.$$$reportNull$$$0(4);
        }
        this.localPackagesByPrefix = new HashMap<String, LocalPackage>();
        this.myEnvVariableSettings = new EnvVariableSettings();
        this.myAndroidSdks = sdks;
        this.myJdks = jdks;
        this.myEmbeddedDistributionPaths = embeddedDistributionPaths;
        this.myIdeInfo = ideInfo;
    }

    @Nullable
    public File getAndroidSdkPath() {
        File candidate;
        File candidate2;
        String sdkHome = null;
        Sdk sdk = this.getFirstAndroidSdk();
        if (sdk != null) {
            sdkHome = sdk.getHomePath();
        }
        if (sdkHome != null && this.isValidAndroidSdkPath(candidate2 = FilePaths.stringToFile((String)sdkHome))) {
            return candidate2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
        String sdkPath = component.getValue(ANDROID_SDK_PATH_KEY);
        if (sdkPath != null && this.isValidAndroidSdkPath(candidate = new File(sdkPath))) {
            return candidate;
        }
        return null;
    }

    @Nullable
    public LocalPackage getSpecificLocalPackage(@NotNull String prefix) {
        if (prefix == null) {
            IdeSdks.$$$reportNull$$$0(5);
        }
        if (this.localPackagesByPrefix.containsKey(prefix)) {
            return this.localPackagesByPrefix.get(prefix);
        }
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage result2 = sdkHandler.getLatestLocalPackageForPrefix(prefix, null, true, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (result2 != null) {
            this.setSpecificLocalPackage(prefix, result2);
        }
        return result2;
    }

    @VisibleForTesting
    public void setSpecificLocalPackage(@NotNull String prefix, @NotNull LocalPackage localPackage) {
        if (prefix == null) {
            IdeSdks.$$$reportNull$$$0(6);
        }
        if (localPackage == null) {
            IdeSdks.$$$reportNull$$$0(7);
        }
        this.localPackagesByPrefix.put(prefix, localPackage);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview) {
        return this.getHighestLocalNdkPackage(allowPreview, null);
    }

    @Nullable
    public LocalPackage getHighestLocalNdkPackage(boolean allowPreview, @Nullable Predicate<Revision> filter2) {
        AndroidSdkHandler sdkHandler = this.myAndroidSdks.tryToChooseSdkHandler();
        LocalPackage ndk = sdkHandler.getLatestLocalPackageForPrefix("ndk", filter2, allowPreview, (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (ndk != null) {
            return ndk;
        }
        LocalPackage ndkPackage = sdkHandler.getLocalPackage("ndk-bundle", (ProgressIndicator)new StudioLoggerProgressIndicator(IdeSdks.class));
        if (filter2 != null && ndkPackage != null && filter2.test(ndkPackage.getVersion())) {
            return ndkPackage;
        }
        return null;
    }

    @Nullable
    public File getAndroidNdkPath() {
        return this.getAndroidNdkPath(null);
    }

    @Nullable
    public File getAndroidNdkPath(@Nullable Predicate<Revision> filter2) {
        LocalPackage ndk = this.getHighestLocalNdkPackage(false, filter2);
        if (ndk != null) {
            return ndk.getLocation();
        }
        return null;
    }

    @Nullable
    public Path getJdkPath() {
        return this.doGetJdkPath(true);
    }

    @Nullable
    private Path doGetJdkPath(boolean createJdkIfNeeded) {
        if (this.isUsingEnvVariableJdk()) {
            return this.getEnvVariableJdkFile();
        }
        JavaSdkVersion sdkVersion = this.getRunningVersionOrDefault();
        Sdk jdk = this.getExistingJdk(sdkVersion);
        if (createJdkIfNeeded && (jdk == null || jdk.getHomePath() == null)) {
            jdk = this.createNewJdk(sdkVersion);
        }
        if (jdk != null && jdk.getHomePath() != null) {
            return Paths.get(jdk.getHomePath(), new String[0]);
        }
        return null;
    }

    public void cleanJdkEnvVariableInitialization() {
        this.myEnvVariableSettings.cleanInitialization();
    }

    public void overrideJdkEnvVariable(@Nullable String envVariableValue) {
        this.myEnvVariableSettings.overrideValue(envVariableValue);
    }

    public boolean isUsingEnvVariableJdk() {
        return this.myEnvVariableSettings.isUseJdkEnvVariable();
    }

    public boolean isJdkEnvVariableDefined() {
        return this.myEnvVariableSettings.isJdkEnvVariableDefined();
    }

    public boolean isJdkEnvVariableValid() {
        return this.myEnvVariableSettings.IsJdkEnvVariableValid();
    }

    @Nullable
    public Path getEnvVariableJdkFile() {
        return this.myEnvVariableSettings.getJdkFile();
    }

    @Nullable
    public String getEnvVariableJdkValue() {
        return this.myEnvVariableSettings.getVariableValue();
    }

    public boolean setUseEnvVariableJdk(boolean useJdkEnvVariable) {
        return this.myEnvVariableSettings.setUseJdkEnvVariable(useJdkEnvVariable);
    }

    @Nullable
    private Sdk getFirstAndroidSdk() {
        List<Sdk> allAndroidSdks = this.getEligibleAndroidSdks();
        if (!allAndroidSdks.isEmpty()) {
            return allAndroidSdks.get(0);
        }
        return null;
    }

    public Sdk setJdkPath(@NotNull Path path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(8);
        }
        if (JdkUtil.checkForJdk((Path)path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Path canonicalPath = IdeSdks.resolvePath(path2);
            Sdk chosenJdk = null;
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            if (this.isAndroidStudio()) {
                List jdks = projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance());
                for (Sdk jdk : jdks) {
                    projectJdkTable.removeJdk(jdk);
                }
            } else {
                for (Sdk jdk : projectJdkTable.getSdksOfType((SdkTypeId)JavaSdk.getInstance())) {
                    if (!FileUtil.pathsEqual((String)jdk.getHomePath(), (String)canonicalPath.toString())) continue;
                    chosenJdk = jdk;
                    break;
                }
            }
            if (chosenJdk == null) {
                if (Files.isDirectory(canonicalPath, new LinkOption[0])) {
                    chosenJdk = this.createJdk(canonicalPath);
                    if (chosenJdk == null) {
                        throw new IllegalStateException("Failed to create IDEA JDK from '" + path2 + "'");
                    }
                    this.setJdkOfAndroidSdks(chosenJdk);
                    for (Project project : ProjectUtil.getOpenProjects()) {
                        JavaSdkUtil.applyJdkToProject((Project)project, (Sdk)chosenJdk);
                    }
                } else {
                    throw new IllegalStateException("The resolved path '" + canonicalPath + "' was not found");
                }
            }
            this.setUseEnvVariableJdk(false);
            return chosenJdk;
        }
        return null;
    }

    private void setJdkOfAndroidSdks(@NotNull Sdk jdk) {
        if (jdk == null) {
            IdeSdks.$$$reportNull$$$0(9);
        }
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            AndroidSdkAdditionalData oldData = this.myAndroidSdks.getAndroidSdkAdditionalData(sdk);
            if (oldData == null) continue;
            oldData.setJavaSdk(jdk);
            SdkModificator modificator = sdk.getSdkModificator();
            modificator.setSdkAdditionalData((SdkAdditionalData)oldData);
            modificator.commitChanges();
        }
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Project currentProject) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(10);
        }
        List<Sdk> list = this.setAndroidSdkPath(path2, null, currentProject);
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<Sdk> setAndroidSdkPath(@NotNull File path2, @Nullable Sdk javaSdk, @Nullable Project currentProject) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(12);
        }
        if (this.isValidAndroidSdkPath(path2)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (currentProject != null && !currentProject.isDisposed()) {
                String sdkPath = FileUtil.toCanonicalPath((String)path2.getAbsolutePath());
                PropertiesComponent.getInstance((Project)currentProject).setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                if (!currentProject.isDefault()) {
                    PropertiesComponent component = PropertiesComponent.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
                    component.setValue(ANDROID_SDK_PATH_KEY, sdkPath);
                }
            }
            this.updateSdkData(path2);
            ArrayList<Sdk> sdksToDelete = new ArrayList<Sdk>();
            Path resolved = IdeSdks.resolvePath(path2.toPath());
            AndroidSdkData sdkData = AndroidSdkData.getSdkData(resolved.toFile(), true);
            if (sdkData != null) {
                for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
                    if (!sdk.getName().startsWith("Android ")) continue;
                    sdksToDelete.add(sdk);
                }
            }
            for (Sdk sdk : sdksToDelete) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
            List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(resolved.toFile(), javaSdk);
            IdeSdks.afterAndroidSdkPathUpdate(resolved.toFile());
            List<Sdk> list = sdks;
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<Sdk> list = Collections.emptyList();
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(14);
        }
        return list;
    }

    private void updateSdkData(@NotNull File path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(15);
        }
        AndroidSdkData oldSdkData = AndroidSdkData.getSdkData(path2);
        this.myAndroidSdks.setSdkData(oldSdkData);
    }

    public void updateFromAndroidSdkPath(@Nullable Project currentProject) {
        String sdkPath;
        File sdkDir = null;
        if (currentProject != null && !currentProject.isDisposed() && (sdkPath = PropertiesComponent.getInstance((Project)currentProject).getValue(ANDROID_SDK_PATH_KEY)) != null) {
            sdkDir = new File(sdkPath);
        }
        if (sdkDir == null) {
            sdkDir = this.getAndroidSdkPath();
        }
        assert (sdkDir != null);
        assert (this.isValidAndroidSdkPath(sdkDir));
        this.updateSdkData(sdkDir);
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            VirtualFile homeDir = sdk.getHomeDirectory();
            if (homeDir == null || !homeDir.exists()) {
                jdkTable.removeJdk(sdk);
                continue;
            }
            IAndroidTarget target = IdeSdks.getTarget(sdk);
            File targetFile = new File(target.getLocation());
            if (targetFile.exists()) continue;
            jdkTable.removeJdk(sdk);
        }
        Path resolved = IdeSdks.resolvePath(sdkDir.toPath());
        this.createAndroidSdkPerAndroidTarget(resolved.toFile());
    }

    private static void afterAndroidSdkPathUpdate(@NotNull File androidSdkPath) {
        Project[] openProjects;
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(16);
        }
        if ((openProjects = ProjectUtil.getOpenProjects()).length == 0) {
            return;
        }
        List eventListeners = AndroidSdkEventListener.EP_NAME.getExtensionList();
        for (Project project : openProjects) {
            if (!AndroidProjectInfo.getInstance(project).requiresAndroidModel()) continue;
            for (AndroidSdkEventListener listener2 : eventListeners) {
                listener2.afterSdkPathChange(androidSdkPath, project);
            }
        }
    }

    public boolean isValidAndroidSdkPath(@NotNull File path2) {
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(17);
        }
        return SdkPaths.validateAndroidSdk((File)path2, (boolean)false).success;
    }

    @NotNull
    public List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath) {
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(18);
        }
        List<Sdk> sdks = this.createAndroidSdkPerAndroidTarget(androidSdkPath, null);
        IdeSdks.updateWelcomeRunAndroidSdkAction();
        List<Sdk> list = sdks;
        if (list == null) {
            IdeSdks.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static void updateWelcomeRunAndroidSdkAction() {
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        AnAction sdkManagerAction = actionManager.getAction("WelcomeScreen.RunAndroidSdkManager");
        if (sdkManagerAction != null) {
            sdkManagerAction.update(AnActionEvent.createFromDataContext((String)"unknown", null, dataId -> null));
        }
    }

    @NotNull
    private List<Sdk> createAndroidSdkPerAndroidTarget(@NotNull File androidSdkPath, @Nullable Sdk javaSdk) {
        Sdk ideJdk;
        AndroidSdkData sdkData;
        if (androidSdkPath == null) {
            IdeSdks.$$$reportNull$$$0(20);
        }
        if ((sdkData = AndroidSdkData.getSdkData(androidSdkPath)) == null) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(21);
            }
            return list;
        }
        IAndroidTarget[] targets = sdkData.getTargets(false);
        if (targets.length == 0) {
            List<Sdk> list = Collections.emptyList();
            if (list == null) {
                IdeSdks.$$$reportNull$$$0(22);
            }
            return list;
        }
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        Sdk sdk = ideJdk = javaSdk != null ? javaSdk : this.getJdk();
        if (ideJdk != null) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform() || this.doesIdeAndroidSdkExist(target)) continue;
                String name = this.myAndroidSdks.chooseNameForNewLibrary(target);
                Sdk sdk2 = this.myAndroidSdks.create(target, sdkData.getLocation(), name, ideJdk, true);
                if (sdk2 == null) continue;
                sdks.add(sdk2);
            }
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private boolean doesIdeAndroidSdkExist(@NotNull IAndroidTarget target) {
        if (target == null) {
            IdeSdks.$$$reportNull$$$0(24);
        }
        for (Sdk sdk : this.getEligibleAndroidSdks()) {
            IAndroidTarget platformTarget = IdeSdks.getTarget(sdk);
            AndroidVersion version2 = target.getVersion();
            AndroidVersion existingVersion = platformTarget.getVersion();
            if (!existingVersion.equals((Object)version2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static IAndroidTarget getTarget(@NotNull Sdk sdk) {
        if (sdk == null) {
            IdeSdks.$$$reportNull$$$0(25);
        }
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance(sdk);
        assert (androidPlatform != null);
        IAndroidTarget iAndroidTarget = androidPlatform.getTarget();
        if (iAndroidTarget == null) {
            IdeSdks.$$$reportNull$$$0(26);
        }
        return iAndroidTarget;
    }

    @NotNull
    private static Path resolvePath(@NotNull Path path2) {
        Path path3;
        if (path2 == null) {
            IdeSdks.$$$reportNull$$$0(27);
        }
        try {
            String resolvedPath = FileUtil.resolveShortWindowsName((String)path2.toString());
            path3 = Paths.get(resolvedPath, new String[0]);
        }
        catch (IOException iOException) {
            Path path4 = path2;
            if (path4 == null) {
                IdeSdks.$$$reportNull$$$0(29);
            }
            return path4;
        }
        if (path3 == null) {
            IdeSdks.$$$reportNull$$$0(28);
        }
        return path3;
    }

    public boolean isUsingEmbeddedJdk() {
        if (!this.isAndroidStudio()) {
            return false;
        }
        Path jdkPath = this.doGetJdkPath(false);
        Path embeddedJdkPath = this.getEmbeddedJdkPath();
        return jdkPath != null && embeddedJdkPath != null && FileUtil.pathsEqual((String)jdkPath.toString(), (String)embeddedJdkPath.toString());
    }

    public void setUseEmbeddedJdk() {
        Preconditions.checkState((boolean)this.isAndroidStudio(), (Object)"This method is for use in Android Studio only.");
        Path embeddedJdkPath = this.getEmbeddedJdkPath();
        assert (embeddedJdkPath != null);
        this.setJdkPath(embeddedJdkPath);
    }

    @Nullable
    public Path getEmbeddedJdkPath() {
        if (!this.isAndroidStudio()) {
            return null;
        }
        return this.myEmbeddedDistributionPaths.getEmbeddedJdkPath();
    }

    public boolean isUsingJavaHomeJdk() {
        return this.isUsingJavaHomeJdk(ApplicationManager.getApplication().isUnitTestMode());
    }

    @VisibleForTesting
    boolean isUsingJavaHomeJdk(boolean assumeUnitTest) {
        if (!this.isAndroidStudio()) {
            return false;
        }
        Path jdkPath = assumeUnitTest ? this.doGetJdkPath(false) : this.getJdkPath();
        return IdeSdks.isSameAsJavaHomeJdk(jdkPath);
    }

    @VisibleForTesting
    boolean isAndroidStudio() {
        return this.myIdeInfo.isAndroidStudio();
    }

    public static boolean isSameAsJavaHomeJdk(@Nullable Path path2) {
        String javaHome = IdeSdks.getJdkFromJavaHome();
        return javaHome != null && FileUtil.pathsEqual((String)path2.toString(), (String)javaHome);
    }

    @Nullable
    public static String getJdkFromJavaHome() {
        String terminalValue = IdeSdks.doGetJdkFromPathOrParent(EnvironmentUtil.getValue((String)"JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)terminalValue)) {
            return terminalValue;
        }
        String envVariableValue = IdeSdks.doGetJdkFromPathOrParent(System.getenv("JAVA_HOME"));
        if (!Strings.isNullOrEmpty((String)envVariableValue)) {
            return envVariableValue;
        }
        return IdeSdks.doGetJdkFromPathOrParent(SystemProperties.getJavaHome());
    }

    @VisibleForTesting
    @Nullable
    static String doGetJdkFromPathOrParent(@Nullable String path2) {
        if (Strings.isNullOrEmpty((String)path2)) {
            return null;
        }
        Path pathFile = Paths.get(path2, new String[0]);
        String result2 = IdeSdks.doGetJdkFromPath(pathFile);
        if (result2 != null) {
            return result2;
        }
        Path parentFile = pathFile.getParent();
        if (parentFile != null) {
            return IdeSdks.doGetJdkFromPath(parentFile);
        }
        return null;
    }

    @Nullable
    private static String doGetJdkFromPath(@NotNull Path file2) {
        Path potentialPath;
        if (file2 == null) {
            IdeSdks.$$$reportNull$$$0(30);
        }
        if (JdkUtil.checkForJdk((Path)file2)) {
            return file2.toString();
        }
        if (SystemInfo.isMac && Files.isDirectory(potentialPath = file2.resolve(MAC_JDK_CONTENT_PATH), new LinkOption[0]) && JdkUtil.checkForJdk((Path)potentialPath)) {
            return potentialPath.toString();
        }
        return null;
    }

    @Nullable
    public Sdk getJdk() {
        if (this.myEnvVariableSettings.isUseJdkEnvVariable()) {
            return this.myEnvVariableSettings.getSdk();
        }
        return this.getJdk(this.getRunningVersionOrDefault());
    }

    @Nullable
    private Sdk getJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk existingJdk = this.getExistingJdk(preferredVersion);
        if (existingJdk != null) {
            return existingJdk;
        }
        return this.createNewJdk(preferredVersion);
    }

    @Nullable
    private Sdk getExistingJdk(@Nullable JavaSdkVersion preferredVersion) {
        List<Sdk> androidSdks = this.getEligibleAndroidSdks();
        if (!androidSdks.isEmpty()) {
            Sdk androidSdk = androidSdks.get(0);
            AndroidSdkAdditionalData data = this.myAndroidSdks.getAndroidSdkAdditionalData(androidSdk);
            assert (data != null);
            Sdk jdk = data.getJavaSdk();
            if (this.isJdkCompatible(jdk, preferredVersion)) {
                return jdk;
            }
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        if (!jdks.isEmpty()) {
            for (Sdk jdk : jdks) {
                if (!this.isJdkCompatible(jdk, preferredVersion)) continue;
                return jdk;
            }
        }
        return null;
    }

    @Nullable
    private Sdk createNewJdk(@Nullable JavaSdkVersion preferredVersion) {
        Sdk jdk;
        if (this.isAndroidStudio() && (jdk = this.myJdks.createEmbeddedJdk()) != null) {
            assert (this.isJdkCompatible(jdk, preferredVersion));
            return jdk;
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List jdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Set checkedJdkPaths = jdks.stream().map(Sdk::getHomePath).collect(Collectors.toSet());
        List<File> jdkPaths = IdeSdks.getPotentialJdkPaths();
        for (File jdkPath : jdkPaths) {
            Sdk jdk2;
            if (checkedJdkPaths.contains(jdkPath.getAbsolutePath())) continue;
            if (JdkUtil.checkForJdk((Path)jdkPath.toPath()) && this.isJdkCompatible(jdk2 = this.createJdk(jdkPath.toPath()), preferredVersion)) {
                return jdk2;
            }
            if (!SystemInfo.isLinux) continue;
            for (File child : FileUtil.notNullize((File[])jdkPath.listFiles())) {
                Sdk jdk3;
                if (!child.isDirectory() || !JdkUtil.checkForJdk((Path)child.toPath()) || !this.isJdkCompatible(jdk3 = this.myJdks.createJdk(child.getPath()), preferredVersion)) continue;
                return jdk3;
            }
        }
        return null;
    }

    @NotNull
    private static List<File> getPotentialJdkPaths() {
        JavaSdk javaSdk = JavaSdk.getInstance();
        ArrayList jdkPaths = Lists.newArrayList((Iterable)javaSdk.suggestHomePaths());
        jdkPaths.add(SystemProperties.getJavaHome());
        jdkPaths.add(0, System.getenv("JDK_HOME"));
        ArrayList virtualFiles = Lists.newArrayListWithCapacity((int)jdkPaths.size());
        for (String jdkPath : jdkPaths) {
            File javaHome;
            if (jdkPath == null || !(javaHome = new File(jdkPath)).isDirectory()) continue;
            virtualFiles.add(javaHome);
        }
        ArrayList arrayList = virtualFiles;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public boolean isJdkCompatible(@Nullable Sdk jdk) {
        return this.isJdkCompatible(jdk, MIN_JDK_VERSION);
    }

    @Contract(value="null, _ -> false")
    public boolean isJdkCompatible(@Nullable Sdk jdk, @Nullable JavaSdkVersion preferredVersion) {
        if (jdk == null) {
            return false;
        }
        if (!(jdk.getSdkType() instanceof JavaSdk)) {
            return false;
        }
        if (preferredVersion == null) {
            return true;
        }
        if (!JavaSdk.getInstance().isOfVersionOrHigher(jdk, JavaSdkVersion.JDK_1_8)) {
            return false;
        }
        JavaSdkVersion jdkVersion = JavaSdk.getInstance().getVersion(jdk);
        if (jdkVersion == null) {
            return false;
        }
        return this.isJdkVersionCompatible(preferredVersion, jdkVersion);
    }

    @VisibleForTesting
    boolean isJdkVersionCompatible(@NotNull JavaSdkVersion preferredVersion, @NotNull JavaSdkVersion jdkVersion) {
        if (preferredVersion == null) {
            IdeSdks.$$$reportNull$$$0(32);
        }
        if (jdkVersion == null) {
            IdeSdks.$$$reportNull$$$0(33);
        }
        return jdkVersion.compareTo((Enum)preferredVersion) >= 0 && jdkVersion.compareTo((Enum)MAX_JDK_VERSION) <= 0;
    }

    @NotNull
    public List<Sdk> getEligibleAndroidSdks() {
        ArrayList<Sdk> sdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.myAndroidSdks.getAllAndroidSdks()) {
            if (!sdk.getName().startsWith("Android ") || AndroidPlatform.getInstance(sdk) == null) continue;
            sdks.add(sdk);
        }
        ArrayList<Sdk> arrayList = sdks;
        if (arrayList == null) {
            IdeSdks.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public boolean hasConfiguredAndroidSdk() {
        return this.getAndroidSdkPath() != null;
    }

    @Nullable
    private Sdk createJdk(@NotNull Path homeDirectory) {
        if (homeDirectory == null) {
            IdeSdks.$$$reportNull$$$0(35);
        }
        return this.myJdks.createJdk(homeDirectory.toString());
    }

    public boolean isJdk7Supported(@Nullable AndroidSdkData sdkData) {
        if (sdkData != null) {
            Revision revision;
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(Jdks.class);
            LocalPackage info2 = sdkData.getSdkHandler().getLocalPackage("platform-tools", (ProgressIndicator)progress);
            if (info2 != null && (revision = info2.getVersion()).getMajor() >= 19) {
                JavaSdkVersion version2;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version2 = jdk.getVersion(sdk)) != null && version2.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    return true;
                }
            }
        }
        return false;
    }

    @TestOnly
    public static void removeJdksOn(@NotNull Disposable disposable2) {
        if (disposable2 == null) {
            IdeSdks.$$$reportNull$$$0(36);
        }
        if (disposable2 instanceof ProjectEx) {
            disposable2 = ((ProjectEx)disposable2).getEarlyDisposable();
        }
        Disposer.register((Disposable)disposable2, () -> WriteAction.run(() -> {
            for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
                ProjectJdkTable.getInstance().removeJdk(sdk);
            }
        }));
    }

    @Nullable
    public Path validateJdkPath(@NotNull Path file2) {
        Path macPath;
        if (file2 == null) {
            IdeSdks.$$$reportNull$$$0(37);
        }
        Path possiblePath = null;
        if (JdkUtil.checkForJdk((Path)file2)) {
            possiblePath = file2;
        } else if (SystemInfo.isMac && Files.isDirectory(macPath = file2.resolve(MAC_JDK_CONTENT_PATH), new LinkOption[0]) && JdkUtil.checkForJdk((Path)macPath)) {
            possiblePath = macPath;
        }
        if (possiblePath != null) {
            if (((Boolean)StudioFlags.ALLOW_DIFFERENT_JDK_VERSION.get()).booleanValue() || IdeSdks.isJdkSameVersion(possiblePath, this.getRunningVersionOrDefault())) {
                return possiblePath;
            }
            LOG.warn("Trying to use JDK with different version: " + possiblePath);
        } else {
            IdeSdks.showValidateDetails(file2);
            if (SystemInfo.isMac) {
                IdeSdks.showValidateDetails(file2.resolve(MAC_JDK_CONTENT_PATH));
            }
        }
        return null;
    }

    private static void showValidateDetails(@NotNull Path homePath) {
        if (homePath == null) {
            IdeSdks.$$$reportNull$$$0(38);
        }
        LOG.warn("Could not validate JDK at " + homePath + ":");
        LOG.warn("  File exists: " + Files.exists(homePath, new LinkOption[0]));
        LOG.warn("  Javac: " + (Files.isRegularFile(homePath.resolve("bin/javac"), new LinkOption[0]) || Files.isRegularFile(homePath.resolve("bin/javac.exe"), new LinkOption[0])));
        LOG.warn("  JDK: " + Files.exists(homePath.resolve("jre/lib/rt.jar"), new LinkOption[0]));
        LOG.warn("  JRE: " + Files.exists(homePath.resolve("lib/rt.jar"), new LinkOption[0]));
        LOG.warn("  Jigsaw JDK/JRE: " + JdkUtil.isModularRuntime((Path)homePath));
        LOG.warn("  Apple JDK: " + Files.exists(homePath.resolve("../Classes/classes.jar"), new LinkOption[0]));
        LOG.warn("  IBM JDK: " + Files.exists(homePath.resolve("jre/lib/vm.jar"), new LinkOption[0]));
        LOG.warn("  Custom build: " + Files.isDirectory(homePath.resolve("classes"), new LinkOption[0]));
    }

    @NotNull
    public JavaSdkVersion getRunningVersionOrDefault() {
        JavaSdkVersion currentlyRunning;
        String versionString = System.getProperty("java.version");
        if (versionString != null && (currentlyRunning = JavaSdkVersion.fromVersionString((String)versionString)) != null) {
            JavaSdkVersion javaSdkVersion = currentlyRunning;
            if (javaSdkVersion == null) {
                IdeSdks.$$$reportNull$$$0(39);
            }
            return javaSdkVersion;
        }
        JavaSdkVersion embeddedVersion = Jdks.getInstance().findVersion(this.myEmbeddedDistributionPaths.getEmbeddedJdkPath());
        JavaSdkVersion javaSdkVersion = embeddedVersion != null ? embeddedVersion : DEFAULT_JDK_VERSION;
        if (javaSdkVersion == null) {
            IdeSdks.$$$reportNull$$$0(40);
        }
        return javaSdkVersion;
    }

    @Contract(value="null, _ -> false")
    public static boolean isJdkSameVersion(@Nullable Path jdkLocation, @NotNull JavaSdkVersion expectedVersion) {
        if (expectedVersion == null) {
            IdeSdks.$$$reportNull$$$0(41);
        }
        if (jdkLocation == null) {
            return false;
        }
        JavaSdkVersion version2 = Jdks.getInstance().findVersion(jdkLocation);
        return version2 != null && version2.compareTo((Enum)expectedVersion) == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/IdeSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedDistributionPaths";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPackage";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredVersion";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkVersion";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homeDirectory";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/IdeSdks";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "setAndroidSdkPath";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndroidSdkPerAndroidTarget";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePath";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialJdkPaths";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEligibleAndroidSdks";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningVersionOrDefault";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificLocalPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSpecificLocalPackage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setJdkPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJdkOfAndroidSdks";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setAndroidSdkPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkData";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "afterAndroidSdkPathUpdate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isValidAndroidSdkPath";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidSdkPerAndroidTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doesIdeAndroidSdkExist";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolvePath";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doGetJdkFromPath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isJdkVersionCompatible";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createJdk";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeJdksOn";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "validateJdkPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showValidateDetails";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isJdkSameVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EnvVariableSettings {
        private Sdk mySdk;
        private String myVariableValue;
        private Path myJdkFile;
        private boolean myUseJdkEnvVariable;
        private boolean myInitialized;
        private final Object myInitializationLock = new Object();

        public EnvVariableSettings() {
            this.cleanInitialization();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanInitialization() {
            Object object = this.myInitializationLock;
            synchronized (object) {
                this.myVariableValue = null;
                this.myJdkFile = null;
                this.mySdk = null;
                this.myUseJdkEnvVariable = false;
                this.myInitialized = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize() {
            Object object = this.myInitializationLock;
            synchronized (object) {
                if (this.myInitialized) {
                    return;
                }
            }
            this.initialize(System.getenv(IdeSdks.JDK_LOCATION_ENV_VARIABLE_NAME));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialize(@Nullable String value2) {
            Path envVariableJdkFile;
            Object object = this.myInitializationLock;
            synchronized (object) {
                if (this.myInitialized) {
                    return;
                }
                if (value2 == null) {
                    this.setInitializationAsNotDefined();
                    return;
                }
                envVariableJdkFile = IdeSdks.this.validateJdkPath(Paths.get(FileUtil.toSystemDependentName((String)value2), new String[0]));
                if (envVariableJdkFile == null) {
                    this.setInitializationAsDefinedButInvalid(value2);
                    LOG.warn("The provided JDK path is invalid: " + value2);
                    return;
                }
            }
            Path finalEnvVariableJdkFile = envVariableJdkFile;
            Runnable createJdkTask = () -> {
                Object object = this.myInitializationLock;
                synchronized (object) {
                    if (!this.myInitialized) {
                        try {
                            @Nullable Sdk jdk = IdeSdks.this.createJdk(finalEnvVariableJdkFile);
                            if (jdk != null) {
                                this.setInitialization(value2, finalEnvVariableJdkFile, jdk);
                                LOG.info("Using Gradle JDK from STUDIO_GRADLE_JDK=" + value2);
                            } else {
                                this.setInitializationAsDefinedButInvalid(value2);
                                LOG.warn("Could not use provided jdk from " + value2);
                            }
                        }
                        catch (Throwable exc) {
                            this.setInitializationAsDefinedButInvalid(value2);
                            LOG.warn("Could not use provided jdk from " + value2, exc);
                        }
                    }
                }
            };
            Application application = ApplicationManager.getApplication();
            boolean onReadAction = application.isReadAccessAllowed();
            boolean hasWriteIntendLock = application.isWriteThread();
            if (onReadAction && !hasWriteIntendLock) {
                application.invokeLater(createJdkTask);
                throw new AssertionError((Object)"Cannot create JDK from a read action without write intend");
            }
            application.invokeAndWait(createJdkTask);
        }

        private void setInitializationAsNotDefined() {
            this.setInitialization(null, null, null);
        }

        private void setInitializationAsDefinedButInvalid(@NotNull String envVariableValue) {
            if (envVariableValue == null) {
                EnvVariableSettings.$$$reportNull$$$0(0);
            }
            this.setInitialization(envVariableValue, null, null);
        }

        private void setInitialization(@Nullable String variableValue2, @Nullable Path jdkFile, @Nullable Sdk sdk) {
            this.myVariableValue = variableValue2;
            this.myJdkFile = jdkFile;
            this.mySdk = sdk;
            this.myUseJdkEnvVariable = variableValue2 != null && jdkFile != null && sdk != null;
            this.myInitialized = true;
        }

        public boolean isUseJdkEnvVariable() {
            this.initialize();
            return this.myUseJdkEnvVariable;
        }

        boolean isJdkEnvVariableDefined() {
            this.initialize();
            return this.myVariableValue != null;
        }

        public boolean IsJdkEnvVariableValid() {
            this.initialize();
            return this.mySdk != null;
        }

        public Path getJdkFile() {
            this.initialize();
            return this.myJdkFile;
        }

        public Sdk getSdk() {
            this.initialize();
            return this.mySdk;
        }

        public String getVariableValue() {
            this.initialize();
            return this.myVariableValue;
        }

        public boolean setUseJdkEnvVariable(boolean use2) {
            this.initialize();
            if (!this.IsJdkEnvVariableValid()) {
                return false;
            }
            this.myUseJdkEnvVariable = use2;
            return true;
        }

        public void overrideValue(@Nullable String value2) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                Object object = this.myInitializationLock;
                synchronized (object) {
                    this.myInitialized = false;
                    this.initialize(value2);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVariableValue", "com/android/tools/idea/sdk/IdeSdks$EnvVariableSettings", "setInitializationAsDefinedButInvalid"));
        }
    }

    public static interface AndroidSdkEventListener {
        public static final ExtensionPointName<AndroidSdkEventListener> EP_NAME = ExtensionPointName.create((String)"com.android.ide.sdkEventListener");

        public void afterSdkPathChange(@NotNull File var1, @NotNull Project var2);
    }
}

