/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.base.Strings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessHandlerLaunchStatus
implements LaunchStatus {
    @NotNull
    private ProcessHandler myProcessHandler;
    private boolean myTerminated;
    private final List<BooleanSupplier> launchTerminationConditions;

    public ProcessHandlerLaunchStatus(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ProcessHandlerLaunchStatus.$$$reportNull$$$0(0);
        }
        this.launchTerminationConditions = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProcessHandler = processHandler;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            ProcessHandlerLaunchStatus.$$$reportNull$$$0(1);
        }
        return processHandler;
    }

    public void setProcessHandler(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ProcessHandlerLaunchStatus.$$$reportNull$$$0(2);
        }
        this.myProcessHandler = processHandler;
    }

    @Override
    public boolean isLaunchTerminated() {
        if (this.myTerminated) {
            return true;
        }
        if (this.launchTerminationConditions.stream().anyMatch(condition -> !condition.getAsBoolean())) {
            return false;
        }
        return this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating();
    }

    @Override
    public void addLaunchTerminationCondition(BooleanSupplier launchTerminatedCondition) {
        this.launchTerminationConditions.add(launchTerminatedCondition);
    }

    @Override
    public void terminateLaunch(@Nullable String errorMessage, boolean destroyProcess) {
        this.myTerminated = true;
        if (!Strings.isNullOrEmpty((String)errorMessage)) {
            this.myProcessHandler.notifyTextAvailable(errorMessage + "\n", ProcessOutputTypes.STDERR);
        }
        if (destroyProcess) {
            this.myProcessHandler.destroyProcess();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/util/ProcessHandlerLaunchStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/util/ProcessHandlerLaunchStatus";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

