/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.util;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.utils.XmlUtils;
import com.intellij.execution.Executor;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LaunchUtils {
    private static final Pattern idKeyPattern = Pattern.compile("--user\\s+([0-9]+)");

    public static boolean canDebugAppOnDevice(@NotNull AndroidFacet facet2, @NotNull IDevice device) {
        if (facet2 == null) {
            LaunchUtils.$$$reportNull$$$0(0);
        }
        if (device == null) {
            LaunchUtils.$$$reportNull$$$0(1);
        }
        return LaunchUtils.canDebugApp(facet2) || LaunchUtils.isDebuggableDevice(device);
    }

    public static boolean canDebugApp(@NotNull AndroidFacet facet2) {
        Boolean isDebuggable;
        if (facet2 == null) {
            LaunchUtils.$$$reportNull$$$0(2);
        }
        return (isDebuggable = AndroidModuleInfo.getInstance(facet2).isDebuggable()) == null || isDebuggable != false;
    }

    public static boolean isDebuggableDevice(@NotNull IDevice device) {
        String buildType;
        if (device == null) {
            LaunchUtils.$$$reportNull$$$0(3);
        }
        return "userdebug".equals(buildType = device.getProperty("ro.build.type")) || "eng".equals(buildType);
    }

    public static boolean isWatchFaceApp(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            LaunchUtils.$$$reportNull$$$0(4);
        }
        if (AndroidFacet.getInstance((Module)facet2.getModule()) == null) {
            Logger.getInstance(LaunchUtils.class).warn("calling isWatchFaceApp when facet is not ready yet");
            return false;
        }
        MergedManifestSnapshot info2 = MergedManifestManager.getSnapshot(facet2);
        List<DefaultActivityLocator.ActivityWrapper> activities = DefaultActivityLocator.ActivityWrapper.get(info2.getActivities(), info2.getActivityAliases());
        boolean foundExportedActivity = activities.stream().anyMatch(activity -> activity.isLogicallyExported());
        if (foundExportedActivity) {
            return false;
        }
        List<Element> services = info2.getServices();
        if (services.size() != 1) {
            return false;
        }
        Element service = services.get(0);
        Element subTag = XmlUtils.getFirstSubTag((Node)service);
        while (subTag != null) {
            if (ActivityLocatorUtils.containsAction(subTag, "android.service.wallpaper.WallpaperService") && ActivityLocatorUtils.containsCategory(subTag, "com.google.android.wearable.watchface.category.WATCH_FACE")) {
                return true;
            }
            subTag = XmlUtils.getNextTag((Node)subTag);
        }
        return false;
    }

    public static boolean isWatchFeatureRequired(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            LaunchUtils.$$$reportNull$$$0(5);
        }
        if (!AndroidManifestIndex.indexEnabled().booleanValue()) {
            return LaunchUtils.isWatchFeatureRequiredFromSnapshot(facet2);
        }
        Project project = facet2.getModule().getProject();
        Collection usedFeatures = (Collection)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> AndroidManifestIndexQueryUtils.queryUsedFeaturesFromManifestIndex(facet2));
        return usedFeatures.stream().anyMatch(feature -> "android.hardware.type.watch".equals(feature.getName()) && (feature.getRequired() == null || "true".equals(feature.getRequired())));
    }

    private static boolean isWatchFeatureRequiredFromSnapshot(@NotNull AndroidFacet facet2) {
        MergedManifestSnapshot mergedManifest;
        Element feature;
        if (facet2 == null) {
            LaunchUtils.$$$reportNull$$$0(6);
        }
        if ((feature = (mergedManifest = MergedManifestManager.getSnapshot(facet2)).findUsedFeature("android.hardware.type.watch")) == null) {
            return false;
        }
        Attr requiredNode = feature.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "required");
        if (requiredNode == null) {
            return true;
        }
        return "true".equals(requiredNode.getValue());
    }

    public static void showNotification(final @NotNull Project project, final @NotNull Executor executor, final @NotNull String sessionName, final @NotNull String message2, final @NotNull NotificationType type, final @Nullable NotificationListener errorNotificationListener) {
        if (project == null) {
            LaunchUtils.$$$reportNull$$$0(7);
        }
        if (executor == null) {
            LaunchUtils.$$$reportNull$$$0(8);
        }
        if (sessionName == null) {
            LaunchUtils.$$$reportNull$$$0(9);
        }
        if (message2 == null) {
            LaunchUtils.$$$reportNull$$$0(10);
        }
        if (type == null) {
            LaunchUtils.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                String toolWindowId = executor.getToolWindowId();
                final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolWindowId);
                if (toolWindow.isVisible() && errorNotificationListener == null) {
                    return;
                }
                final String link = "toolWindow_" + sessionName;
                String notificationMessage = String.format("Session <a href='%s'>'%s'</a>: %s", link, sessionName, message2);
                this.getNotificationGroup(toolWindowId).createNotification(notificationMessage, type).setListener(new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        boolean handled = false;
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && link.equals(event.getDescription())) {
                            for (RunContentDescriptor d : ExecutionManagerImpl.getAllDescriptors((Project)project)) {
                                if (!sessionName.equals(d.getDisplayName())) continue;
                                Content content2 = d.getAttachedContent();
                                if (content2 != null) {
                                    content2.getManager().setSelectedContent(content2);
                                }
                                toolWindow.activate(null, true, true);
                                handled = true;
                                break;
                            }
                        }
                        if (!handled && errorNotificationListener != null) {
                            errorNotificationListener.hyperlinkUpdate(notification, event);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/android/tools/idea/run/util/LaunchUtils$1$1";
                        objectArray[2] = "hyperlinkUpdate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).notify(project);
            }

            @NotNull
            private NotificationGroup getNotificationGroup(@NotNull String toolWindowId) {
                String displayId;
                NotificationGroup group2;
                if (toolWindowId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((group2 = NotificationGroup.findRegisteredGroup((String)(displayId = "Launch Notifications for " + toolWindowId))) == null) {
                    group2 = NotificationGroup.toolWindowGroup((String)displayId, (String)toolWindowId, (boolean)true, (PluginId)PluginId.getId((String)"org.jetbrains.android"));
                }
                NotificationGroup notificationGroup = group2;
                if (notificationGroup == null) {
                    1.$$$reportNull$$$0(1);
                }
                return notificationGroup;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "toolWindowId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/run/util/LaunchUtils$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/run/util/LaunchUtils$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNotificationGroup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getNotificationGroup";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public static void initiateDismissKeyguard(final @NotNull IDevice device) {
        AndroidVersion canDismissKeyguard;
        if (device == null) {
            LaunchUtils.$$$reportNull$$$0(12);
        }
        if ((canDismissKeyguard = new AndroidVersion(23, null)).compareTo(device.getVersion()) <= 0) {
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        device.executeShellCommand("wm dismiss-keyguard", (IShellOutputReceiver)new NullOutputReceiver(), 10L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        Logger.getInstance(LaunchUtils.class).warn("Unable to dismiss keyguard before launching activity");
                    }
                }
            });
        }
    }

    @Nullable
    public static Integer getUserIdFromFlags(@Nullable String flags) {
        if (flags == null) {
            return null;
        }
        Matcher m = idKeyPattern.matcher(flags);
        return m.find() ? Integer.valueOf(Integer.parseInt(m.group(1))) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/util/LaunchUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDebugAppOnDevice";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canDebugApp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDebuggableDevice";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWatchFaceApp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isWatchFeatureRequired";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isWatchFeatureRequiredFromSnapshot";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "initiateDismissKeyguard";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

