/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.tools.idea.gradle.util.GradleBuilds;
import com.android.tools.idea.util.CommonAndroidUtil;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeployAction
extends AnAction {
    @NotNull
    private final String myId;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final String myEnabledText;
    @NotNull
    private final String myEnabledDescription;

    protected DeployAction(@NotNull String id, @NotNull Executor executor, @NotNull String text2, @NotNull String description2) {
        if (id == null) {
            DeployAction.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            DeployAction.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            DeployAction.$$$reportNull$$$0(2);
        }
        if (description2 == null) {
            DeployAction.$$$reportNull$$$0(3);
        }
        super(text2, description2, null);
        this.myId = id;
        this.myExecutor = executor;
        this.myEnabledText = text2;
        this.myEnabledDescription = description2;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeployAction.$$$reportNull$$$0(4);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            DeployAction.disableAction(presentation, "Lack of Project", "Disabled due to lack of project");
            return;
        }
        if (!CommonAndroidUtil.getInstance().isAndroidProject(project)) {
            DeployAction.disableAction(presentation, "Not an Android Project", "Disabled since this Project is not an Android project.");
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(true);
        presentation.setText(this.myEnabledText);
        presentation.setDescription(this.myEnabledDescription);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DeployAction.$$$reportNull$$$0(5);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (selectedConfiguration == null) {
            return;
        }
        RunConfiguration runConfiguration = selectedConfiguration.getConfiguration();
        DeployAction.rerun(project, this.myExecutor, runConfiguration, selectedConfiguration, e.getDataContext());
    }

    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            DeployAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void disableAction(@NotNull Presentation presentation, @NotNull String text2, @NotNull String description2) {
        if (presentation == null) {
            DeployAction.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            DeployAction.$$$reportNull$$$0(8);
        }
        if (description2 == null) {
            DeployAction.$$$reportNull$$$0(9);
        }
        presentation.setVisible(false);
        presentation.setEnabled(false);
        presentation.setText(text2);
        presentation.setDescription(description2);
    }

    private static void rerun(@NotNull Project project, @NotNull Executor executor, @Nullable RunConfiguration configuration, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
        if (project == null) {
            DeployAction.$$$reportNull$$$0(10);
        }
        if (executor == null) {
            DeployAction.$$$reportNull$$$0(11);
        }
        if (dataContext == null) {
            DeployAction.$$$reportNull$$$0(12);
        }
        if (configuration instanceof CompoundRunConfiguration) {
            RunManager runManager = RunManager.getInstance((Project)project);
            for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets()) {
                RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                DeployAction.rerun(project, executor, subConfiguration, runManager.findSettings(subConfiguration), dataContext);
            }
        } else {
            ExecutionEnvironmentBuilder builder2;
            ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = settings == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
            if (builder2 == null) {
                return;
            }
            ExecutionEnvironment env = builder2.activeTarget().dataContext(dataContext).build();
            env.putUserData(GradleBuilds.BUILD_SHOULD_EXECUTE, (Object)false);
            ExecutionManager.getInstance((Project)project).restartRunProfile(env);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/ui/DeployAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/ui/DeployAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "disableAction";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "rerun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class DebugWithoutBuildAction
    extends DeployAction {
        public static final String ID = "android.deploy.DebugWithoutBuild";

        public DebugWithoutBuildAction() {
            super(ID, DefaultDebugExecutor.getDebugExecutorInstance(), "Debug Without Build", "Deploys and debugs the application without building.");
        }
    }

    public static final class RunWithoutBuildAction
    extends DeployAction {
        public static final String ID = "android.deploy.RunWithoutBuild";

        public RunWithoutBuildAction() {
            super(ID, DefaultRunExecutor.getRunExecutorInstance(), "Run Without Build", "Deploys and runs the application without building.");
        }
    }
}

