/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.ui;

import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.SwapInfo;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.update.RunningApplicationUpdater;
import com.intellij.execution.update.RunningApplicationUpdaterProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyChangesAction
extends BaseAction {
    public static final String ID = "android.deploy.ApplyChanges";
    public static final String DISPLAY_NAME = "Apply Changes and Restart Activity";
    public static final String ACCELERATOR_NAME = "&Apply Changes and Restart Activity";
    private static final String DESC = "Attempt to apply resource and code changes and restart activity.";

    public ApplyChangesAction() {
        super(DISPLAY_NAME, ACCELERATOR_NAME, SwapInfo.SwapType.APPLY_CHANGES, StudioIcons.Shell.Toolbar.APPLY_ALL_CHANGES, DESC);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ApplyChangesAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        BaseAction.DisableMessage message2 = ApplyChangesAction.disableForTestProject(e.getProject());
        if (message2 != null) {
            this.disableAction(e.getPresentation(), message2);
        }
    }

    private static BaseAction.DisableMessage disableForTestProject(Project project) {
        if (project == null) {
            return null;
        }
        RunnerAndConfigurationSettings runConfig = RunManager.getInstance((Project)project).getSelectedConfiguration();
        if (runConfig != null) {
            ConfigurationType type = runConfig.getType();
            String id = type.getId();
            if (AndroidBuildCommonUtils.isTestConfiguration((String)id) || AndroidBuildCommonUtils.isInstrumentationTestConfiguration((String)id)) {
                return new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "test project", "the selected configuration is a test configuration");
            }
            ProcessHandler handler2 = ApplyChangesAction.findRunningProcessHandler(project, runConfig.getConfiguration());
            if (handler2 != null && ApplyChangesAction.getExecutor(handler2, DefaultRunExecutor.getRunExecutorInstance()) == DefaultDebugExecutor.getDebugExecutorInstance()) {
                return new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "debug execution", "it is currently not allowed during debugging");
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/run/ui/ApplyChangesAction", "update"));
    }

    public static class UpdaterProvider
    implements RunningApplicationUpdaterProvider {
        @Nullable
        public RunningApplicationUpdater createUpdater(@NotNull Project project, @NotNull ProcessHandler process) {
            if (project == null) {
                UpdaterProvider.$$$reportNull$$$0(0);
            }
            if (process == null) {
                UpdaterProvider.$$$reportNull$$$0(1);
            }
            if (BaseAction.getDisableMessage(project) != null || ApplyChangesAction.disableForTestProject(project) != null) {
                return null;
            }
            return new RunningApplicationUpdater(){

                public String getDescription() {
                    return ApplyChangesAction.DISPLAY_NAME;
                }

                public String getShortName() {
                    return ApplyChangesAction.DISPLAY_NAME;
                }

                public Icon getIcon() {
                    return StudioIcons.Shell.Toolbar.APPLY_ALL_CHANGES;
                }

                public void performUpdate(AnActionEvent event) {
                    new ApplyChangesAction().actionPerformed(event);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "process";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/run/ui/ApplyChangesAction$UpdaterProvider";
            objectArray[2] = "createUpdater";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

