/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.ApplicationTerminator;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KillAndRestartAppLaunchTask
implements LaunchTask {
    private static final String ID = "KILL_APPLICATION";
    private final String myPackageName;

    public KillAndRestartAppLaunchTask(@NotNull String packageName) {
        if (packageName == null) {
            KillAndRestartAppLaunchTask.$$$reportNull$$$0(0);
        }
        this.myPackageName = packageName;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Killing application";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean shouldRun(@NotNull LaunchContext launchContext) {
        if (launchContext == null) {
            KillAndRestartAppLaunchTask.$$$reportNull$$$0(1);
        }
        return launchContext.getKillBeforeLaunch();
    }

    @Override
    public LaunchResult run(@NotNull LaunchContext launchContext) {
        boolean terminateApp;
        if (launchContext == null) {
            KillAndRestartAppLaunchTask.$$$reportNull$$$0(2);
        }
        ProcessHandler handler2 = launchContext.getProcessHandler();
        IDevice device = launchContext.getDevice();
        if (handler2 instanceof AndroidProcessHandler) {
            AndroidProcessHandler androidHandler = (AndroidProcessHandler)launchContext.getProcessHandler();
            terminateApp = !androidHandler.killClientAndRestartMonitor(device);
        } else {
            handler2.destroyProcess();
            terminateApp = true;
        }
        if (!terminateApp) {
            return LaunchResult.success();
        }
        ApplicationTerminator appTerminator = new ApplicationTerminator(device, this.myPackageName);
        if (!appTerminator.killApp(launchContext.getLaunchStatus())) {
            return LaunchResult.error("", "trying to terminate app prior to restarting.");
        }
        if (!device.isOnline() || !(handler2 instanceof AndroidProcessHandler)) {
            LaunchResult result2 = new LaunchResult();
            result2.setSuccess(false);
            result2.setErrorId("");
            result2.setError("Swap failed, need to rerun.");
            result2.setConsoleError("Swap failed, need to rerun.");
            result2.addOnFinishedCallback(() -> {
                String id;
                ActionManager manager = ActionManager.getInstance();
                if (DefaultRunExecutor.getRunExecutorInstance().getId().equals(launchContext.getExecutor().getId())) {
                    id = "android.deploy.RunWithoutBuild";
                } else if (DefaultDebugExecutor.getDebugExecutorInstance().getId().equals(launchContext.getExecutor().getId())) {
                    id = "android.deploy.DebugWithoutBuild";
                } else {
                    return;
                }
                AnAction action2 = manager.getAction(id);
                if (action2 == null) {
                    return;
                }
                Project project = launchContext.getProject();
                JComponent contextComponent = new JComponent(){};
                contextComponent.setVisible(true);
                contextComponent.setEnabled(true);
                contextComponent.addNotify();
                DataManager.registerDataProvider((JComponent)contextComponent, (DataProvider)new RerunDataProvider(project));
                manager.tryToExecute(action2, ActionCommand.getInputEvent((String)id), (Component)contextComponent, "unknown", true);
            });
            return result2;
        }
        ((AndroidProcessHandler)launchContext.getProcessHandler()).addTargetDevice(device);
        return LaunchResult.success();
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchContext";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/tasks/KillAndRestartAppLaunchTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RerunDataProvider
    implements DataProvider {
        private final Project myProject;

        private RerunDataProvider(@NotNull Project project) {
            if (project == null) {
                RerunDataProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                RerunDataProvider.$$$reportNull$$$0(1);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myProject;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/run/tasks/KillAndRestartAppLaunchTask$RerunDataProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

