/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.testartifacts.instrumented.testsuite.api.AndroidTestSuiteConstantsKt;
import com.google.common.base.Preconditions;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ConnectJavaDebuggerTask
extends ConnectDebuggerTask {
    public ConnectJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean attachToRunningProcess) {
        if (applicationIds == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(0);
        }
        if (debugger == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(2);
        }
        super(applicationIds, debugger, project, attachToRunningProcess);
    }

    @Override
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        RunProfile runProfile;
        RunContentDescriptor debugDescriptor;
        AndroidDebugState debugState;
        if (currentLaunchInfo == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(3);
        }
        if (client == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(6);
        }
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        final int pid = client.getClientData().getPid();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format(Locale.US, "Attempting to connect debugger to port %1$s [client %2$d]", debugPort, pid));
        ProcessHandler processHandler = launchStatus.getProcessHandler();
        RunContentDescriptor descriptor2 = ((AndroidSessionInfo)Preconditions.checkNotNull((Object)((AndroidSessionInfo)processHandler.getUserData(AndroidSessionInfo.KEY)))).getDescriptor();
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        final AndroidRemoteDebugProcessHandler debugProcessHandler = new AndroidRemoteDebugProcessHandler(this.myProject);
        launchStatus.setProcessHandler(debugProcessHandler);
        printer.setProcessHandler(debugProcessHandler);
        processHandler.detachProcess();
        Object androidTestResultListener = processHandler.getCopyableUserData(AndroidTestSuiteConstantsKt.ANDROID_TEST_RESULT_LISTENER_KEY);
        if (androidTestResultListener instanceof ConsoleView) {
            ConsoleView consoleViewToReuse = (ConsoleView)androidTestResultListener;
            debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, (parent, handler2, executor) -> {
                consoleViewToReuse.attachToProcess(handler2);
                return consoleViewToReuse;
            });
        } else {
            debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, currentLaunchInfo.consoleProvider);
        }
        try {
            ExecutionEnvironment debugEnv = new ExecutionEnvironmentBuilder(currentLaunchInfo.env).executor(currentLaunchInfo.executor).runner(currentLaunchInfo.runner).contentToReuse(descriptor2).build();
            debugDescriptor = DebuggerPanelsManager.getInstance((Project)this.myProject).attachVirtualMachine(debugEnv, (RunProfileState)debugState, connection, false);
        }
        catch (ExecutionException e) {
            processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + ".", ProcessOutputTypes.STDERR);
            return null;
        }
        if (debugDescriptor == null) {
            processHandler.notifyTextAvailable("Unable to connect debugger to Android application", ProcessOutputTypes.STDERR);
            return null;
        }
        AndroidProcessText oldText = AndroidProcessText.get(processHandler);
        if (oldText != null) {
            oldText.printTo(debugProcessHandler);
        }
        RunConfiguration runConfiguration = (runProfile = currentLaunchInfo.env.getRunProfile()) instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
        AndroidSessionInfo.create(debugProcessHandler, debugDescriptor, runConfiguration, currentLaunchInfo.executor.getId(), currentLaunchInfo.executor.getActionName(), currentLaunchInfo.env.getExecutionTarget());
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT, client);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, client.getDevice().getVersion());
        final String pkgName = client.getClientData().getClientDescription();
        final IDevice device = client.getDevice();
        ConnectJavaDebuggerTask.captureLogcatOutput(client, debugProcessHandler);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private int myTerminationCount = 0;
            private boolean myWillBeDestroyed = true;

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processWillTerminate: " + pkgName + ", willBeDestroyed=" + willBeDestroyed);
                this.myWillBeDestroyed = willBeDestroyed;
                this.processTerminationCallback();
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processTerminated: " + pkgName);
                this.processTerminationCallback();
            }

            private void processTerminationCallback() {
                ++this.myTerminationCount;
                if (this.myTerminationCount != 2) {
                    return;
                }
                debugProcessHandler.removeProcessListener((ProcessListener)this);
                Client currentClient = device.getClient(pkgName);
                if (currentClient != null && currentClient.getClientData().getPid() != pid) {
                    return;
                }
                if (this.myWillBeDestroyed) {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger terminating, so terminating process: " + pkgName);
                    ProgressManager.getInstance().run((Task)new Task.Backgroundable(ConnectJavaDebuggerTask.this.myProject, "Stopping Application..."){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            try {
                                device.executeShellCommand("am force-stop " + pkgName, (IShellOutputReceiver)new NullOutputReceiver());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$1$1", "run"));
                        }
                    });
                } else {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger detaching, leaving process alive: " + pkgName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return debugProcessHandler;
    }

    private static void captureLogcatOutput(@NotNull Client client, @NotNull ProcessHandler debugProcessHandler) {
        if (client == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(7);
        }
        if (debugProcessHandler == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(8);
        }
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isDebugOutputEnabled()) {
            return;
        }
        final IDevice device = client.getDevice();
        final MyLogcatListener logListener = new MyLogcatListener(client, debugProcessHandler);
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\")", device.getName()));
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\"): remove listener", device.getName()));
                AndroidLogcatService.getInstance().removeListener(device, logListener);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$2", "processTerminated"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLaunchInfo";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcessHandler";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "launchDebugger";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "captureLogcatOutput";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyLogcatListener
    extends ApplicationLogListener {
        private static final String SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
        private final AndroidLogcatFormatter myFormatter;
        private final AtomicBoolean myIsFirstMessage;
        private final ProcessHandler myDebugProcessHandler;

        private MyLogcatListener(@NotNull Client client, @NotNull ProcessHandler debugProcessHandler) {
            if (client == null) {
                MyLogcatListener.$$$reportNull$$$0(0);
            }
            if (debugProcessHandler == null) {
                MyLogcatListener.$$$reportNull$$$0(1);
            }
            super(client.getClientData().getClientDescription(), client.getClientData().getPid());
            this.myFormatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
            this.myIsFirstMessage = new AtomicBoolean(true);
            this.myDebugProcessHandler = debugProcessHandler;
        }

        @Override
        @NotNull
        protected String formatLogLine(@NotNull LogCatMessage line2) {
            if (line2 == null) {
                MyLogcatListener.$$$reportNull$$$0(2);
            }
            String string = this.myFormatter.formatMessage(SIMPLE_FORMAT, line2.getHeader(), line2.getMessage());
            if (string == null) {
                MyLogcatListener.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        protected void notifyTextAvailable(@NotNull String message2, @NotNull Key key) {
            if (message2 == null) {
                MyLogcatListener.$$$reportNull$$$0(4);
            }
            if (key == null) {
                MyLogcatListener.$$$reportNull$$$0(5);
            }
            if (this.myIsFirstMessage.compareAndSet(true, false)) {
                this.myDebugProcessHandler.notifyTextAvailable("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
            }
            this.myDebugProcessHandler.notifyTextAvailable(message2, key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "client";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugProcessHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$MyLogcatListener";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$MyLogcatListener";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatLogLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "formatLogLine";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "notifyTextAvailable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

