/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectDebuggerTask
implements DebugConnectorTask {
    private static final int POLL_TIMEOUT = 15;
    private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
    @NotNull
    protected final Set<String> myApplicationIds;
    @NotNull
    protected final AndroidDebugger myDebugger;
    @NotNull
    protected final Project myProject;
    protected final boolean myAttachToRunningProcess;

    protected ConnectDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        if (applicationIds == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(0);
        }
        if (debugger == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(2);
        }
        this(applicationIds, debugger, project, monitorRemoteProcess, false);
    }

    protected ConnectDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess, boolean attachToRunningProcess) {
        if (applicationIds == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(3);
        }
        if (debugger == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(5);
        }
        this.myApplicationIds = applicationIds;
        this.myDebugger = debugger;
        this.myProject = project;
        this.myAttachToRunningProcess = attachToRunningProcess;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Connecting Debugger";
    }

    @Override
    public int getDuration() {
        return 10;
    }

    @Override
    public ProcessHandler perform(@NotNull LaunchInfo launchInfo, @NotNull IDevice device, @NotNull ProcessHandlerLaunchStatus state, @NotNull ProcessHandlerConsolePrinter printer) {
        Client client;
        if (launchInfo == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(6);
        }
        if (device == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(7);
        }
        if (state == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(8);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(9);
        }
        if ((client = this.waitForClient(device, state, printer)) == null) {
            return null;
        }
        return (ProcessHandler)UIUtil.invokeAndWaitIfNeeded(() -> this.launchDebugger(launchInfo, client, state, printer));
    }

    @Nullable
    protected Client waitForClient(@NotNull IDevice device, @NotNull LaunchStatus state, @NotNull ConsolePrinter printer) {
        if (device == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(10);
        }
        if (state == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(11);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(12);
        }
        for (int i2 = 0; i2 < 15; ++i2) {
            if (state.isLaunchTerminated()) {
                return null;
            }
            if (!device.isOnline()) {
                printer.stderr("Device is offline");
                return null;
            }
            block6: for (String name : this.myApplicationIds) {
                List<Client> clients = DeploymentApplicationService.getInstance().findClient(device, name);
                if (clients.isEmpty()) {
                    printer.stdout("Waiting for application to come online: " + Joiner.on((String)" | ").join(this.myApplicationIds));
                    continue;
                }
                printer.stdout("Connecting to " + name);
                if (clients.size() > 1) {
                    Logger.getInstance(ConnectDebuggerTask.class).info("Multiple clients with same application ID: " + name);
                }
                Client client = clients.get(0);
                ClientData.DebuggerStatus status = client.getClientData().getDebuggerConnectionStatus();
                switch (status) {
                    case ERROR: {
                        String message2 = String.format(Locale.US, "Debug port (%1$d) is busy, make sure there is no other active debug connection to the same application", client.getDebuggerListenPort());
                        printer.stderr(message2);
                        return null;
                    }
                    case ATTACHED: {
                        printer.stderr("A debugger is already attached");
                        return null;
                    }
                    case WAITING: {
                        if (!this.isReadyForDebugging(client, printer)) continue block6;
                        return client;
                    }
                }
                if (this.myAttachToRunningProcess && this.isReadyForDebugging(client, printer)) {
                    return client;
                }
                printer.stderr("Waiting for application to start debug server");
            }
            this.sleep(1L, POLL_TIMEUNIT);
        }
        printer.stderr("Could not connect to remote process. Aborting debug session.");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    protected void sleep(long sleepFor, @NotNull TimeUnit timeUnit) {
        void unit;
        if (timeUnit == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(13);
        }
        Uninterruptibles.sleepUninterruptibly((long)sleepFor, (TimeUnit)unit);
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        if (client == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(14);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(15);
        }
        return true;
    }

    @Nullable
    public abstract ProcessHandler launchDebugger(@NotNull LaunchInfo var1, @NotNull Client var2, @NotNull ProcessHandlerLaunchStatus var3, @NotNull ProcessHandlerConsolePrinter var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchInfo";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectDebuggerTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForClient";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "sleep";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isReadyForDebugging";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

