/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidDeepLinkLaunchTask
extends AppLaunchTask {
    private static final String ID = "LAUNCH_DEEP_LINK";
    @NotNull
    private final String myDeepLink;
    @NotNull
    StartActivityFlagsProvider myStartActivityFlagsProvider;

    public AndroidDeepLinkLaunchTask(@NotNull String deepLink, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        if (deepLink == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(0);
        }
        if (startActivityFlagsProvider == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(1);
        }
        this.myDeepLink = deepLink;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching URL";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public LaunchResult run(@NotNull LaunchContext launchContext) {
        if (launchContext == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(2);
        }
        ConsolePrinter printer = launchContext.getConsolePrinter();
        IDevice device = launchContext.getDevice();
        LaunchStatus launchStatus = launchContext.getLaunchStatus();
        printer.stdout("Launching deeplink: " + this.myDeepLink + ".\n");
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_DEEP_LINK_LAUNCHED));
        ShellCommandLauncher.execute("setprop log.tag.AppIndexApi VERBOSE", device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        String command = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myStartActivityFlagsProvider.getFlags(device));
        boolean successful = ShellCommandLauncher.execute(command, device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        return successful ? LaunchResult.success() : LaunchResult.error("", this.getDescription());
    }

    @Override
    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @NotNull String extraFlags) {
        if (deepLink == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(3);
        }
        if (extraFlags == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(4);
        }
        String string = "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + AndroidDeepLinkLaunchTask.singleQuoteShell(deepLink) + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
        if (string == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String singleQuoteShell(@NotNull String literal) {
        if (literal == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(6);
        }
        String string = "'" + literal.replace("'", "'\\''") + "'";
        if (string == null) {
            AndroidDeepLinkLaunchTask.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startActivityFlagsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraFlags";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/AndroidDeepLinkLaunchTask";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchDeepLinkCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "singleQuoteShell";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchDeepLinkCommand";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "singleQuoteShell";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

