/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.AndroidActivityLauncher;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ActivityLaunchTask
extends AppLaunchTask {
    @VisibleForTesting
    static final String ACTIVITY_DOES_NOT_EXIST = "ACTIVITY_DOES_NOT_EXIST";
    @VisibleForTesting
    static final String UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY = "UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY";
    @VisibleForTesting
    static final String UNKNOWN_ACTIVITY_LAUNCH_TASK_ERROR = "UNKNOWN_ACTIVITY_LAUNCH_TASK_ERROR";
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final StartActivityFlagsProvider myStartActivityFlagsProvider;

    public ActivityLaunchTask(@NotNull String applicationId2, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        if (applicationId2 == null) {
            ActivityLaunchTask.$$$reportNull$$$0(0);
        }
        if (startActivityFlagsProvider == null) {
            ActivityLaunchTask.$$$reportNull$$$0(1);
        }
        this.myApplicationId = applicationId2;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching activity";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public LaunchResult run(@NotNull LaunchContext launchContext) {
        if (launchContext == null) {
            ActivityLaunchTask.$$$reportNull$$$0(2);
        }
        LaunchStatus launchStatus = launchContext.getLaunchStatus();
        ConsolePrinter printer = launchContext.getConsolePrinter();
        IDevice device = launchContext.getDevice();
        String command = this.getStartActivityCommand(device, launchStatus, printer);
        if (command == null) {
            return LaunchResult.error(UNABLE_TO_DETERMINE_LAUNCH_ACTIVITY, this.getDescription());
        }
        ErrorAwarePrinterWrapper printerWrapper = new ErrorAwarePrinterWrapper(printer);
        boolean successful = this.executeShellCommand(command, device, launchStatus, printerWrapper, 15L, TimeUnit.SECONDS);
        if (printerWrapper.sawActivityDoesNotExistError()) {
            return LaunchResult.error(ACTIVITY_DOES_NOT_EXIST, this.getDescription());
        }
        return successful ? LaunchResult.success() : LaunchResult.error(UNKNOWN_ACTIVITY_LAUNCH_TASK_ERROR, this.getDescription());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean executeShellCommand(@NotNull String command, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer, long timeout, @NotNull TimeUnit timeUnit) {
        void timeoutUnit;
        if (command == null) {
            ActivityLaunchTask.$$$reportNull$$$0(3);
        }
        if (device == null) {
            ActivityLaunchTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            ActivityLaunchTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            ActivityLaunchTask.$$$reportNull$$$0(6);
        }
        if (timeUnit == null) {
            ActivityLaunchTask.$$$reportNull$$$0(7);
        }
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, timeout, (TimeUnit)timeoutUnit);
    }

    @VisibleForTesting
    @Nullable
    public String getStartActivityCommand(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        String activityName;
        if (device == null) {
            ActivityLaunchTask.$$$reportNull$$$0(8);
        }
        if (launchStatus == null) {
            ActivityLaunchTask.$$$reportNull$$$0(9);
        }
        if (printer == null) {
            ActivityLaunchTask.$$$reportNull$$$0(10);
        }
        if ((activityName = this.getQualifiedActivityName(device, printer)) == null) {
            return null;
        }
        String activityPath = AndroidActivityLauncher.getLauncherActivityPath(this.myApplicationId, activityName);
        return AndroidActivityLauncher.getStartActivityCommand(activityPath, this.myStartActivityFlagsProvider.getFlags(device));
    }

    @Nullable
    protected abstract String getQualifiedActivityName(@NotNull IDevice var1, @NotNull ConsolePrinter var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startActivityFlagsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeoutUnit";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/tasks/ActivityLaunchTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "executeShellCommand";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getStartActivityCommand";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ErrorAwarePrinterWrapper
    implements ConsolePrinter {
        private static final String ACTIVITY_DOES_NOT_EXIST_REGEX = "Activity class \\{[^}]*} does not exist";
        private static final Pattern activityDoesNotExistPattern = Pattern.compile("Activity class \\{[^}]*} does not exist");
        private final ConsolePrinter delegate;
        private boolean sawActivityDoesNotExist;

        ErrorAwarePrinterWrapper(ConsolePrinter delegate2) {
            this.delegate = delegate2;
        }

        boolean sawActivityDoesNotExistError() {
            return this.sawActivityDoesNotExist;
        }

        @Override
        public void stdout(@NotNull String message2) {
            if (message2 == null) {
                ErrorAwarePrinterWrapper.$$$reportNull$$$0(0);
            }
            this.delegate.stdout(message2);
        }

        @Override
        public void stderr(@NotNull String message2) {
            if (message2 == null) {
                ErrorAwarePrinterWrapper.$$$reportNull$$$0(1);
            }
            this.delegate.stderr(message2);
            if (activityDoesNotExistPattern.matcher(message2).find()) {
                this.sawActivityDoesNotExist = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "message";
            objectArray2[1] = "com/android/tools/idea/run/tasks/ActivityLaunchTask$ErrorAwarePrinterWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stdout";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stderr";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

