/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.profiler;

import com.android.utils.HashCodes;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CpuProfilerConfig {
    public static final int DEFAULT_BUFFER_SIZE_MB = 8;
    @NotNull
    private String myName;
    @NotNull
    private Technology myTechnology;
    private int mySamplingIntervalUs;
    private int myBufferSizeMb;
    private boolean myDisableLiveAllocation;

    public CpuProfilerConfig() {
        this.mySamplingIntervalUs = 1000;
        this.myBufferSizeMb = 8;
        this.myDisableLiveAllocation = true;
        this.myName = Technology.SAMPLED_JAVA.getName();
        this.myTechnology = Technology.SAMPLED_JAVA;
    }

    public CpuProfilerConfig(@NotNull String name, @NotNull Technology technology) {
        if (name == null) {
            CpuProfilerConfig.$$$reportNull$$$0(0);
        }
        if (technology == null) {
            CpuProfilerConfig.$$$reportNull$$$0(1);
        }
        this.mySamplingIntervalUs = 1000;
        this.myBufferSizeMb = 8;
        this.myDisableLiveAllocation = true;
        this.myName = name;
        this.myTechnology = technology;
    }

    CpuProfilerConfig(@NotNull Technology technology) {
        if (technology == null) {
            CpuProfilerConfig.$$$reportNull$$$0(2);
        }
        this(technology.getName(), technology);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            CpuProfilerConfig.$$$reportNull$$$0(3);
        }
        return string;
    }

    public CpuProfilerConfig setName(@NotNull String name) {
        if (name == null) {
            CpuProfilerConfig.$$$reportNull$$$0(4);
        }
        this.myName = name;
        return this;
    }

    @NotNull
    public Technology getTechnology() {
        Technology technology = this.myTechnology;
        if (technology == null) {
            CpuProfilerConfig.$$$reportNull$$$0(5);
        }
        return technology;
    }

    @NotNull
    public CpuProfilerConfig setTechnology(@NotNull Technology technology) {
        if (technology == null) {
            CpuProfilerConfig.$$$reportNull$$$0(6);
        }
        this.myTechnology = technology;
        CpuProfilerConfig cpuProfilerConfig = this;
        if (cpuProfilerConfig == null) {
            CpuProfilerConfig.$$$reportNull$$$0(7);
        }
        return cpuProfilerConfig;
    }

    public int getSamplingIntervalUs() {
        return this.mySamplingIntervalUs;
    }

    @NotNull
    public CpuProfilerConfig setSamplingIntervalUs(int samplingIntervalUs) {
        this.mySamplingIntervalUs = samplingIntervalUs;
        CpuProfilerConfig cpuProfilerConfig = this;
        if (cpuProfilerConfig == null) {
            CpuProfilerConfig.$$$reportNull$$$0(8);
        }
        return cpuProfilerConfig;
    }

    public int getBufferSizeMb() {
        return this.myBufferSizeMb;
    }

    @NotNull
    public CpuProfilerConfig setBufferSizeMb(int bufferSize) {
        this.myBufferSizeMb = bufferSize;
        CpuProfilerConfig cpuProfilerConfig = this;
        if (cpuProfilerConfig == null) {
            CpuProfilerConfig.$$$reportNull$$$0(9);
        }
        return cpuProfilerConfig;
    }

    public boolean isDisableLiveAllocation() {
        return this.myDisableLiveAllocation;
    }

    @NotNull
    public CpuProfilerConfig setDisableLiveAllocation(boolean disableLiveAllocation) {
        this.myDisableLiveAllocation = disableLiveAllocation;
        CpuProfilerConfig cpuProfilerConfig = this;
        if (cpuProfilerConfig == null) {
            CpuProfilerConfig.$$$reportNull$$$0(10);
        }
        return cpuProfilerConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CpuProfilerConfig config = (CpuProfilerConfig)o;
        return this.mySamplingIntervalUs == config.mySamplingIntervalUs && this.myBufferSizeMb == config.myBufferSizeMb && Objects.equals(this.myName, config.myName) && this.myTechnology == config.myTechnology && this.myDisableLiveAllocation == config.myDisableLiveAllocation;
    }

    public int hashCode() {
        return HashCodes.mix((int)this.myName.hashCode(), (int)this.myTechnology.hashCode(), (int)this.mySamplingIntervalUs, (int)this.myBufferSizeMb, (int)Boolean.hashCode(this.myDisableLiveAllocation));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "technology";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/profiler/CpuProfilerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/profiler/CpuProfilerConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTechnology";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setTechnology";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setSamplingIntervalUs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setBufferSizeMb";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setDisableLiveAllocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTechnology";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Technology {
        SAMPLED_JAVA{

            @Override
            @NotNull
            public String getName() {
                return "Sample Java Methods";
            }
        }
        ,
        INSTRUMENTED_JAVA{

            @Override
            @NotNull
            public String getName() {
                return "Trace Java Methods";
            }
        }
        ,
        SAMPLED_NATIVE{

            @Override
            @NotNull
            public String getName() {
                return "Sample C/C++ Functions";
            }
        }
        ,
        SYSTEM_TRACE{

            @Override
            @NotNull
            public String getName() {
                return "Trace System Calls";
            }
        };


        @NotNull
        public abstract String getName();
    }
}

