/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.SelectedRadioButtonProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.editor.AndroidTestExtraParamsDialog;
import com.android.tools.idea.testartifacts.instrumented.AndroidInheritingClassBrowser;
import com.android.tools.idea.testartifacts.instrumented.AndroidInheritingClassVisibilityChecker;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestClassBrowser;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestClassVisibilityChecker;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.MethodListDlg;
import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestRunParameters
implements ConfigurationSpecificEditor<AndroidTestRunConfiguration> {
    private JRadioButton myAllInPackageTestButton;
    private JRadioButton myClassTestButton;
    private JRadioButton myMethodTestButton;
    private JRadioButton myAllInModuleTestButton;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myTestPackageComponent;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myTestClassComponent;
    private LabeledComponent<SimpleEditorTextFieldWithBrowseButton> myTestMethodComponent;
    private JPanel myContentPanel;
    private LabeledComponent<EditorTextFieldWithBrowseButton> myInstrumentationClassComponent;
    private JBLabel myLabelTest;
    private LabeledComponent<SimpleEditorTextFieldWithBrowseButton> myInstrumentationArgsComponent;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private final boolean isBuildWithGradle;
    private final ContentWrapper myContentWrapper;
    private final BindingsManager myBindingsManager;
    private final SelectedRadioButtonProperty<Integer> mySelectedTestType;
    private final TextProperty myTestPackage;
    private final TextProperty myTestClass;
    private final TextProperty myTestMethod;
    private final TextProperty myInstrumentationClass;
    private final TextProperty myInstrumentationArgs;
    private boolean myIncludeGradleExtraParams = true;
    private String myUserModifiedInstrumentationExtraParams = "";

    public TestRunParameters(Project project, ConfigurationModuleSelector moduleSelector) {
        this.myProject = project;
        this.myModuleSelector = moduleSelector;
        this.$$$setupUI$$$();
        this.isBuildWithGradle = GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle();
        this.myBindingsManager = new BindingsManager();
        this.mySelectedTestType = new SelectedRadioButtonProperty<Integer>(0, new Integer[]{0, 1, 2, 3}, this.myAllInModuleTestButton, this.myAllInPackageTestButton, this.myClassTestButton, this.myMethodTestButton);
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestPackageComponent), this.mySelectedTestType.isEqualTo(1));
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestClassComponent), BooleanExpressions.any(this.mySelectedTestType.isEqualTo(2), this.mySelectedTestType.isEqualTo(3)));
        this.myBindingsManager.bind(new VisibleProperty((JComponent)this.myTestMethodComponent), this.mySelectedTestType.isEqualTo(3));
        EditorTextFieldWithBrowseButton testPackageEditorText = new EditorTextFieldWithBrowseButton(project, false);
        new BrowseModuleValueActionListener<EditorTextField>(this.myProject){

            protected String showDialog() {
                Module module2 = TestRunParameters.this.myModuleSelector.getModule();
                if (module2 == null) {
                    Messages.showErrorDialog((Component)TestRunParameters.this.myContentPanel, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]));
                    return null;
                }
                PackageChooserDialog dialog2 = new PackageChooserDialog(ExecutionBundle.message((String)"choose.package.dialog.title", (Object[])new Object[0]), module2);
                dialog2.selectPackage(((EditorTextFieldWithBrowseButton)TestRunParameters.this.myTestPackageComponent.getComponent()).getText());
                dialog2.show();
                PsiPackage aPackage = dialog2.getSelectedPackage();
                return aPackage != null ? aPackage.getQualifiedName() : null;
            }
        }.setField((ComponentWithBrowseButton)testPackageEditorText);
        this.myTestPackage = new TextProperty((EditorTextField)testPackageEditorText.getChildComponent());
        this.myTestPackageComponent.setComponent((JComponent)testPackageEditorText);
        EditorTextFieldWithBrowseButton testClassEditorText = new EditorTextFieldWithBrowseButton(project, true, (JavaCodeFragment.VisibilityChecker)new AndroidTestClassVisibilityChecker(moduleSelector));
        new AndroidTestClassBrowser(project, moduleSelector, AndroidBundle.message("android.browse.test.class.dialog.title", new Object[0]), false).setField((ComponentWithBrowseButton)testClassEditorText);
        this.myTestClass = new TextProperty((EditorTextField)testClassEditorText.getChildComponent());
        this.myTestClassComponent.setComponent((JComponent)testClassEditorText);
        SimpleEditorTextFieldWithBrowseButton testMethodEditorText = new SimpleEditorTextFieldWithBrowseButton();
        new BrowseModuleValueActionListener<EditorTextField>(this.myProject){

            protected String showDialog() {
                PsiMethod method2;
                String className2 = ((EditorTextFieldWithBrowseButton)TestRunParameters.this.myTestClassComponent.getComponent()).getText();
                if (className2.trim().isEmpty()) {
                    Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"set.class.name.message", (Object[])new Object[0]), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                    return null;
                }
                PsiClass testClass = TestRunParameters.this.myModuleSelector.findClass(className2);
                if (testClass == null) {
                    Messages.showMessageDialog((Component)this.getField(), (String)ExecutionBundle.message((String)"class.does.not.exists.error.message", (Object[])new Object[]{className2}), (String)ExecutionBundle.message((String)"cannot.browse.method.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                    return null;
                }
                MethodListDlg dialog2 = new MethodListDlg(testClass, (Condition)new JUnitUtil.TestMethodFilter(testClass), this.getField());
                if (dialog2.showAndGet() && (method2 = dialog2.getSelected()) != null) {
                    return method2.getName();
                }
                return null;
            }
        }.setField((ComponentWithBrowseButton)testMethodEditorText);
        this.myTestMethod = new TextProperty((EditorTextField)testMethodEditorText.getChildComponent());
        this.myTestMethodComponent.setComponent((JComponent)((Object)testMethodEditorText));
        EditorTextFieldWithBrowseButton instrClassEditorText = new EditorTextFieldWithBrowseButton(project, true, (JavaCodeFragment.VisibilityChecker)new AndroidInheritingClassVisibilityChecker(this.myProject, moduleSelector, "android.app.Instrumentation"));
        new AndroidInheritingClassBrowser(project, moduleSelector, "android.app.Instrumentation", AndroidBundle.message("android.browse.instrumentation.class.dialog.title", new Object[0]), true).setField((ComponentWithBrowseButton)instrClassEditorText);
        instrClassEditorText.setEnabled(!this.isBuildWithGradle);
        this.myInstrumentationClass = new TextProperty((EditorTextField)instrClassEditorText.getChildComponent());
        this.myInstrumentationClassComponent.setComponent((JComponent)instrClassEditorText);
        SimpleEditorTextFieldWithBrowseButton instrArgsTextField = new SimpleEditorTextFieldWithBrowseButton();
        new BrowseModuleValueActionListener<EditorTextField>(this.myProject){

            @Nullable
            protected String showDialog() {
                Module module2 = TestRunParameters.this.myModuleSelector.getModule();
                if (module2 == null) {
                    Messages.showErrorDialog((Component)TestRunParameters.this.myContentPanel, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]));
                    return null;
                }
                AndroidTestExtraParamsDialog dialog2 = new AndroidTestExtraParamsDialog(this.getProject(), AndroidFacet.getInstance((Module)module2), TestRunParameters.this.myInstrumentationArgs.get(), TestRunParameters.this.myIncludeGradleExtraParams);
                if (dialog2.showAndGet()) {
                    TestRunParameters.this.myIncludeGradleExtraParams = dialog2.getIncludeGradleExtraParams();
                    TestRunParameters.this.myUserModifiedInstrumentationExtraParams = dialog2.getUserModifiedInstrumentationExtraParams();
                    TestRunParameters.this.myInstrumentationArgs.set(dialog2.getInstrumentationExtraParams());
                    TestRunParameters.this.myContentWrapper.fireStateChanged();
                }
                return null;
            }
        }.setField((ComponentWithBrowseButton)instrArgsTextField);
        ((EditorTextField)instrArgsTextField.getChildComponent()).setEnabled(false);
        this.myInstrumentationArgs = new TextProperty((EditorTextField)instrArgsTextField.getChildComponent());
        this.myInstrumentationArgsComponent.setComponent((JComponent)((Object)instrArgsTextField));
        this.myContentWrapper = new ContentWrapper();
        this.myContentWrapper.add(this.myContentPanel);
    }

    @Override
    public void applyTo(AndroidTestRunConfiguration configuration) {
        configuration.TESTING_TYPE = this.mySelectedTestType.get();
        configuration.PACKAGE_NAME = this.myTestPackage.get();
        configuration.CLASS_NAME = this.myTestClass.get();
        configuration.METHOD_NAME = this.myTestMethod.get();
        configuration.INSTRUMENTATION_RUNNER_CLASS = this.isBuildWithGradle ? "" : this.myInstrumentationClass.get();
        configuration.EXTRA_OPTIONS = this.myUserModifiedInstrumentationExtraParams;
        configuration.INCLUDE_GRADLE_EXTRA_OPTIONS = this.myIncludeGradleExtraParams;
    }

    @Override
    public void resetFrom(AndroidTestRunConfiguration configuration) {
        AndroidFacet androidFacet = Optional.ofNullable(this.myModuleSelector.getModule()).map(AndroidFacet::getInstance).orElse(null);
        this.mySelectedTestType.set(configuration.TESTING_TYPE);
        this.myTestPackage.set(configuration.PACKAGE_NAME);
        this.myTestClass.set(configuration.CLASS_NAME);
        this.myTestMethod.set(configuration.METHOD_NAME);
        this.myInstrumentationClass.set(this.isBuildWithGradle ? AndroidTestRunConfiguration.getDefaultInstrumentationRunner(androidFacet) : configuration.INSTRUMENTATION_RUNNER_CLASS);
        this.myInstrumentationArgs.set(configuration.getExtraInstrumentationOptions(androidFacet));
        this.myIncludeGradleExtraParams = configuration.INCLUDE_GRADLE_EXTRA_OPTIONS;
    }

    @Override
    public Component getComponent() {
        return this.myContentWrapper;
    }

    public void dispose() {
        this.myBindingsManager.releaseAll();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        LabeledComponent labeledComponent5;
        JRadioButton jRadioButton;
        JBLabel jBLabel;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myAllInPackageTestButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("jnit.configuration.all.tests.in.package.radio"));
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.all.in.package.radio"));
        jPanel.add((Component)jRadioButton4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myClassTestButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.class.radio"));
        ((Component)jRadioButton3).setEnabled(true);
        jRadioButton3.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.class.radio"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMethodTestButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setActionCommand(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.method.radio"));
        jRadioButton2.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.method.radio"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelTest = jBLabel = new JBLabel();
        jBLabel.setHorizontalAlignment(2);
        jBLabel.setHorizontalTextPosition(2);
        jBLabel.setIconTextGap(4);
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/ExecutionBundle", TestRunParameters.class).getString("junit.configuration.configure.junit.test.label"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 5, 1, 1, 0, 1, 7, 1, null, null, null));
        this.myAllInModuleTestButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.all.in.module.radio"));
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestPackageComponent = labeledComponent5 = new LabeledComponent();
        labeledComponent5.setComponentClass("javax.swing.JPanel");
        labeledComponent5.setLabelLocation("West");
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.package.label"));
        jPanel.add((Component)labeledComponent5, new GridConstraints(1, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myTestClassComponent = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setComponentClass("javax.swing.JPanel");
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.class.label"));
        jPanel.add((Component)labeledComponent4, new GridConstraints(2, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myTestMethodComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("javax.swing.JPanel");
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.run.configuration.method.label"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(3, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myInstrumentationClassComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("javax.swing.JPanel");
        labeledComponent2.setEnabled(true);
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/AndroidBundle", TestRunParameters.class).getString("android.test.run.configuration.instrumentation.label"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(4, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        this.myInstrumentationArgsComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("javax.swing.JPanel");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Instrumentation arguments");
        jPanel.add((Component)labeledComponent, new GridConstraints(5, 0, 1, 6, 0, 1, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class SimpleEditorTextFieldWithBrowseButton
    extends ComponentWithBrowseButton<EditorTextField>
    implements TextAccessor {
        SimpleEditorTextFieldWithBrowseButton() {
            super((JComponent)new EditorTextField(), null);
        }

        public void setText(String text2) {
            ((EditorTextField)this.getChildComponent()).setText(StringUtil.notNullize((String)text2));
        }

        @NotNull
        public String getText() {
            String string = ((EditorTextField)this.getChildComponent()).getText();
            if (string == null) {
                SimpleEditorTextFieldWithBrowseButton.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/TestRunParameters$SimpleEditorTextFieldWithBrowseButton", "getText"));
        }
    }

    private static class ContentWrapper
    extends JPanel
    implements UserActivityProviderComponent {
        private final List<ChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private ContentWrapper() {
            super(new BorderLayout());
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                ContentWrapper.$$$reportNull$$$0(0);
            }
            this.myListeners.add(changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                ContentWrapper.$$$reportNull$$$0(1);
            }
            this.myListeners.remove(changeListener);
        }

        public void fireStateChanged() {
            for (ChangeListener listener2 : this.myListeners) {
                listener2.stateChanged(new ChangeEvent(this));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/android/tools/idea/run/editor/TestRunParameters$ContentWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

