/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.editor.LaunchOptionConfigurable;
import com.android.tools.idea.run.editor.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.editor.SpecificActivityLaunch;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecificActivityConfigurable
implements LaunchOptionConfigurable<SpecificActivityLaunch.State> {
    private final Project myProject;
    private final LaunchOptionConfigurableContext myContext;
    private JPanel myPanel;
    private ComponentWithBrowseButton<EditorTextField> myActivityField;
    private JCheckBox mySkipActivityValidationCheckBox;

    public SpecificActivityConfigurable(final @NotNull Project project, final @NotNull LaunchOptionConfigurableContext context) {
        if (project == null) {
            SpecificActivityConfigurable.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpecificActivityConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myContext = context;
        this.$$$setupUI$$$();
        this.myActivityField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!project.isInitialized()) {
                    return;
                }
                JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                PsiClass activityBaseClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
                if (activityBaseClass == null) {
                    Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("cant.find.activity.class.error", new Object[0]), (String)"Specific Activity Launcher");
                    return;
                }
                Module module2 = context.getModule();
                if (module2 == null) {
                    Messages.showErrorDialog((Project)project, (String)ExecutionBundle.message((String)"module.not.specified.error.text", (Object[])new Object[0]), (String)"Specific Activity Launcher");
                    return;
                }
                PsiClass initialSelection = facade.findClass(((EditorTextField)SpecificActivityConfigurable.this.myActivityField.getChildComponent()).getText(), module2.getModuleWithDependenciesScope());
                TreeClassChooser chooser2 = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser("Select Activity Class", module2.getModuleWithDependenciesScope(), activityBaseClass, initialSelection, null);
                chooser2.showDialog();
                PsiClass selClass = chooser2.getSelected();
                if (selClass != null) {
                    ((EditorTextField)SpecificActivityConfigurable.this.myActivityField.getChildComponent()).setText(ActivityLocatorUtils.getQualifiedActivityName(selClass));
                }
            }
        });
    }

    private void createUIComponents() {
        LanguageTextField editorTextField2 = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, this.myProject, ""){

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor2 = super.createEditor();
                PsiFile file2 = PsiDocumentManager.getInstance((Project)SpecificActivityConfigurable.this.myProject).getPsiFile((Document)editor2.getDocument());
                if (file2 != null) {
                    DaemonCodeAnalyzer.getInstance((Project)SpecificActivityConfigurable.this.myProject).setHighlightingEnabled(file2, false);
                }
                editor2.putUserData(LaunchOptionConfigurableContext.KEY, (Object)SpecificActivityConfigurable.this.myContext);
                EditorEx editorEx = editor2;
                if (editorEx == null) {
                    2.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/editor/SpecificActivityConfigurable$2", "createEditor"));
            }
        };
        this.myActivityField = new ComponentWithBrowseButton((JComponent)editorTextField2, null);
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    @Override
    public void resetFrom(@NotNull SpecificActivityLaunch.State state) {
        if (state == null) {
            SpecificActivityConfigurable.$$$reportNull$$$0(2);
        }
        ((EditorTextField)this.myActivityField.getChildComponent()).setText(StringUtil.notNullize((String)state.ACTIVITY_CLASS));
        this.mySkipActivityValidationCheckBox.setSelected(state.SKIP_ACTIVITY_VALIDATION);
    }

    @Override
    public void applyTo(@NotNull SpecificActivityLaunch.State state) {
        if (state == null) {
            SpecificActivityConfigurable.$$$reportNull$$$0(3);
        }
        state.ACTIVITY_CLASS = StringUtil.notNullize((String)((EditorTextField)this.myActivityField.getChildComponent()).getText());
        state.SKIP_ACTIVITY_VALIDATION = this.mySkipActivityValidationCheckBox.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/editor/SpecificActivityConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Activity:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        ComponentWithBrowseButton<EditorTextField> componentWithBrowseButton = this.myActivityField;
        jPanel.add((Component)componentWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.mySkipActivityValidationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Skip Activity validation");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

