/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerPanel;
import com.android.tools.idea.run.editor.AndroidProfilersPanel;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeploymentTargetOptions;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Ordering;
import com.intellij.DynamicBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor,
ActionListener {
    private JPanel myPanel;
    protected JBTabbedPane myTabbedPane;
    private JBLabel myModuleJBLabel;
    private ModulesComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private final DeploymentTargetOptions myDeploymentTargetOptions;
    private JCheckBox myClearLogCheckBox;
    private JCheckBox myShowLogcatCheckBox;
    private JCheckBox mySkipNoOpApkInstallation;
    private JCheckBox myForceStopRunningApplicationCheckBox;
    private JComponent anchor;
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;
    private AndroidDebuggerPanel myAndroidDebuggerPanel;
    private final AndroidProfilersPanel myAndroidProfilersPanel;

    public AndroidRunConfigurationEditor(Project project, final Predicate<AndroidFacet> libraryProjectValidator, T config, boolean showLogcatCheckbox, Function<ConfigurationModuleSelector, ConfigurationSpecificEditor<T>> configurationSpecificEditorFactory) {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)project, (Disposable)this);
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModulesComboBox){

            public boolean isModuleAccepted(Module module2) {
                if (module2 == null || !super.isModuleAccepted(module2)) {
                    return false;
                }
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                if (facet2 == null) {
                    return false;
                }
                return !((AndroidFacetConfiguration)facet2.getConfiguration()).isLibraryProject() || libraryProjectValidator.apply((Object)facet2);
            }
        };
        this.myModulesComboBox.addActionListener((ActionListener)this);
        List<DeployTargetProvider> providers2 = ((AndroidRunConfigurationBase)config).getApplicableDeployTargetProviders();
        switch (providers2.size()) {
            case 0: 
            case 1: {
                this.myDeploymentTargetOptions = null;
                break;
            }
            default: {
                this.myDeploymentTargetOptions = new DeploymentTargetOptions(providers2, this, project);
                this.myDeploymentTargetOptions.addTo((Container)this.myTabbedPane.getComponentAt(0));
            }
        }
        if (config instanceof AndroidTestRunConfiguration) {
            this.myForceStopRunningApplicationCheckBox.setVisible(false);
        } else {
            this.mySkipNoOpApkInstallation.addActionListener(e -> {
                if (this.mySkipNoOpApkInstallation == e.getSource()) {
                    this.myForceStopRunningApplicationCheckBox.setEnabled(this.mySkipNoOpApkInstallation.isSelected());
                }
            });
        }
        final AndroidDebuggerContext androidDebuggerContext = ((AndroidRunConfigurationBase)config).getAndroidDebuggerContext();
        this.myModulesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                androidDebuggerContext.setDebuggeeModule(AndroidRunConfigurationEditor.this.myModulesComboBox.getSelectedModule());
            }
        });
        if (androidDebuggerContext.getAndroidDebuggers().size() > 1) {
            this.myAndroidDebuggerPanel = new AndroidDebuggerPanel((RunConfiguration)config, androidDebuggerContext);
            this.myTabbedPane.add("Debugger", (Component)this.myAndroidDebuggerPanel.getComponent());
        }
        this.myAndroidProfilersPanel = new AndroidProfilersPanel(project, ((AndroidRunConfigurationBase)config).getProfilerState());
        this.myTabbedPane.add("Profiling", (Component)this.myAndroidProfilersPanel.getComponent());
        this.myConfigurationSpecificEditor = configurationSpecificEditorFactory.apply(this.myModuleSelector);
        Disposer.register((Disposable)this, this.myConfigurationSpecificEditor);
        this.myConfigurationSpecificPanel.add(this.myConfigurationSpecificEditor.getComponent());
        this.myShowLogcatCheckBox.setVisible(showLogcatCheckbox);
        this.checkValidationResults(((AndroidRunConfigurationBase)config).validate(null));
    }

    private void checkValidationResults(@NotNull List<ValidationError> errors2) {
        if (errors2 == null) {
            AndroidRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (errors2.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors2);
        if (ValidationError.Category.PROFILER.equals((Object)topError.getCategory())) {
            this.myTabbedPane.setSelectedComponent((Component)this.myAndroidProfilersPanel.getComponent());
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        if (configuration == null) {
            AndroidRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        this.myModuleSelector.reset(configuration);
        if (this.myDeploymentTargetOptions != null) {
            this.myDeploymentTargetOptions.resetFrom((AndroidRunConfigurationBase)configuration);
        }
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).SHOW_LOGCAT_AUTOMATICALLY);
        this.mySkipNoOpApkInstallation.setSelected(((AndroidRunConfigurationBase)configuration).SKIP_NOOP_APK_INSTALLATIONS);
        this.myForceStopRunningApplicationCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).FORCE_STOP_RUNNING_APP);
        this.myConfigurationSpecificEditor.resetFrom(configuration);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.resetFrom(((AndroidRunConfigurationBase)configuration).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.resetFrom(((AndroidRunConfigurationBase)configuration).getProfilerState());
    }

    protected void applyEditorTo(@NotNull T configuration) {
        if (configuration == null) {
            AndroidRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        this.myModuleSelector.applyTo(configuration);
        if (this.myDeploymentTargetOptions != null) {
            this.myDeploymentTargetOptions.applyTo((AndroidRunConfigurationBase)configuration);
        }
        ((AndroidRunConfigurationBase)configuration).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration).SKIP_NOOP_APK_INSTALLATIONS = this.mySkipNoOpApkInstallation.isSelected();
        ((AndroidRunConfigurationBase)configuration).FORCE_STOP_RUNNING_APP = this.myForceStopRunningApplicationCheckBox.isSelected();
        this.myConfigurationSpecificEditor.applyTo(configuration);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.applyTo(((AndroidRunConfigurationBase)configuration).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.applyTo(((AndroidRunConfigurationBase)configuration).getProfilerState());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AndroidRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    @NotNull
    JComboBox getModuleComboBox() {
        ModulesComboBox modulesComboBox = this.myModulesComboBox;
        if (modulesComboBox == null) {
            AndroidRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return modulesComboBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myModulesComboBox && this.myConfigurationSpecificEditor instanceof ApplicationRunParameters) {
            ((ApplicationRunParameters)this.myConfigurationSpecificEditor).onModuleChanged();
        }
    }

    @Nullable
    @VisibleForTesting
    DeploymentTargetOptions getDeploymentTargetOptions() {
        return this.myDeploymentTargetOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/editor/AndroidRunConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/editor/AndroidRunConfigurationEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkValidationResults";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(46, 14), null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/AndroidBundle", AndroidRunConfigurationEditor.class).getString("android.run.configuration.general.tab.title"), null, jPanel3, null);
        this.myModuleJBLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jBLabel.setDisplayedMnemonic('M');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesComboBox = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigurationSpecificPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/AndroidBundle", AndroidRunConfigurationEditor.class).getString("android.run.configuration.misc.tab.title"), null, jPanel4, null);
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Logcat", (int)0, (int)0, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClearLogCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/AndroidBundle", AndroidRunConfigurationEditor.class).getString("android.run.configuration.logcat.skip.content.label"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowLogcatCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Show logcat automatically");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Installation Options", (int)0, (int)0, null, null));
        this.mySkipNoOpApkInstallation = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Skip installation if APK has not changed");
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel6.add((Component)spacer7, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myForceStopRunningApplicationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Force stop running application before launching activity");
        jPanel6.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)modulesComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

