/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.adtui.ui.ClickableLabel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.upgrade.AndroidPluginVersionUpdater;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.profiler.CpuProfilerConfig;
import com.android.tools.idea.run.profiler.CpuProfilerConfigsState;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import java.util.concurrent.Future;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;

public class AndroidProfilersPanel
implements HyperlinkListener {
    private static final String MINIMUM_GRADLE_PLUGIN_VERSION_STRING = "2.4.0";
    private static final GradleVersion MINIMUM_GRADLE_PLUGIN_VERSION = GradleVersion.parse((String)"2.4.0");
    private final Project myProject;
    private JPanel myDescription;
    private JPanel myStartupInnerPanel;
    private JTextPane myNativeMemoryRateProfilerDescription;
    private JCheckBox myAdvancedProfilingCheckBox;
    private ClickableLabel myAdvancedProfilingLabel;
    private HyperlinkLabel myHyperlinkLabel;
    private JTextPane myAdvancedProfilingDescription;
    private JCheckBox myStartupProfileCheckBox;
    private ClickableLabel myStartupProfileLabel;
    private LabeledComponent<JBTextField> myNativeMemoryProfilerSampleRate;
    private ComboBox<CpuProfilerConfig> myStartupCpuConfigsComboBox;
    private JTextPane myStartupCpuProfilerDescription;
    private JBRadioButton myCpuRecordingRadio;
    private JBRadioButton myMemoryRecordingRadio;

    public JComponent getComponent() {
        return this.myDescription;
    }

    public AndroidProfilersPanel(Project project, ProfilerState state) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.updateHyperlink("");
        this.addActionListenersToLabels();
        this.setUpStartupProfiling();
        this.resetFrom(state);
    }

    void addActionListenersToLabels() {
        this.myAdvancedProfilingLabel.addActionListener(e -> {
            this.myAdvancedProfilingCheckBox.requestFocus();
            this.myAdvancedProfilingCheckBox.setSelected(!this.myAdvancedProfilingCheckBox.isSelected());
        });
        this.myStartupProfileLabel.addActionListener(e -> this.myStartupProfileCheckBox.setSelected(!this.myStartupProfileCheckBox.isSelected()));
    }

    private void setUpStartupProfiling() {
        this.myStartupProfileCheckBox.addItemListener(e -> {
            this.myCpuRecordingRadio.setEnabled(this.myStartupProfileCheckBox.isSelected());
            this.myMemoryRecordingRadio.setEnabled(this.myStartupProfileCheckBox.isSelected());
            this.myStartupCpuConfigsComboBox.setEnabled(this.myCpuRecordingRadio.isSelected() && this.myStartupProfileCheckBox.isSelected());
            this.myStartupProfileCheckBox.setSelected(this.myStartupProfileCheckBox.isSelected());
        });
        this.myCpuRecordingRadio.addItemListener(e -> {
            if (this.myCpuRecordingRadio.isSelected()) {
                this.myMemoryRecordingRadio.setSelected(false);
                this.myStartupCpuConfigsComboBox.setEnabled(this.myCpuRecordingRadio.isSelected());
            }
        });
        this.myMemoryRecordingRadio.addItemListener(e -> {
            if (this.myMemoryRecordingRadio.isSelected()) {
                this.myCpuRecordingRadio.setSelected(false);
                this.myStartupCpuConfigsComboBox.setEnabled(!this.myMemoryRecordingRadio.isSelected());
            }
        });
        this.myStartupCpuConfigsComboBox.setModel(new DefaultComboBoxModel<CpuProfilerConfig>(CpuProfilerConfigsState.getInstance(this.myProject).getConfigs().toArray(new CpuProfilerConfig[0])));
        this.myStartupCpuConfigsComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", CpuProfilerConfig::getName));
        this.myStartupCpuConfigsComboBox.setSelectedIndex(0);
        if (!((Boolean)StudioFlags.PROFILER_ENABLE_NATIVE_SAMPLE.get()).booleanValue()) {
            this.myMemoryRecordingRadio.setVisible(false);
            this.myNativeMemoryProfilerSampleRate.setVisible(false);
        }
    }

    public void resetFrom(ProfilerState state) {
        boolean enabled = this.myAdvancedProfilingCheckBox.isEnabled();
        this.myAdvancedProfilingDescription.setBackground(this.myDescription.getBackground());
        this.myAdvancedProfilingDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myAdvancedProfilingCheckBox.setSelected(enabled && state.ADVANCED_PROFILING_ENABLED);
        ((JBTextField)this.myNativeMemoryProfilerSampleRate.getComponent()).setText(Integer.toString(state.NATIVE_MEMORY_SAMPLE_RATE_BYTES));
        this.myNativeMemoryRateProfilerDescription.setBackground(this.myDescription.getBackground());
        this.myNativeMemoryRateProfilerDescription.setForeground(UIUtil.getContextHelpForeground());
        this.myStartupProfileCheckBox.setSelected(state.STARTUP_PROFILING_ENABLED);
        this.myCpuRecordingRadio.setSelected(state.STARTUP_CPU_PROFILING_ENABLED);
        this.myMemoryRecordingRadio.setSelected(state.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED);
        this.myStartupCpuProfilerDescription.setBackground(this.myDescription.getBackground());
        this.myStartupCpuProfilerDescription.setForeground(UIUtil.getContextHelpForeground());
        String name = state.STARTUP_CPU_PROFILING_CONFIGURATION_NAME;
        CpuProfilerConfig config = CpuProfilerConfigsState.getInstance(this.myProject).getConfigByName(name);
        if (config != null) {
            this.myStartupCpuConfigsComboBox.setSelectedItem((Object)config);
        }
    }

    public void applyTo(ProfilerState state) {
        state.ADVANCED_PROFILING_ENABLED = this.myAdvancedProfilingCheckBox.isSelected();
        boolean bl = state.STARTUP_CPU_PROFILING_ENABLED = (Boolean)StudioFlags.PROFILER_STARTUP_CPU_PROFILING.get() != false && this.myCpuRecordingRadio.isSelected();
        assert (this.myStartupCpuConfigsComboBox.getSelectedItem() instanceof CpuProfilerConfig);
        state.STARTUP_CPU_PROFILING_CONFIGURATION_NAME = ((CpuProfilerConfig)this.myStartupCpuConfigsComboBox.getSelectedItem()).getName();
        state.STARTUP_NATIVE_MEMORY_PROFILING_ENABLED = this.myMemoryRecordingRadio.isSelected();
        state.STARTUP_PROFILING_ENABLED = this.myStartupProfileCheckBox.isSelected();
        try {
            state.NATIVE_MEMORY_SAMPLE_RATE_BYTES = Math.max(1, Integer.parseInt(((JBTextField)this.myNativeMemoryProfilerSampleRate.getComponent()).getText()));
        }
        catch (NumberFormatException ex) {
            state.NATIVE_MEMORY_SAMPLE_RATE_BYTES = 2048;
        }
    }

    private void createUIComponents() {
        this.myHyperlinkLabel = new HyperlinkLabel();
        this.myHyperlinkLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void updateHyperlink(String message2) {
        boolean supported = true;
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidModuleModel model2 = AndroidModuleModel.get(module2);
            if (model2 == null) continue;
            GradleVersion modelVersion = model2.getModelVersion();
            boolean bl = supported = modelVersion != null && modelVersion.compareIgnoringQualifiers(MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
            if (!supported) break;
        }
        this.myHyperlinkLabel.setHyperlinkText("This feature can only be enabled with a gradle plugin version of 2.4 or greater. ", "Update project", "");
        this.myHyperlinkLabel.setVisible(!supported);
        this.myHyperlinkLabel.setVisible(!supported);
        this.myDescription.setEnabled(supported);
        this.myAdvancedProfilingCheckBox.setEnabled(supported);
        this.myAdvancedProfilingLabel.setEnabled(supported);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        GradleVersion gradleVersion2 = GradleVersion.parse((String)"6.7.1");
        GradleVersion pluginVersion = GradleVersion.parse((String)LatestKnownPluginVersionProvider.INSTANCE.get());
        if (MINIMUM_GRADLE_PLUGIN_VERSION.compareIgnoringQualifiers(pluginVersion) > 0) {
            this.updateHyperlink("(No matching gradle version found)");
            return;
        }
        AndroidPluginVersionUpdater updater = AndroidPluginVersionUpdater.getInstance(this.myProject);
        AndroidPluginVersionUpdater.UpdateResult result2 = updater.updatePluginVersion(pluginVersion, gradleVersion2, null);
        if (result2.isPluginVersionUpdated() && result2.versionUpdateSuccess()) {
            this.requestSync();
        } else {
            this.updateHyperlink("(Update failed)");
        }
    }

    private void requestSync() {
        SettableFuture syncResult = SettableFuture.create();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.updateHyperlink("(Syncing...)");
            syncResult.setFuture(ProjectSystemUtil.getProjectSystem(this.myProject).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED));
        });
        if (((ProjectSystemSyncManager.SyncResult)((Object)Futures.getUnchecked((Future)syncResult))).isSuccessful()) {
            this.updateHyperlink("");
        } else {
            this.updateHyperlink("(Sync failed)");
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        LabeledComponent labeledComponent;
        ComboBox comboBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel;
        ClickableLabel clickableLabel;
        JCheckBox jCheckBox;
        JTextPane jTextPane2;
        ClickableLabel clickableLabel2;
        JTextPane jTextPane3;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.createUIComponents();
        this.myDescription = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myStartupProfileCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setHorizontalAlignment(4);
        jCheckBox2.setHorizontalTextPosition(4);
        jCheckBox2.setIconTextGap(0);
        jCheckBox2.setMargin(new Insets(1, 0, 0, 0));
        jCheckBox2.setText("");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null));
        HyperlinkLabel hyperlinkLabel = this.myHyperlinkLabel;
        jPanel2.add((Component)hyperlinkLabel, new GridConstraints(5, 0, 1, 4, 9, 0, 7, 3, null, new Dimension(150, 20), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myAdvancedProfilingDescription = jTextPane3 = new JTextPane();
        jTextPane3.setEditable(false);
        Font font = this.$$$getFont$$$(null, -1, 11, jTextPane3.getFont());
        if (font != null) {
            jTextPane3.setFont(font);
        }
        jTextPane3.setText("Allows the profilers to track data such as network payloads, application events and object counts for devices running API level < 26, but it might have a minor performance impact on your build speeds. ");
        jPanel2.add((Component)jTextPane3, new GridConstraints(6, 1, 1, 2, 0, 3, 6, 2, null, new Dimension(150, 50), null));
        this.myStartupProfileLabel = clickableLabel2 = new ClickableLabel();
        clickableLabel2.setMargin(new Insets(2, 14, 0, 14));
        clickableLabel2.setText("Start this recording on startup:");
        jPanel2.add((Component)clickableLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 3, null, null, null));
        this.myNativeMemoryRateProfilerDescription = jTextPane2 = new JTextPane();
        jTextPane2.setAutoscrolls(false);
        jTextPane2.setDoubleBuffered(false);
        jTextPane2.setEditable(false);
        ((Component)jTextPane2).setEnabled(true);
        Font font2 = this.$$$getFont$$$(null, -1, 11, jTextPane2.getFont());
        if (font2 != null) {
            jTextPane2.setFont(font2);
        }
        jTextPane2.setMargin(new Insets(0, 3, 0, 3));
        jTextPane2.setText("Native memory sampling rate. This value when set will remain for both startup and non-startup recordings.");
        jPanel2.add((Component)jTextPane2, new GridConstraints(1, 1, 1, 2, 0, 3, 1, 1, null, null, null));
        this.myAdvancedProfilingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setAlignmentX(1.0f);
        jCheckBox.setHorizontalAlignment(4);
        jCheckBox.setHorizontalTextPosition(4);
        jCheckBox.setIconTextGap(0);
        jCheckBox.setMargin(new Insets(1, 0, 0, 0));
        jCheckBox.setText("");
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 4, 0, 0, 0, null, new Dimension(8, 23), null));
        this.myAdvancedProfilingLabel = clickableLabel = new ClickableLabel();
        clickableLabel.setText("Enable advanced profiling for older devices");
        jPanel2.add((Component)clickableLabel, new GridConstraints(5, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStartupInnerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCpuRecordingRadio = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setEnabled(false);
        jBRadioButton2.setText("CPU activity (Requires API level >= 26)");
        jPanel.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        this.myMemoryRecordingRadio = jBRadioButton = new JBRadioButton();
        jBRadioButton.setEnabled(false);
        jBRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jBRadioButton.setText("Native memory activity (Requires API level >= 29)");
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 1, 3, 3, null, null, null));
        this.myStartupCpuConfigsComboBox = comboBox = new ComboBox();
        comboBox.setEnabled(false);
        jPanel.add((Component)comboBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 3, null, new Dimension(350, -1), null));
        this.myNativeMemoryProfilerSampleRate = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent.setLabelInsets(new Insets(0, 6, 0, 0));
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Native memory sampling interval (bytes)");
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 3, 9, 1, 3, 3, null, null, null));
        this.myStartupCpuProfilerDescription = jTextPane = new JTextPane();
        jTextPane.setAutoscrolls(false);
        jTextPane.setDoubleBuffered(false);
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        Font font3 = this.$$$getFont$$$(null, -1, 11, jTextPane.getFont());
        if (font3 != null) {
            jTextPane.setFont(font3);
        }
        jTextPane.setMargin(new Insets(0, 3, 0, 3));
        jTextPane.setText("You must select Run > Profile from the main menu and deploy your app to a device");
        jPanel2.add((Component)jTextPane, new GridConstraints(3, 1, 1, 1, 0, 3, 1, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myDescription;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        Font font3 = new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
        boolean bl = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font font4 = bl ? new Font(font3.getFamily(), font3.getStyle(), font3.getSize()) : new StyleContext().getFont(font3.getFamily(), font3.getStyle(), font3.getSize());
        return font4 instanceof FontUIResource ? font4 : new FontUIResource(font4);
    }
}

