/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.VirtualDevice;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VirtualDevicesTask
implements AsyncSupplier<Collection<VirtualDevice>> {
    @NotNull
    private final ExecutorService myExecutorService;
    @NotNull
    private final @NotNull Supplier<@NotNull Collection<@NotNull AvdInfo>> myGetAvds;
    @NotNull
    private final BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
    @NotNull
    private final FileSystem myFileSystem;
    @NotNull
    private final @NotNull Function<@NotNull AvdInfo, @NotNull AndroidDevice> myNewLaunchableAndroidDevice;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;

    private VirtualDevicesTask(@NotNull Builder builder2) {
        if (builder2 == null) {
            VirtualDevicesTask.$$$reportNull$$$0(0);
        }
        assert (builder2.myExecutorService != null);
        this.myExecutorService = builder2.myExecutorService;
        assert (builder2.myGetAvds != null);
        this.myGetAvds = builder2.myGetAvds;
        assert (builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled != null);
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
        assert (builder2.myFileSystem != null);
        this.myFileSystem = builder2.myFileSystem;
        assert (builder2.myNewLaunchableAndroidDevice != null);
        this.myNewLaunchableAndroidDevice = builder2.myNewLaunchableAndroidDevice;
        this.myChecker = builder2.myChecker;
    }

    @Override
    @NotNull
    public ListenableFuture<Collection<VirtualDevice>> get() {
        ListenableFuture listenableFuture = MoreExecutors.listeningDecorator((ExecutorService)this.myExecutorService).submit(this::getVirtualDevices);
        if (listenableFuture == null) {
            VirtualDevicesTask.$$$reportNull$$$0(1);
        }
        return listenableFuture;
    }

    @NotNull
    private Collection<VirtualDevice> getVirtualDevices() {
        Collection<AvdInfo> avdCollection = this.myGetAvds.get();
        Stream<AvdInfo> avdStream = avdCollection.stream();
        Collection deviceCollection = !this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled.getAsBoolean() ? (Collection)avdStream.map(avd -> this.newDisconnectedDevice((AvdInfo)avd, null)).collect(Collectors.toList()) : (Collection)avdStream.flatMap(this::newDisconnectedDevices).collect(Collectors.toList());
        if (!VirtualDevicesTask.hasDuplicateKeys(deviceCollection)) {
            Collection collection2 = deviceCollection;
            if (collection2 == null) {
                VirtualDevicesTask.$$$reportNull$$$0(2);
            }
            return collection2;
        }
        Logger.getInstance(VirtualDevicesTask.class).warn("duplicate keys found");
        VirtualDevicesTask.logDebugStrings(avdCollection);
        return VirtualDevicesTask.newListWithoutDuplicateKeys(deviceCollection);
    }

    @NotNull
    private Stream<VirtualDevice> newDisconnectedDevices(@NotNull AvdInfo device) {
        if (device == null) {
            VirtualDevicesTask.$$$reportNull$$$0(3);
        }
        Stream.Builder<VirtualDevice> builder2 = Stream.builder().add(this.newDisconnectedDevice(device, null));
        this.getSnapshots(device).stream().map(snapshot -> this.newDisconnectedDevice(device, (Snapshot)snapshot)).forEach(builder2::add);
        Stream<VirtualDevice> stream = builder2.build();
        if (stream == null) {
            VirtualDevicesTask.$$$reportNull$$$0(4);
        }
        return stream;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private Collection<Snapshot> getSnapshots(@NotNull AvdInfo device) {
        Collection collection2;
        Stream<Path> stream;
        Path snapshots;
        block13: {
            if (device == null) {
                VirtualDevicesTask.$$$reportNull$$$0(5);
            }
            if (!Files.isDirectory(snapshots = this.myFileSystem.getPath(device.getDataFolderPath(), "snapshots"), new LinkOption[0])) {
                ImmutableList immutableList = ImmutableList.of();
                if (immutableList == null) {
                    VirtualDevicesTask.$$$reportNull$$$0(6);
                }
                return immutableList;
            }
            stream = Files.list(snapshots);
            collection2 = (Collection)stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(this::getSnapshot).filter(Objects::nonNull).sorted().collect(ImmutableList.toImmutableList());
            if (stream == null) break block13;
            stream.close();
        }
        Collection collection3 = collection2;
        if (collection3 == null) {
            VirtualDevicesTask.$$$reportNull$$$0(7);
        }
        return collection3;
        {
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Logger.getInstance(VirtualDevicesTask.class).warn(snapshots.toString(), (Throwable)exception);
                    ImmutableList immutableList = ImmutableList.of();
                    if (immutableList == null) {
                        VirtualDevicesTask.$$$reportNull$$$0(8);
                    }
                    return immutableList;
                }
            }
        }
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull Path snapshotDirectory) {
        Snapshot snapshot;
        block10: {
            if (snapshotDirectory == null) {
                VirtualDevicesTask.$$$reportNull$$$0(9);
            }
            Path snapshotProtocolBuffer = snapshotDirectory.resolve("snapshot.pb");
            Path snapshotDirectoryName = snapshotDirectory.getFileName();
            if (!Files.exists(snapshotProtocolBuffer, new LinkOption[0])) {
                return new Snapshot(snapshotDirectoryName, this.myFileSystem);
            }
            InputStream in = Files.newInputStream(snapshotProtocolBuffer, new OpenOption[0]);
            try {
                snapshot = this.getSnapshot(SnapshotOuterClass.Snapshot.parseFrom((InputStream)in), snapshotDirectoryName);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    Logger.getInstance(VirtualDevicesTask.class).warn(snapshotDirectory.toString(), (Throwable)exception);
                    return null;
                }
            }
            in.close();
        }
        return snapshot;
    }

    @Nullable
    @VisibleForTesting
    Snapshot getSnapshot(@NotNull SnapshotOuterClass.Snapshot snapshot, @NotNull Path snapshotDirectory) {
        if (snapshot == null) {
            VirtualDevicesTask.$$$reportNull$$$0(10);
        }
        if (snapshotDirectory == null) {
            VirtualDevicesTask.$$$reportNull$$$0(11);
        }
        if (snapshot.getImagesCount() == 0) {
            return null;
        }
        String name = snapshot.getLogicalName();
        if (name.isEmpty()) {
            return new Snapshot(snapshotDirectory, this.myFileSystem);
        }
        return new Snapshot(snapshotDirectory, name);
    }

    @NotNull
    private VirtualDevice newDisconnectedDevice(@NotNull AvdInfo avd, @Nullable Snapshot snapshot) {
        if (avd == null) {
            VirtualDevicesTask.$$$reportNull$$$0(12);
        }
        AndroidDevice device = this.myNewLaunchableAndroidDevice.apply(avd);
        VirtualDevice.Builder builder2 = new VirtualDevice.Builder().setName(avd.getDisplayName()).setKey(new VirtualDevicePath(avd.getDataFolderPath())).setAndroidDevice(device).setNameKey(new VirtualDeviceName(avd.getName())).setSnapshot(snapshot);
        if (this.myChecker == null) {
            VirtualDevice virtualDevice = builder2.build();
            if (virtualDevice == null) {
                VirtualDevicesTask.$$$reportNull$$$0(13);
            }
            return virtualDevice;
        }
        LaunchCompatibility compatibility = this.myChecker.validate(device);
        VirtualDevice virtualDevice = builder2.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
        if (virtualDevice == null) {
            VirtualDevicesTask.$$$reportNull$$$0(14);
        }
        return virtualDevice;
    }

    private static boolean hasDuplicateKeys(@NotNull @NotNull Collection<@NotNull ? extends Device> devices2) {
        Collection keys;
        if (devices2 == null) {
            VirtualDevicesTask.$$$reportNull$$$0(15);
        }
        return (keys = (Collection)devices2.stream().map(Device::getKey).collect(Collectors.toSet())).size() != devices2.size();
    }

    private static void logDebugStrings(@NotNull @NotNull Collection<@NotNull AvdInfo> avds) {
        if (avds == null) {
            VirtualDevicesTask.$$$reportNull$$$0(16);
        }
        Logger logger2 = Logger.getInstance(VirtualDevicesTask.class);
        avds.stream().map(AvdInfo::toDebugString).forEach(arg_0 -> ((Logger)logger2).warn(arg_0));
    }

    @NotNull
    private static @NotNull List<@NotNull VirtualDevice> newListWithoutDuplicateKeys(@NotNull @NotNull Collection<@NotNull VirtualDevice> devices2) {
        if (devices2 == null) {
            VirtualDevicesTask.$$$reportNull$$$0(17);
        }
        HashSet keys = Sets.newHashSetWithExpectedSize((int)devices2.size());
        List list = ContainerUtil.filter(devices2, device -> keys.add(device.getKey()));
        if (list == null) {
            VirtualDevicesTask.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/VirtualDevicesTask";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotDirectory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avd";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/VirtualDevicesTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualDevices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisconnectedDevices";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnapshots";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisconnectedDevice";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "newListWithoutDuplicateKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newDisconnectedDevices";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshots";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSnapshot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newDisconnectedDevice";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasDuplicateKeys";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logDebugStrings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "newListWithoutDuplicateKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Builder {
        @Nullable
        private ExecutorService myExecutorService;
        private @Nullable Supplier<@NotNull Collection<@NotNull AvdInfo>> myGetAvds;
        @Nullable
        private BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabled;
        @Nullable
        private FileSystem myFileSystem;
        private @Nullable Function<@NotNull AvdInfo, @NotNull AndroidDevice> myNewLaunchableAndroidDevice;
        @Nullable
        private LaunchCompatibilityChecker myChecker;

        Builder() {
        }

        @NotNull
        Builder setExecutorService(@NotNull ExecutorService executorService) {
            if (executorService == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myExecutorService = executorService;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        Builder setGetAvds(@NotNull @NotNull Supplier<@NotNull Collection<@NotNull AvdInfo>> getAvds) {
            if (getAvds == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myGetAvds = getAvds;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        Builder setSelectDeviceSnapshotComboBoxSnapshotsEnabled(@NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabled) {
            if (selectDeviceSnapshotComboBoxSnapshotsEnabled == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.mySelectDeviceSnapshotComboBoxSnapshotsEnabled = selectDeviceSnapshotComboBoxSnapshotsEnabled;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        Builder setFileSystem(@NotNull FileSystem fileSystem) {
            if (fileSystem == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myFileSystem = fileSystem;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        Builder setNewLaunchableAndroidDevice(@NotNull @NotNull Function<@NotNull AvdInfo, @NotNull AndroidDevice> newLaunchableAndroidDevice) {
            if (newLaunchableAndroidDevice == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myNewLaunchableAndroidDevice = newLaunchableAndroidDevice;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        Builder setChecker(@Nullable LaunchCompatibilityChecker checker2) {
            this.myChecker = checker2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        VirtualDevicesTask build() {
            return new VirtualDevicesTask(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorService";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/deployment/VirtualDevicesTask$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "getAvds";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectDeviceSnapshotComboBoxSnapshotsEnabled";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSystem";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLaunchableAndroidDevice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/deployment/VirtualDevicesTask$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setExecutorService";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGetAvds";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSelectDeviceSnapshotComboBoxSnapshotsEnabled";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFileSystem";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNewLaunchableAndroidDevice";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setChecker";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setExecutorService";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setGetAvds";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelectDeviceSnapshotComboBoxSnapshotsEnabled";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setFileSystem";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewLaunchableAndroidDevice";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

