/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Updater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Presentation myPresentation;
    @NotNull
    private final String myPlace;
    @NotNull
    private final DevicesSelectedService myDevicesSelectedService;
    @NotNull
    private final List<Device> myDevices;
    @Nullable
    private final RunnerAndConfigurationSettings myConfigurationAndSettings;
    private final boolean mySnapshotsEnabled;

    private Updater(@NotNull Builder builder2) {
        if (builder2 == null) {
            Updater.$$$reportNull$$$0(0);
        }
        assert (builder2.myProject != null);
        this.myProject = builder2.myProject;
        assert (builder2.myPresentation != null);
        this.myPresentation = builder2.myPresentation;
        this.myPlace = builder2.myPlace;
        assert (builder2.myDevicesSelectedService != null);
        this.myDevicesSelectedService = builder2.myDevicesSelectedService;
        this.myDevices = builder2.myDevices;
        this.myConfigurationAndSettings = builder2.myConfigurationAndSettings;
        this.mySnapshotsEnabled = builder2.mySnapshotsEnabled;
    }

    void update() {
        if (!AndroidUtils.hasAndroidFacets(this.myProject)) {
            this.myPresentation.setVisible(false);
            return;
        }
        this.myPresentation.setVisible(true);
        this.updateDependingOnConfiguration();
        switch (this.myPlace) {
            case "MainToolbar": 
            case "NavBarToolbar": {
                if (this.myDevicesSelectedService.isMultipleDevicesSelectedInComboBox()) {
                    this.updateInToolbarForMultipleDevices();
                    break;
                }
                this.updateInToolbarForSingleDevice();
                break;
            }
            default: {
                this.myPresentation.setIcon(null);
                this.myPresentation.setText("Select Device...");
            }
        }
    }

    private void updateDependingOnConfiguration() {
        if (this.myConfigurationAndSettings == null) {
            this.myPresentation.setEnabled(false);
            this.myPresentation.setDescription("Add a run/debug configuration");
            return;
        }
        RunConfiguration configuration = this.myConfigurationAndSettings.getConfiguration();
        if (configuration instanceof AndroidRunConfiguration || configuration instanceof AndroidTestRunConfiguration) {
            this.myPresentation.setEnabled(true);
            this.myPresentation.setDescription((String)null);
            return;
        }
        if (this.configurationDeploysToLocalDevice()) {
            this.myPresentation.setEnabled(true);
            this.myPresentation.setDescription((String)null);
            return;
        }
        this.myPresentation.setEnabled(false);
        this.myPresentation.setDescription("Not applicable for the \"" + configuration.getName() + "\" configuration");
    }

    private boolean configurationDeploysToLocalDevice() {
        assert (this.myConfigurationAndSettings != null);
        RunConfiguration configuration = this.myConfigurationAndSettings.getConfiguration();
        if (!(configuration instanceof UserDataHolder)) {
            return false;
        }
        Boolean deploysToLocalDevice = (Boolean)((UserDataHolder)configuration).getUserData(DeviceAndSnapshotComboBoxAction.DEPLOYS_TO_LOCAL_DEVICE);
        return deploysToLocalDevice != null && deploysToLocalDevice != false;
    }

    private void updateInToolbarForMultipleDevices() {
        Set keys;
        Set<Key> selectedKeys = this.myDevicesSelectedService.getDeviceKeysSelectedWithDialog();
        if (selectedKeys.retainAll(keys = this.myDevices.stream().map(Device::getKey).collect(Collectors.toSet()))) {
            this.myDevicesSelectedService.setDeviceKeysSelectedWithDialog(selectedKeys);
            if (selectedKeys.isEmpty()) {
                this.myDevicesSelectedService.setMultipleDevicesSelectedInComboBox(false);
                this.myDevicesSelectedService.setDeviceSelectedWithComboBox(this.myDevicesSelectedService.getDeviceSelectedWithComboBox(this.myDevices));
                this.updateInToolbarForSingleDevice();
                return;
            }
        }
        this.myPresentation.setIcon(StudioIcons.DeviceExplorer.MULTIPLE_DEVICES);
        this.myPresentation.setText("Multiple Devices (" + selectedKeys.size() + ")");
    }

    private void updateInToolbarForSingleDevice() {
        if (this.myDevices.isEmpty()) {
            this.myPresentation.setIcon(null);
            this.myPresentation.setText("No Devices");
            return;
        }
        Device device = this.myDevicesSelectedService.getDeviceSelectedWithComboBox(this.myDevices);
        assert (device != null);
        this.myPresentation.setIcon(device.getIcon());
        this.myPresentation.setText(this.getText(device), false);
    }

    @NotNull
    private String getText(@NotNull Device device) {
        if (device == null) {
            Updater.$$$reportNull$$$0(1);
        }
        Key key = Devices.containsAnotherDeviceWithSameName(this.myDevices, device) ? device.getKey() : null;
        Snapshot snapshot = this.mySnapshotsEnabled ? device.getSnapshot() : null;
        String string = Devices.getText(device, key, snapshot);
        if (string == null) {
            Updater.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/Updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/Updater";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Builder {
        @Nullable
        private Project myProject;
        @Nullable
        private Presentation myPresentation;
        @NotNull
        private String myPlace = "MainToolbar";
        @Nullable
        private DevicesSelectedService myDevicesSelectedService;
        @NotNull
        private List<Device> myDevices = Collections.emptyList();
        @Nullable
        private RunnerAndConfigurationSettings myConfigurationAndSettings;
        private boolean mySnapshotsEnabled;

        Builder() {
        }

        @NotNull
        Builder setProject(@NotNull Project project) {
            if (project == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        Builder setPresentation(@NotNull Presentation presentation) {
            if (presentation == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myPresentation = presentation;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        Builder setPlace(@NotNull String place) {
            if (place == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myPlace = place;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        Builder setDevicesSelectedService(@NotNull DevicesSelectedService devicesSelectedService) {
            if (devicesSelectedService == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myDevicesSelectedService = devicesSelectedService;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        Builder setDevices(@NotNull List<Device> devices2) {
            if (devices2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myDevices = devices2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        Builder setConfigurationAndSettings(@Nullable RunnerAndConfigurationSettings configurationAndSettings) {
            this.myConfigurationAndSettings = configurationAndSettings;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        Builder setSnapshotsEnabled(boolean snapshotsEnabled) {
            this.mySnapshotsEnabled = snapshotsEnabled;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder2;
        }

        @NotNull
        Updater build() {
            return new Updater(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/deployment/Updater$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "devicesSelectedService";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "devices";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/deployment/Updater$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setProject";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPlace";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDevicesSelectedService";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setDevices";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setConfigurationAndSettings";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setSnapshotsEnabled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setProject";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setPresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setPlace";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setDevicesSelectedService";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setDevices";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

