/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.flags.Flag;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTable;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialogTableModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectMultipleDevicesDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final BooleanSupplier myRunOnMultipleDevicesActionEnabledGet;
    @NotNull
    private final TableModel myTableModel;
    @NotNull
    private final Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance;
    @Nullable
    private SelectMultipleDevicesDialogTable myTable;

    SelectMultipleDevicesDialog(@NotNull Project project, @NotNull List<Device> devices2) {
        if (project == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(0);
        }
        if (devices2 == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(1);
        }
        this(project, () -> ((Flag)StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED).get(), new SelectMultipleDevicesDialogTableModel(devices2), DevicesSelectedService::getInstance);
    }

    @VisibleForTesting
    SelectMultipleDevicesDialog(@NotNull Project project, @NotNull BooleanSupplier runOnMultipleDevicesActionEnabledGet, @NotNull TableModel tableModel2, @NotNull Function<Project, DevicesSelectedService> devicesSelectedServiceGetInstance) {
        if (project == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(2);
        }
        if (runOnMultipleDevicesActionEnabledGet == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(3);
        }
        if (tableModel2 == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(4);
        }
        if (devicesSelectedServiceGetInstance == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(5);
        }
        super(project);
        this.myProject = project;
        this.myRunOnMultipleDevicesActionEnabledGet = runOnMultipleDevicesActionEnabledGet;
        this.myTableModel = tableModel2;
        this.myDevicesSelectedServiceGetInstance = devicesSelectedServiceGetInstance;
        this.initTable();
        this.initOkAction();
        this.init();
        this.setTitle(runOnMultipleDevicesActionEnabledGet.getAsBoolean() ? "Run on Multiple Devices" : "Select Multiple Devices");
    }

    private void initTable() {
        if (this.myRunOnMultipleDevicesActionEnabledGet.getAsBoolean()) {
            this.myTableModel.addTableModelListener(event -> {
                if (event.getColumn() == 0 && event.getType() == 0) {
                    assert (this.myTable != null);
                    this.getOKAction().setEnabled(IntStream.range(0, this.myTable.getRowCount()).anyMatch(this.myTable::isSelected));
                }
            });
        }
        this.myTable = new SelectMultipleDevicesDialogTable();
        this.myTable.setModel(this.myTableModel);
        this.myTable.setSelectedDevices(this.myDevicesSelectedServiceGetInstance.apply(this.myProject).getDeviceKeysSelectedWithDialog());
    }

    private void initOkAction() {
        if (!this.myRunOnMultipleDevicesActionEnabledGet.getAsBoolean()) {
            this.myOKAction.setEnabled(true);
            this.myOKAction.putValue("Name", CommonBundle.getOkButtonText());
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        GroupLayout layout2 = new GroupLayout(panel2);
        JLabel label = new JLabel("Available devices");
        JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.myTable));
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)556, (int)270));
        GroupLayout.ParallelGroup horizontalGroup = layout2.createParallelGroup().addComponent(label).addComponent((Component)scrollPane);
        GroupLayout.SequentialGroup verticalGroup = layout2.createSequentialGroup().addComponent(label).addComponent((Component)scrollPane);
        layout2.setAutoCreateGaps(true);
        layout2.setHorizontalGroup(horizontalGroup);
        layout2.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout2);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
        this.myOKAction.putValue("Name", "Run");
    }

    protected void doOKAction() {
        super.doOKAction();
        assert (this.myTable != null);
        this.myDevicesSelectedServiceGetInstance.apply(this.myProject).setDevicesSelectedWithDialog(this.myTable.getSelectedDevices());
    }

    @VisibleForTesting
    @NotNull
    protected Action getOKAction() {
        Action action2 = super.getOKAction();
        if (action2 == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(7);
        }
        return action2;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "com.android.tools.idea.run.deployment.SelectMultipleDevicesDialog";
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        SelectMultipleDevicesDialogTable selectMultipleDevicesDialogTable = this.getTable();
        if (selectMultipleDevicesDialogTable == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(8);
        }
        return selectMultipleDevicesDialogTable;
    }

    @VisibleForTesting
    @NotNull
    SelectMultipleDevicesDialogTable getTable() {
        assert (this.myTable != null);
        SelectMultipleDevicesDialogTable selectMultipleDevicesDialogTable = this.myTable;
        if (selectMultipleDevicesDialogTable == null) {
            SelectMultipleDevicesDialog.$$$reportNull$$$0(9);
        }
        return selectMultipleDevicesDialogTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOnMultipleDevicesActionEnabledGet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicesSelectedServiceGetInstance";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/SelectMultipleDevicesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/SelectMultipleDevicesDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

