/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.Devices;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectDeviceAction
extends AnAction {
    @NotNull
    private final Device myDevice;
    @NotNull
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;
    private final boolean mySnapshotActionGroupChild;

    @NotNull
    static AnAction newSelectDeviceAction(@NotNull Device device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        if (device == null) {
            SelectDeviceAction.$$$reportNull$$$0(0);
        }
        if (comboBoxAction == null) {
            SelectDeviceAction.$$$reportNull$$$0(1);
        }
        return new SelectDeviceAction(device, comboBoxAction, false);
    }

    @NotNull
    static AnAction newSnapshotActionGroupChild(@NotNull Device device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        if (device == null) {
            SelectDeviceAction.$$$reportNull$$$0(2);
        }
        if (comboBoxAction == null) {
            SelectDeviceAction.$$$reportNull$$$0(3);
        }
        return new SelectDeviceAction(device, comboBoxAction, true);
    }

    private SelectDeviceAction(@NotNull Device device, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction, boolean snapshotActionGroupChild) {
        if (device == null) {
            SelectDeviceAction.$$$reportNull$$$0(4);
        }
        if (comboBoxAction == null) {
            SelectDeviceAction.$$$reportNull$$$0(5);
        }
        this.myDevice = device;
        this.mySnapshotActionGroupChild = snapshotActionGroupChild;
        this.myComboBoxAction = comboBoxAction;
    }

    @NotNull
    @VisibleForTesting
    public Device getDevice() {
        Device device = this.myDevice;
        if (device == null) {
            SelectDeviceAction.$$$reportNull$$$0(6);
        }
        return device;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectDeviceAction.$$$reportNull$$$0(7);
        }
        Presentation presentation = event.getPresentation();
        if (this.mySnapshotActionGroupChild) {
            Snapshot snapshot = this.myDevice.getSnapshot();
            presentation.setText(snapshot == null ? "No Snapshot" : snapshot.toString(), false);
            return;
        }
        presentation.setIcon(this.myDevice.getIcon());
        Collection devices2 = this.myComboBoxAction.getDevices(Objects.requireNonNull(event.getProject())).orElseThrow(AssertionError::new);
        Key key = Devices.containsAnotherDeviceWithSameName(devices2, this.myDevice) ? this.myDevice.getKey() : null;
        Snapshot snapshot = this.myComboBoxAction.areSnapshotsEnabled() ? this.myDevice.getSnapshot() : null;
        presentation.setText(Devices.getText(this.myDevice, key, snapshot), false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            SelectDeviceAction.$$$reportNull$$$0(8);
        }
        this.myComboBoxAction.setSelectedDevice(Objects.requireNonNull(event.getProject()), this.myDevice);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof SelectDeviceAction)) {
            return false;
        }
        SelectDeviceAction action2 = (SelectDeviceAction)((Object)object);
        return this.myDevice.equals(action2.myDevice) && ((Object)((Object)this.myComboBoxAction)).equals((Object)action2.myComboBoxAction) && this.mySnapshotActionGroupChild == action2.mySnapshotActionGroupChild;
    }

    public int hashCode() {
        int hashCode = this.myDevice.hashCode();
        hashCode = 31 * hashCode + ((Object)((Object)this.myComboBoxAction)).hashCode();
        hashCode = 31 * hashCode + Boolean.hashCode(this.mySnapshotActionGroupChild);
        return hashCode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBoxAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/SelectDeviceAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/SelectDeviceAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newSelectDeviceAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newSnapshotActionGroupChild";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

