/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.flags.Flag;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.run.deployment.SelectDeviceAction;
import com.android.tools.idea.run.deployment.SnapshotActionGroup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collector;
import org.jetbrains.annotations.NotNull;

final class PopupActionGroup
extends DefaultActionGroup {
    @NotNull
    private final Collection<Device> myDevices;
    @NotNull
    private final DeviceAndSnapshotComboBoxAction myComboBoxAction;

    PopupActionGroup(@NotNull Collection<Device> devices2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction) {
        if (devices2 == null) {
            PopupActionGroup.$$$reportNull$$$0(0);
        }
        if (comboBoxAction == null) {
            PopupActionGroup.$$$reportNull$$$0(1);
        }
        this(devices2, comboBoxAction, () -> ((Flag)StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED).get());
    }

    @VisibleForTesting
    PopupActionGroup(@NotNull Collection<Device> devices2, @NotNull DeviceAndSnapshotComboBoxAction comboBoxAction, @NotNull BooleanSupplier runOnMultipleDevicesActionEnabledGet) {
        if (devices2 == null) {
            PopupActionGroup.$$$reportNull$$$0(2);
        }
        if (comboBoxAction == null) {
            PopupActionGroup.$$$reportNull$$$0(3);
        }
        if (runOnMultipleDevicesActionEnabledGet == null) {
            PopupActionGroup.$$$reportNull$$$0(4);
        }
        this.myDevices = devices2;
        this.myComboBoxAction = comboBoxAction;
        Collection<AnAction> actions2 = comboBoxAction.areSnapshotsEnabled() ? this.newSelectDeviceActionsOrSnapshotActionGroups() : this.newSelectDeviceActions();
        this.addAll(actions2);
        if (!actions2.isEmpty()) {
            this.addSeparator();
        }
        ActionManager manager = ActionManager.getInstance();
        String id = runOnMultipleDevicesActionEnabledGet.getAsBoolean() ? "RunOnMultipleDevices" : "SelectMultipleDevices";
        this.add(manager.getAction(id));
        this.add(manager.getAction("Android.AdbDevicePairing"));
        this.add(manager.getAction("Android.RunAndroidAvdManager"));
        AnAction action2 = manager.getAction("DeveloperServices.ConnectionAssistant");
        if (action2 == null) {
            return;
        }
        this.addSeparator();
        this.add(action2);
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActionsOrSnapshotActionGroups() {
        Collector collector = Multimaps.toMultimap(device -> device.getKey().getDeviceKey(), device -> device, this::buildListMultimap);
        ListMultimap multimap = (ListMultimap)this.myDevices.stream().collect(collector);
        Set deviceKeys = multimap.keySet();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(1 + deviceKeys.size());
        if (!deviceKeys.isEmpty()) {
            actions2.add(ActionManager.getInstance().getAction("AvailableDevices"));
        }
        deviceKeys.stream().map(arg_0 -> ((ListMultimap)multimap).get(arg_0)).map(this::newSelectDeviceActionOrSnapshotActionGroup).forEach(actions2::add);
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            PopupActionGroup.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private ListMultimap<String, Device> buildListMultimap() {
        ListMultimap listMultimap = MultimapBuilder.hashKeys((int)this.myDevices.size()).arrayListValues().build();
        if (listMultimap == null) {
            PopupActionGroup.$$$reportNull$$$0(6);
        }
        return listMultimap;
    }

    @NotNull
    private AnAction newSelectDeviceActionOrSnapshotActionGroup(@NotNull List<Device> devices2) {
        if (devices2 == null) {
            PopupActionGroup.$$$reportNull$$$0(7);
        }
        return devices2.size() == 1 ? this.newSelectDeviceAction(devices2.get(0)) : new SnapshotActionGroup(devices2);
    }

    @NotNull
    private Collection<AnAction> newSelectDeviceActions() {
        boolean availableDevicesPresent;
        List runningDevices = ContainerUtil.filter(this.myDevices, Device::isConnected);
        List availableDevices = ContainerUtil.filter(this.myDevices, device -> !device.isConnected());
        boolean runningDevicesPresent = !runningDevices.isEmpty();
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>(1 + runningDevices.size() + 2 + availableDevices.size());
        ActionManager manager = ActionManager.getInstance();
        if (runningDevicesPresent) {
            actions2.add(manager.getAction("RunningDevices"));
        }
        runningDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        boolean bl = availableDevicesPresent = !availableDevices.isEmpty();
        if (runningDevicesPresent && availableDevicesPresent) {
            actions2.add((AnAction)Separator.create());
        }
        if (availableDevicesPresent) {
            actions2.add(manager.getAction("AvailableDevices"));
        }
        availableDevices.stream().map(this::newSelectDeviceAction).forEach(actions2::add);
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            PopupActionGroup.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private AnAction newSelectDeviceAction(@NotNull Device device) {
        if (device == null) {
            PopupActionGroup.$$$reportNull$$$0(9);
        }
        AnAction anAction = SelectDeviceAction.newSelectDeviceAction(device, this.myComboBoxAction);
        if (anAction == null) {
            PopupActionGroup.$$$reportNull$$$0(10);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBoxAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOnMultipleDevicesActionEnabledGet";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/PopupActionGroup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/PopupActionGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceActionsOrSnapshotActionGroups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildListMultimap";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceActions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newSelectDeviceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newSelectDeviceActionOrSnapshotActionGroup";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newSelectDeviceAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

