/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.KeyToConnectionTimeMap;
import com.android.tools.idea.run.deployment.Snapshot;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PhysicalDevice
extends Device {
    private static final Icon ourValidIcon = ExecutionUtil.getLiveIndicator((Icon)StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
    private static final Icon ourInvalidIcon = ExecutionUtil.getLiveIndicator((Icon)AllIcons.General.Error);

    @NotNull
    static PhysicalDevice newDevice(@NotNull ConnectedDevice device, @NotNull Function<ConnectedDevice, String> getName, @NotNull KeyToConnectionTimeMap map2) {
        if (device == null) {
            PhysicalDevice.$$$reportNull$$$0(0);
        }
        if (getName == null) {
            PhysicalDevice.$$$reportNull$$$0(1);
        }
        if (map2 == null) {
            PhysicalDevice.$$$reportNull$$$0(2);
        }
        Key key = device.getKey();
        PhysicalDevice physicalDevice = new Builder().setName(getName.apply(device)).setValid(device.isValid()).setValidityReason(device.getValidityReason()).setKey(key).setConnectionTime(map2.get(key)).setAndroidDevice(device.getAndroidDevice()).build();
        if (physicalDevice == null) {
            PhysicalDevice.$$$reportNull$$$0(3);
        }
        return physicalDevice;
    }

    private PhysicalDevice(@NotNull Builder builder2) {
        if (builder2 == null) {
            PhysicalDevice.$$$reportNull$$$0(4);
        }
        super(builder2);
    }

    @Override
    @NotNull
    Icon getIcon() {
        Icon icon2 = this.isValid() ? ourValidIcon : ourInvalidIcon;
        if (icon2 == null) {
            PhysicalDevice.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    @Override
    boolean isConnected() {
        return true;
    }

    @Override
    @Nullable
    Snapshot getSnapshot() {
        return null;
    }

    @Override
    boolean matches(@NotNull Key key) {
        if (key == null) {
            PhysicalDevice.$$$reportNull$$$0(6);
        }
        return this.getKey().matches(key);
    }

    @Override
    boolean hasKeyContainedBy(@NotNull @NotNull Collection<@NotNull Key> keys) {
        if (keys == null) {
            PhysicalDevice.$$$reportNull$$$0(7);
        }
        return keys.contains(this.getKey()) || keys.contains(this.getKey().asNonprefixedKey());
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        IDevice device = this.getDdmlibDevice();
        assert (device != null);
        Future<AndroidVersion> future2 = DeploymentApplicationService.getInstance().getVersion(device);
        if (future2 == null) {
            PhysicalDevice.$$$reportNull$$$0(8);
        }
        return future2;
    }

    @Override
    void addTo(@NotNull DeviceFutures futures2, @NotNull Project project) {
        if (futures2 == null) {
            PhysicalDevice.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PhysicalDevice.$$$reportNull$$$0(10);
        }
        futures2.getDevices().add(this.getAndroidDevice());
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof PhysicalDevice)) {
            return false;
        }
        Device device = (Device)object;
        return this.getName().equals(device.getName()) && this.isValid() == device.isValid() && Objects.equals(this.getValidityReason(), device.getValidityReason()) && this.getKey().equals(device.getKey()) && Objects.equals(this.getConnectionTime(), device.getConnectionTime()) && this.getAndroidDevice().equals(device.getAndroidDevice());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.isValid(), this.getValidityReason(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/PhysicalDevice";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/PhysicalDevice";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newDevice";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newDevice";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasKeyContainedBy";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static final class Builder
    extends Device.Builder {
        Builder() {
        }

        @NotNull
        @VisibleForTesting
        Builder setName(@NotNull String name) {
            if (name == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myName = name;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        private Builder setValid(boolean valid2) {
            this.myValid = valid2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        private Builder setValidityReason(@Nullable String validityReason) {
            this.myValidityReason = validityReason;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        @VisibleForTesting
        Builder setKey(@NotNull Key key) {
            if (key == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myKey = key;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        @VisibleForTesting
        Builder setConnectionTime(@NotNull Instant connectionTime) {
            if (connectionTime == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myConnectionTime = connectionTime;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        @VisibleForTesting
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            if (androidDevice == null) {
                Builder.$$$reportNull$$$0(8);
            }
            this.myAndroidDevice = androidDevice;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @Override
        @NotNull
        PhysicalDevice build() {
            return new PhysicalDevice(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/run/deployment/PhysicalDevice$Builder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connectionTime";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidDevice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/run/deployment/PhysicalDevice$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setValid";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setValidityReason";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setKey";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setConnectionTime";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAndroidDevice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setConnectionTime";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setAndroidDevice";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

