/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.flags.Flag;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.containers.ContainerUtil;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DevicesSelectedService {
    @VisibleForTesting
    static final String DEVICE_KEY_SELECTED_WITH_COMBO_BOX = "DeviceAndSnapshotComboBoxAction.selectedDevice";
    @VisibleForTesting
    static final String TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX = "DeviceAndSnapshotComboBoxAction.selectionTime";
    @VisibleForTesting
    static final String MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX = "DeviceAndSnapshotComboBoxAction.multipleDevicesSelected";
    @VisibleForTesting
    static final String DEVICE_KEYS_SELECTED_WITH_DIALOG = "SelectDeploymentTargetsDialog.selectedDevices";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Function<Project, PropertiesComponent> myPropertiesComponentGetInstance;
    @NotNull
    private final Clock myClock;
    @NotNull
    private final BooleanSupplier myRunOnMultipleDevicesActionEnabledGet;

    private DevicesSelectedService(@NotNull Project project) {
        if (project == null) {
            DevicesSelectedService.$$$reportNull$$$0(0);
        }
        this(project, PropertiesComponent::getInstance, Clock.systemDefaultZone(), () -> ((Flag)StudioFlags.RUN_ON_MULTIPLE_DEVICES_ACTION_ENABLED).get());
    }

    @NonInjectable
    @VisibleForTesting
    DevicesSelectedService(@NotNull Project project, @NotNull Function<Project, PropertiesComponent> propertiesComponentGetInstance, @NotNull Clock clock, @NotNull BooleanSupplier runOnMultipleDevicesActionEnabledGet) {
        if (project == null) {
            DevicesSelectedService.$$$reportNull$$$0(1);
        }
        if (propertiesComponentGetInstance == null) {
            DevicesSelectedService.$$$reportNull$$$0(2);
        }
        if (clock == null) {
            DevicesSelectedService.$$$reportNull$$$0(3);
        }
        if (runOnMultipleDevicesActionEnabledGet == null) {
            DevicesSelectedService.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myPropertiesComponentGetInstance = propertiesComponentGetInstance;
        this.myClock = clock;
        this.myRunOnMultipleDevicesActionEnabledGet = runOnMultipleDevicesActionEnabledGet;
    }

    @NotNull
    static DevicesSelectedService getInstance(@NotNull Project project) {
        if (project == null) {
            DevicesSelectedService.$$$reportNull$$$0(5);
        }
        DevicesSelectedService devicesSelectedService = (DevicesSelectedService)project.getService(DevicesSelectedService.class);
        if (devicesSelectedService == null) {
            DevicesSelectedService.$$$reportNull$$$0(6);
        }
        return devicesSelectedService;
    }

    @Nullable
    Device getDeviceSelectedWithComboBox(@NotNull List<Device> devices2) {
        if (devices2 == null) {
            DevicesSelectedService.$$$reportNull$$$0(7);
        }
        if (devices2.isEmpty()) {
            return null;
        }
        String keyAsString = this.myPropertiesComponentGetInstance.apply(this.myProject).getValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX);
        if (keyAsString == null) {
            return devices2.get(0);
        }
        Key key = Key.newKey(keyAsString);
        Optional<Device> optionalSelectedDevice = devices2.stream().filter(device -> device.matches(key)).findFirst();
        if (!optionalSelectedDevice.isPresent()) {
            return devices2.get(0);
        }
        Device selectedDevice = optionalSelectedDevice.get();
        Optional<Device> optionalConnectedDevice = devices2.stream().filter(Device::isConnected).findFirst();
        if (!optionalConnectedDevice.isPresent()) {
            return selectedDevice;
        }
        Device connectedDevice = optionalConnectedDevice.get();
        Instant connectionTime = connectedDevice.getConnectionTime();
        assert (connectionTime != null) : "connected device \"" + connectedDevice + "\" has a null connection time";
        if (this.getTimeDeviceWasSelectedWithComboBox(selectedDevice).isBefore(connectionTime)) {
            return connectedDevice;
        }
        return selectedDevice;
    }

    @NotNull
    private Instant getTimeDeviceWasSelectedWithComboBox(@NotNull Device device) {
        String time2;
        if (device == null) {
            DevicesSelectedService.$$$reportNull$$$0(8);
        }
        if ((time2 = this.myPropertiesComponentGetInstance.apply(this.myProject).getValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX)) == null) {
            Logger.getInstance(DevicesSelectedService.class).warn("selected device \"" + device + "\" has a null selection time string");
            Instant instant = Instant.MIN;
            if (instant == null) {
                DevicesSelectedService.$$$reportNull$$$0(9);
            }
            return instant;
        }
        Instant instant = Instant.parse(time2);
        if (instant == null) {
            DevicesSelectedService.$$$reportNull$$$0(10);
        }
        return instant;
    }

    void setDeviceSelectedWithComboBox(@Nullable Device deviceSelectedWithComboBox) {
        PropertiesComponent properties2 = this.myPropertiesComponentGetInstance.apply(this.myProject);
        properties2.unsetValue(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX);
        if (deviceSelectedWithComboBox == null) {
            properties2.unsetValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX);
            properties2.unsetValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX);
        } else {
            properties2.setValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX, deviceSelectedWithComboBox.getKey().toString());
            properties2.setValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX, this.myClock.instant().toString());
        }
    }

    boolean isMultipleDevicesSelectedInComboBox() {
        return !this.myRunOnMultipleDevicesActionEnabledGet.getAsBoolean() && this.myPropertiesComponentGetInstance.apply(this.myProject).getBoolean(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX);
    }

    void setMultipleDevicesSelectedInComboBox(boolean multipleDevicesSelectedInComboBox) {
        PropertiesComponent properties2 = this.myPropertiesComponentGetInstance.apply(this.myProject);
        properties2.unsetValue(TIME_DEVICE_KEY_WAS_SELECTED_WITH_COMBO_BOX);
        properties2.unsetValue(DEVICE_KEY_SELECTED_WITH_COMBO_BOX);
        if (!multipleDevicesSelectedInComboBox) {
            properties2.unsetValue(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX);
        } else {
            properties2.setValue(MULTIPLE_DEVICES_SELECTED_IN_COMBO_BOX, true);
        }
    }

    boolean isDialogSelectionEmpty() {
        return !this.myPropertiesComponentGetInstance.apply(this.myProject).isValueSet(DEVICE_KEYS_SELECTED_WITH_DIALOG);
    }

    @NotNull
    List<Device> getDevicesSelectedWithDialog(@NotNull List<Device> devices2) {
        if (devices2 == null) {
            DevicesSelectedService.$$$reportNull$$$0(11);
        }
        Set<Key> keys = this.getDeviceKeysSelectedWithDialog();
        List list = ContainerUtil.filter(devices2, device -> device.hasKeyContainedBy(keys));
        if (list == null) {
            DevicesSelectedService.$$$reportNull$$$0(12);
        }
        return list;
    }

    void setDevicesSelectedWithDialog(@NotNull List<Device> devicesSelectedWithDialog) {
        if (devicesSelectedWithDialog == null) {
            DevicesSelectedService.$$$reportNull$$$0(13);
        }
        this.setDeviceKeysSelectedWithDialog(devicesSelectedWithDialog.stream().map(Device::getKey));
    }

    @NotNull
    Set<Key> getDeviceKeysSelectedWithDialog() {
        Object[] keys = this.myPropertiesComponentGetInstance.apply(this.myProject).getValues(DEVICE_KEYS_SELECTED_WITH_DIALOG);
        if (keys == null) {
            Set<Key> set = Collections.emptySet();
            if (set == null) {
                DevicesSelectedService.$$$reportNull$$$0(14);
            }
            return set;
        }
        assert (!Arrays.asList(keys).contains("")) : Arrays.toString(keys);
        Set<Key> set = Arrays.stream(keys).map(Key::newKey).collect(Collectors.toSet());
        if (set == null) {
            DevicesSelectedService.$$$reportNull$$$0(15);
        }
        return set;
    }

    void setDeviceKeysSelectedWithDialog(@NotNull Set<Key> deviceKeysSelectedWithDialog) {
        if (deviceKeysSelectedWithDialog == null) {
            DevicesSelectedService.$$$reportNull$$$0(16);
        }
        this.setDeviceKeysSelectedWithDialog(deviceKeysSelectedWithDialog.stream());
    }

    private void setDeviceKeysSelectedWithDialog(@NotNull Stream<Key> stream) {
        if (stream == null) {
            DevicesSelectedService.$$$reportNull$$$0(17);
        }
        String[] array = (String[])stream.map(Object::toString).toArray(String[]::new);
        PropertiesComponent properties2 = this.myPropertiesComponentGetInstance.apply(this.myProject);
        if (array.length == 0) {
            properties2.unsetValue(DEVICE_KEYS_SELECTED_WITH_DIALOG);
        } else {
            properties2.setValues(DEVICE_KEYS_SELECTED_WITH_DIALOG, array);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesComponentGetInstance";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clock";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runOnMultipleDevicesActionEnabledGet";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/DevicesSelectedService";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicesSelectedWithDialog";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceKeysSelectedWithDialog";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/DevicesSelectedService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeDeviceWasSelectedWithComboBox";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevicesSelectedWithDialog";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceKeysSelectedWithDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeviceSelectedWithComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTimeDeviceWasSelectedWithComboBox";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDevicesSelectedWithDialog";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setDevicesSelectedWithDialog";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setDeviceKeysSelectedWithDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

