/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.deployment.AndroidExecutionTarget;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.util.containers.ContainerUtil;
import icons.StudioIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class DeviceAndSnapshotComboBoxExecutionTarget
extends AndroidExecutionTarget {
    @NotNull
    private final @NotNull Collection<@NotNull Key> myKeys;
    @NotNull
    private final AsyncDevicesGetter myDevicesGetter;

    DeviceAndSnapshotComboBoxExecutionTarget(@NotNull @NotNull Set<@NotNull Key> keys, @NotNull AsyncDevicesGetter devicesGetter) {
        if (keys == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(0);
        }
        if (devicesGetter == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(1);
        }
        this.myKeys = keys;
        this.myDevicesGetter = devicesGetter;
    }

    @Override
    public boolean isApplicationRunning(@NotNull String appPackage) {
        if (appPackage == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(2);
        }
        return this.deviceStream().anyMatch(device -> device.isRunning(appPackage));
    }

    @Override
    public int getAvailableDeviceCount() {
        return (int)this.deviceStream().count();
    }

    @Override
    @NotNull
    public Collection<IDevice> getRunningDevices() {
        Collection collection2 = this.deviceStream().map(Device::getDdmlibDevice).filter(Objects::nonNull).collect(Collectors.toList());
        if (collection2 == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(3);
        }
        return collection2;
    }

    @NotNull
    private @NotNull Stream<@NotNull Device> deviceStream() {
        Stream stream = this.myDevicesGetter.get().map(this::filteredStream).orElseGet(Stream::empty);
        if (stream == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(4);
        }
        return stream;
    }

    @NotNull
    private @NotNull Stream<@NotNull Device> filteredStream(@NotNull @NotNull Collection<@NotNull Device> devices2) {
        if (devices2 == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(5);
        }
        Stream<Device> stream = devices2.stream().filter(device -> device.hasKeyContainedBy(this.myKeys));
        if (stream == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    public String getId() {
        String string = this.myKeys.stream().sorted().map(Object::toString).collect(Collectors.joining(", ", "device_and_snapshot_combo_box_target[", "]"));
        if (string == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        List<Device> devices2 = this.getDeploymentDevices();
        switch (devices2.size()) {
            case 0: {
                return "No Devices";
            }
            case 1: {
                String string = devices2.get(0).getName();
                if (string == null) {
                    DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(8);
                }
                return string;
            }
        }
        return "Multiple Devices";
    }

    @NotNull
    public Icon getIcon() {
        List<Device> devices2 = this.getDeploymentDevices();
        if (devices2.size() == 1) {
            Icon icon2 = devices2.get(0).getIcon();
            if (icon2 == null) {
                DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(9);
            }
            return icon2;
        }
        Icon icon3 = StudioIcons.DeviceExplorer.MULTIPLE_DEVICES;
        if (icon3 == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(10);
        }
        return icon3;
    }

    @NotNull
    private @NotNull List<@NotNull Device> getDeploymentDevices() {
        List list = this.myDevicesGetter.get().map(this::filteredList).orElseGet(Collections::emptyList);
        if (list == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private @NotNull List<@NotNull Device> filteredList(@NotNull @NotNull Collection<@NotNull Device> devices2) {
        if (devices2 == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.filter(devices2, device -> device.hasKeyContainedBy(this.myKeys));
        if (list == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(13);
        }
        return list;
    }

    public boolean canRun(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            DeviceAndSnapshotComboBoxExecutionTarget.$$$reportNull$$$0(14);
        }
        return configuration instanceof AndroidRunConfigurationBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devicesGetter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appPackage";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxExecutionTarget";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/DeviceAndSnapshotComboBoxExecutionTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningDevices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "deviceStream";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentDevices";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationRunning";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filteredStream";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "filteredList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

