/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AndroidDebugBridge;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.SerialNumber;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConnectedDevicesTask
implements AsyncSupplier<List<ConnectedDevice>> {
    @NotNull
    private final AndroidDebugBridge myAndroidDebugBridge;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final Function<IDevice, AndroidDevice> myAndroidDeviceFactory;

    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, @Nullable LaunchCompatibilityChecker checker2) {
        if (androidDebugBridge == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(0);
        }
        this(androidDebugBridge, checker2, AppExecutorUtil.getAppExecutorService(), device -> new ConnectedAndroidDevice((IDevice)device, null));
    }

    @VisibleForTesting
    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, @Nullable LaunchCompatibilityChecker checker2, @NotNull Executor executor, @NotNull Function<IDevice, AndroidDevice> androidDeviceFactory) {
        if (androidDebugBridge == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(2);
        }
        if (androidDeviceFactory == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(3);
        }
        this.myAndroidDebugBridge = androidDebugBridge;
        this.myChecker = checker2;
        this.myExecutor = executor;
        this.myAndroidDeviceFactory = androidDeviceFactory;
    }

    @Override
    @NotNull
    public ListenableFuture<List<ConnectedDevice>> get() {
        ListenableFuture listenableFuture = Futures.transform(this.myAndroidDebugBridge.getConnectedDevices(), this::newConnectedDevices, (Executor)this.myExecutor);
        if (listenableFuture == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(4);
        }
        return listenableFuture;
    }

    @NotNull
    private @NotNull List<@NotNull ConnectedDevice> newConnectedDevices(@NotNull @NotNull Collection<@NotNull IDevice> devices2) {
        if (devices2 == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(5);
        }
        List<ConnectedDevice> list = devices2.stream().filter(IDevice::isOnline).map(this::newConnectedDevice).collect(Collectors.toList());
        if (list == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private ConnectedDevice newConnectedDevice(@NotNull IDevice ddmlibDevice) {
        if (ddmlibDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(7);
        }
        AndroidDevice androidDevice = this.myAndroidDeviceFactory.apply(ddmlibDevice);
        ConnectedDevice.Builder builder2 = new ConnectedDevice.Builder().setName(ConnectedDevicesTask.composeDeviceName(ddmlibDevice)).setKey(ConnectedDevicesTask.newKey(ddmlibDevice)).setAndroidDevice(androidDevice);
        if (this.myChecker == null) {
            ConnectedDevice connectedDevice = builder2.build();
            if (connectedDevice == null) {
                ConnectedDevicesTask.$$$reportNull$$$0(8);
            }
            return connectedDevice;
        }
        LaunchCompatibility compatibility = this.myChecker.validate(androidDevice);
        ConnectedDevice connectedDevice = builder2.setValid(!compatibility.isCompatible().equals((Object)ThreeState.NO)).setValidityReason(compatibility.getReason()).build();
        if (connectedDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(9);
        }
        return connectedDevice;
    }

    @NotNull
    private static String composeDeviceName(@NotNull IDevice ddmlibDevice) {
        String avdName;
        if (ddmlibDevice == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(10);
        }
        if (ddmlibDevice.isEmulator() && (avdName = ddmlibDevice.getAvdName()) != null && !avdName.equals("<build>")) {
            String string = avdName;
            if (string == null) {
                ConnectedDevicesTask.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = ddmlibDevice.getSerialNumber();
        if (string == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static Key newKey(@NotNull IDevice device) {
        if (device == null) {
            ConnectedDevicesTask.$$$reportNull$$$0(13);
        }
        if (!device.isEmulator()) {
            return new SerialNumber(device.getSerialNumber());
        }
        String path2 = device.getAvdPath();
        if (path2 != null) {
            return new VirtualDevicePath(path2);
        }
        String name = device.getAvdName();
        if (name != null && !name.equals("<build>")) {
            return new VirtualDeviceName(name);
        }
        return new SerialNumber(device.getSerialNumber());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDebugBridge";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidDeviceFactory";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/deployment/ConnectedDevicesTask";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ddmlibDevice";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/deployment/ConnectedDevicesTask";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newConnectedDevices";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newConnectedDevice";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "composeDeviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newConnectedDevices";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newConnectedDevice";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "composeDeviceName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

